package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.DashBoardConstants;
import fr.onema.sispea.service.data.DashBoardDto;
import fr.onema.sispea.service.data.DashBoardTabDto;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.ExerciseService;
import fr.onema.sispea.service.data.IndicatorDto;
import fr.onema.sispea.service.data.IndicatorService;
import fr.onema.sispea.service.data.MissionsCombining;
import fr.onema.sispea.service.data.SPEALotService;
import fr.onema.sispea.service.data.SPEALotStatus;
import fr.onema.sispea.service.referential.CompetenceDto;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.search.SearchService;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.search.bean.BackType;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * This action handles the Dashboard.
 *
 * @author CS
 */
public abstract class AbstractDashboardAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

//    private static final Logger logger = Logger.getLogger(DashboardAction.class);

    @Autowired
    protected transient IndicatorService indicatorService;

    @Autowired
    protected transient ExerciseService exerciseService;

    @Autowired
    protected transient ReferentialService referentialService;

    @Autowired
    protected transient SearchService searchService;

    @Autowired
    protected transient SPEALotService speaLotService;

    /**
     * performance indicators list
     */
    protected List<IndicatorDto> indictorList;

    /**
     * the chosen exercise Id
     */
    protected Integer chosenExerciseId;

    /**
     * the chosen exercise
     */
    protected ExerciseDto exercise;

    /**
     * the chosen competence
     */
    protected CompetenceDto competence;

    /**
     * the exercise list
     */
    protected List<ExerciseDto> exercises;

    /**
     * the chosen competence Id
     */
    protected Integer competenceId;

    /**
     * the chosen tab order
     */
    protected Integer chosenTabOrder;

    /**
     * the available tab list
     */
    protected List<DashBoardTabDto> tabs;

    /**
     * The competence list
     */
    protected List<CompetenceDto> competences = new ArrayList<>();

    /**
     * the chosen territory Id
     */
    protected Integer territoryId;

    /**
     * the chosen territory
     */
    protected TerritoryDto territory;

    /**
     * the available territory list
     */
    protected List<TerritoryDto> territories;

    /**
     * The territory Id to select
     */
    protected Integer selectionId;

    /**
     * the dashboard
     */
    protected DashBoardDto dashBoard;

    protected Map<String, String> competenceList;

    protected Map<String, String> territoryList;

    protected Map<String, String> exerciseList;

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("Dashboard");
//        }
//
//        // result
//        return Action.SUCCESS;
//
//    }

    /**
     * load exercises and chosen one
     *
     * @throws SispeaException
     */
    protected void loadExercises() throws SispeaException {

        // check chosen exercise
        if (chosenExerciseId == null) {
            chosenExerciseId = exerciseService.getCurrentExerciseId();
        }

        // read exercises
        exercises = exerciseService.readExercises(); // AThimel 28/07/15 Cannot use  readExercisesMapAsc because "exercises" is a class variable

        // read selected exercise
        exercise = exerciseService.readExercise(chosenExerciseId);

        final Map<String, String> tmp = new TreeMap<>();
        for (ExerciseDto lExercise : exercises) {
            tmp.put(lExercise.getId().toString(), lExercise.getYear().toString());
        }
        // Declare a Map with comparator otherwise, sort is made by keys, not by values
        exerciseList = new TreeMap<>(new Comparator<String>() {

            @Override
            public int compare(String o1, String o2) {
                return tmp.get(o1).compareTo(tmp.get(o2));
            }
        });
        exerciseList.putAll(tmp);

    }

    /**
     * load competence and indicators into indictorList_
     *
     * @throws SispeaException
     */
    protected void loadIndicators() throws SispeaException {

        // default competence
        if (competenceId == null) {
            competenceId = CompetenceDto.COMPETENCE_DRINKING_WATER_ID;
        }

        // load competences
        competenceList = new TreeMap<>();
        List<CompetenceDto> lCompetences = referentialService.readCompetences();
        for (CompetenceDto lCompetence : lCompetences) {
            competenceList.put(lCompetence.getId().toString(), lCompetence.getName());
            if (competenceId.equals(lCompetence.getId())) {
                competences.add(lCompetence);
                competence = lCompetence;
            }
        }

        // load indicators
        indictorList = indicatorService.readPIs(competenceId);
        indictorList.addAll(indicatorService.readDIs(competenceId));

        // sort
        Collections.sort(indictorList);
    }

    /**
     * loads available territories into territories_ list
     *
     * @throws SispeaException
     */
    protected void loadTerritories() throws SispeaException {

        // init
        territories = new ArrayList<>();

        if (selectionId != null) {
            territoryId = selectionId;
            selectionId = null;
        }

        // add current user territory
        // and check chosen territory id
        TerritoryDto lTerritory = getCurrentUserTerritory();
        if (lTerritory != null) {
            // add user's reference territory to list
            territories.add(lTerritory);
            // if no territory selected -> select user's reference territory
            if (territoryId == null || territoryId.equals(lTerritory.getId())) {
                territoryId = lTerritory.getId();
                territory = lTerritory;
            }
        }

        // add user's selections : user is connected so load from DB
        // check for selected territory
        List<TerritoryDto> lSelection = referentialService.readUserSelections(getCurrentUser());
        for (TerritoryDto lSelectedTerritory : lSelection) {
            // add territory
            territories.add(lSelectedTerritory);

            // check if selected territory if this one
            if (territoryId != null && territoryId.equals(lSelectedTerritory.getId())) {
                territory = lSelectedTerritory;
            }
        }

        // check that chosen territory is set
        if (territoryId != null && territory == null) {
            throw new SispeaException(getText("fr.onema.sispea.jsp.admin.dashboard.message.wrongTerritoryId"));
        }

        territoryList = new TreeMap<>();
        for (TerritoryDto t : territories) {
            territoryList.put(t.getId().toString(), t.getName());
        }

    }

    /**
     * @return a list of available status
     */
    public List<SPEALotStatus> getStatusList() {

        List<SPEALotStatus> lRes = new ArrayList<>();
        Collections.addAll(lRes, SPEALotStatus.values());
        return lRes;

    }

    /**
     * @return a list of available exercise
     */
    public Map<String, String> getExerciseList() throws SispeaException {
        return exerciseList;
//        //init tmp not sorted by values map
//        final Map<String, String> tmp = new TreeMap<>();
//
//        for (ExerciseDto lExercise : exercises) {
//            tmp.put(lExercise.getId().toString(), lExercise.getYear().toString());
//        }
//        // Declare a Map with comparator otherwise, sort is made by keys, not by values
//        final Map<String, String> lRes = new TreeMap<>(new Comparator<String>() {
//
//            public int compare(String o1, String o2) {
//                return tmp.get(o1).compareTo(tmp.get(o2));
//            }
//        });
//        lRes.putAll(tmp);
//        return lRes;
    }

    public Map<String, String> getTerritoryList() throws SispeaException {
        return territoryList;
//        //init list
//        Map<String, String> lRes = new TreeMap<>();
//
//        // build display map
//        for (TerritoryDto lTerritory : territories) {
//            lRes.put(lTerritory.getId().toString(), lTerritory.getName());
//        }
//
//        return lRes;
    }

//    public Map<String, String> getTabList() throws SispeaException {
//
//        //init list
//        Map<String, String> lRes = new TreeMap<>();
//
//        // build display map
//        for (DashBoardTabDto lDashBoardTab : getTabs(getCurrentUser().isGeneralAdmin())) {
//            lRes.put(lDashBoardTab.getOrder().toString(), getText(lDashBoardTab.getLabelKey()));
//        }
//
//        return lRes;
//    }

    public Map<String, String> getCompetenceList() throws SispeaException {
        return competenceList;
//        //init list
//        Map<String, String> lRes = new TreeMap<>();
//
//        // add all competences
//        //lRes.put(Competence.ALL_COMPETENCES.toString(), getText("fr.onema.sispea.jsp.admin.dashboard.field.allCompetences"));
//
//        // load competences
//        List<CompetenceDto> lCompetences = referentialService.readCompetences();
//
//        // add competences
//        for (CompetenceDto lCompetence : lCompetences) {
//            lRes.put(lCompetence.getId().toString(), lCompetence.getName());
//        }
//
//        return lRes;
    }

    public List<MissionsCombining> getMissionsList(int pCompetenceId) throws SispeaException {

        //init list
        List<MissionsCombining> lRes = new ArrayList<>();

        // build associations
        for (MissionsCombining lMissionsCombining : MissionsCombining.values()) {

            if ((pCompetenceId == CompetenceDto.ALL_COMPETENCES)
                || (lMissionsCombining.getCompetenceId() == pCompetenceId)) {
                lRes.add(lMissionsCombining);
            }
        }

        return lRes;
    }

    public Integer getGeneralTabId() {
        return DashBoardConstants.TAB_ID_GENERAL;
    }


    public Integer getBackPageId() {
        return BackType.dashboard.getId();
    }

    public List<IndicatorDto> getIndictorList() {
        return indictorList;
    }

    public Integer getChosenExerciseId() {
        return chosenExerciseId;
    }

    public void setChosenExerciseId(Integer pChosenExerciseId) {
        chosenExerciseId = pChosenExerciseId;
    }

    public Integer getCompetenceId() {
        return competenceId;
    }

    public void setCompetenceId(Integer pCompetenceId) {
        competenceId = pCompetenceId;
    }

    public Integer getChosenTabOrder() {
        return chosenTabOrder;
    }

    public void setChosenTabOrder(Integer pChosenTabOrder) {
        chosenTabOrder = pChosenTabOrder;
    }

    public List<DashBoardTabDto> getTabs() {

        if (CollectionUtils.isEmpty(tabs)) {
            tabs = searchService.buildDashBoardTabs(getCurrentUser());
        }

//        // init ?
//        if (tabs == null || tabs.size() == 0) {
//            // init !
//            tabs = new ArrayList<>();
//            tabs.add(new DashBoardTabDto(DashBoardConstants.TAB_ID_GENERAL, DashBoardConstants.TAB_ORDER_GENERAL, DashBoardConstants.TAB_CODE_GENERAL, false));
//            tabs.add(new DashBoardTabDto(DashBoardConstants.TAB_ID_MISSION, DashBoardConstants.TAB_ORDER_MISSION, DashBoardConstants.TAB_CODE_MISSION, false));
//            if (pUserIsGeneralAdmin) {
//                tabs.add(new DashBoardTabDto(DashBoardConstants.TAB_ID_MANAGEMENT_MODE, DashBoardConstants.TAB_ORDER_MANAGEMENT_MODE, DashBoardConstants.TAB_CODE_MANAGEMENT_MODE, false));
//            }
//            tabs.add(new DashBoardTabDto(DashBoardConstants.TAB_ID_STATUS, DashBoardConstants.TAB_ORDER_STATUS, DashBoardConstants.TAB_CODE_STATUS, false));
//            tabs.add(new DashBoardTabDto(DashBoardConstants.TAB_ID_INDICATORS, DashBoardConstants.TAB_ORDER_INDICATORS, DashBoardConstants.TAB_CODE_INDICATORS, false));
//            tabs.add(new DashBoardTabDto(DashBoardConstants.TAB_ID_MANDATES, DashBoardConstants.TAB_ORDER_MANDATES, DashBoardConstants.TAB_CODE_MANDATES, false));
//            tabs.add(new DashBoardTabDto(DashBoardConstants.TAB_ID_RPQS, DashBoardConstants.TAB_ORDER_RPQS, DashBoardConstants.TAB_CODE_RPQS, false));
//            tabs.add(new DashBoardTabDto(DashBoardConstants.TAB_ID_REFERENTIAL, DashBoardConstants.TAB_ORDER_REFERENTIAL, DashBoardConstants.TAB_CODE_REFERENTIAL, false));
//        }
        return tabs;
    }

    public void setTabs(List<DashBoardTabDto> pTabs) {
        tabs = pTabs;
    }

    public Integer getTerritoryId() {
        return territoryId;
    }

    public void setTerritoryId(Integer pTerritoryId) {
        territoryId = pTerritoryId;
    }

    public List<CompetenceDto> getCompetences() {
        return competences;
    }

    public void setCompetences(List<CompetenceDto> pCompetences) {
        competences = pCompetences;
    }

    public DashBoardDto getDashBoard() {
        return dashBoard;
    }

    public void setDashBoard(DashBoardDto dashBoard) {
        dashBoard = dashBoard;
    }

    public List<TerritoryDto> getTerritories() {
        return territories;
    }

    public void setTerritories(List<TerritoryDto> pTerritories) {
        territories = pTerritories;
    }

    public TerritoryDto getTerritory() {
        return territory;
    }

    public void setTerritory(TerritoryDto pTerritory) {
        territory = pTerritory;
    }

    public ExerciseDto getExercise() {
        return exercise;
    }

    public void setExercise(ExerciseDto pExercise) {
        exercise = pExercise;
    }

    public CompetenceDto getCompetence() {
        return competence;
    }

    public void setCompetence(CompetenceDto pCompetence) {
        competence = pCompetence;
    }

    public Integer getSelectionId() {
        return selectionId;
    }

    public void setSelectionId(Integer pSelectionId) {
        selectionId = pSelectionId;
    }
}
