/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools.db.reference;

import fr.ird.t3.entities.T3EntityHelper;
import fr.ird.t3.entities.reference.Country;
import fr.ird.t3.entities.reference.Ocean;
import fr.ird.t3.entities.reference.SchoolType;
import fr.ird.t3.entities.reference.SchoolTypeDAO;
import fr.ird.t3.entities.reference.SetDuration;
import fr.ird.t3.entities.reference.SetDurationDAO;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.services.ioc.InjectFromDAO;
import fr.ird.t3.tools.db.reference.AbstractReferenceImporter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;

public class SetDurationImporter
extends AbstractReferenceImporter<SetDuration> {
    private static final Log log = LogFactory.getLog(SetDurationImporter.class);
    @InjectDAO(entityType=SetDuration.class)
    protected SetDurationDAO dao;
    @InjectDAO(entityType=SchoolType.class)
    protected SchoolTypeDAO schoolTypeDAO;
    @InjectFromDAO(entityType=Ocean.class)
    protected List<Ocean> oceans;
    @InjectFromDAO(entityType=Country.class)
    protected List<Country> countries;
    protected SchoolType schoolTypeObject;
    protected SchoolType schoolTypeFree;
    protected Map<Integer, Ocean> oceanByCode;
    protected Map<Integer, Country> countryBycode;

    @Override
    protected void before() throws TopiaException {
        if (CollectionUtils.isEmpty(this.oceans)) {
            throw new IllegalStateException("No ocean found in db.");
        }
        if (CollectionUtils.isEmpty(this.countries)) {
            throw new IllegalStateException("No country found in db.");
        }
        this.schoolTypeObject = this.schoolTypeDAO.findByCode(1);
        this.schoolTypeFree = this.schoolTypeDAO.findByCode(2);
        long nb = this.dao.count();
        if (nb > 0L) {
            throw new IllegalStateException("Some Setduration found in db.");
        }
        this.oceanByCode = T3EntityHelper.splitBycode(this.oceans);
        this.countryBycode = T3EntityHelper.splitBycode(this.countries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<SetDuration> loadFile(File inputFile) throws TopiaException, IOException {
        ArrayList<SetDuration> result = new ArrayList<SetDuration>();
        LineNumberReader reader = new LineNumberReader(new FileReader(inputFile));
        try {
            String line;
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] cells;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Incoming line : " + line));
                }
                int lineNumber = reader.getLineNumber();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("At Line [" + lineNumber + "] Data line to treat : " + line));
                }
                if ((cells = line.trim().split("\\s+")).length != 9) {
                    throw new IllegalStateException("At line [" + lineNumber + "], data line must have 9 cells but had here " + cells.length);
                }
                this.loadLine(result, lineNumber, cells);
            }
        }
        finally {
            reader.close();
        }
        return result;
    }

    protected void loadLine(List<SetDuration> result, int lineNumber, String[] cells) throws TopiaException {
        int oceanCode = this.convertToInt(cells, lineNumber, 0);
        Ocean ocean = this.getOcean(this.oceanByCode, oceanCode, lineNumber);
        int countryCode = this.convertToInt(cells, lineNumber, 1);
        Country country = this.getCountry(this.countryBycode, countryCode, lineNumber);
        int year = this.convertToInt(cells, lineNumber, 2);
        float nullSetValue = this.convertToFloat(cells, lineNumber, 3);
        float a = this.convertToFloat(cells, lineNumber, 4);
        float b = this.convertToFloat(cells, lineNumber, 5);
        SetDuration setDuration = (SetDuration)this.dao.create(new Object[]{"ocean", ocean, "country", country, "schoolType", this.schoolTypeObject, "year", year, "nullSetValue", Float.valueOf(nullSetValue), "parameterA", Float.valueOf(a), "parameterB", Float.valueOf(b)});
        result.add(setDuration);
        nullSetValue = this.convertToFloat(cells, lineNumber, 6);
        a = this.convertToFloat(cells, lineNumber, 7);
        b = this.convertToFloat(cells, lineNumber, 8);
        setDuration = (SetDuration)this.dao.create(new Object[]{"ocean", ocean, "country", country, "schoolType", this.schoolTypeFree, "year", year, "nullSetValue", Float.valueOf(nullSetValue), "parameterA", Float.valueOf(a), "parameterB", Float.valueOf(b)});
        result.add(setDuration);
    }
}

