/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools.db.zone;

import fr.ird.t3.entities.T3DAOHelper;
import fr.ird.t3.entities.reference.zone.ZoneCWP;
import fr.ird.t3.entities.reference.zone.ZoneCWPDAO;
import fr.ird.t3.tools.db.zone.AbstractZoneImporter;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ZoneCWPImporter
extends AbstractZoneImporter<ZoneCWP, ZoneCWPDAO> {
    private static final Log log = LogFactory.getLog(ZoneCWPImporter.class);
    public static final String INSERT_LINE_PATTERN = "INSERT INTO ZONECWP(TOPIAID, TOPIAVERSION, TOPIACREATEDATE, VERSIONID, VERSIONLIBELLE, VERSIONSTARTDATE,  VERSIONENDDATE, QUADRANT, SQUARELATITUDE, SQUARELONGITUDE, MINLATITUDE, MAXLATITUDE, MINLONGITUDE, MAXLONGITUDE, THE_GEOM) VALUES ('%s', %s, %s, '%s', '%s', %s, %s, %s, %s, %s, %s, %s, %s, %s,'%s');";

    public ZoneCWPImporter(String versionId, String versionLibelle, Date versionStartDate, Date versionEndDate) {
        super(versionId, versionLibelle, versionStartDate, versionEndDate, 8);
    }

    @Override
    protected ZoneCWPDAO getDAO(TopiaContext tx) throws TopiaException {
        return T3DAOHelper.getZoneCWPDAO((TopiaContext)tx);
    }

    @Override
    protected String loadLine(List<ZoneCWP> result, int lineNumber, String[] cells) throws TopiaException {
        int quadrant = this.convertToInt(cells, lineNumber, 0);
        int squareLatitude = this.convertToInt(cells, lineNumber, 1);
        int squareLongitude = this.convertToInt(cells, lineNumber, 2);
        int minLatitude = this.convertToInt(cells, lineNumber, 3);
        int maxLatitude = this.convertToInt(cells, lineNumber, 4);
        int minLongitude = this.convertToInt(cells, lineNumber, 5);
        int maxLongitude = this.convertToInt(cells, lineNumber, 6);
        String postgis = this.convertToString(cells, lineNumber, 7);
        ZoneCWP zone = (ZoneCWP)((ZoneCWPDAO)this.dao).create(new Object[]{"quadrant", quadrant, "squareLatitude", squareLatitude, "squareLongitude", squareLongitude, "minLatitude", minLatitude, "maxLatitude", maxLatitude, "minLongitude", minLongitude, "maxLongitude", maxLongitude});
        result.add(zone);
        String insertLine = String.format(INSERT_LINE_PATTERN, zone.getTopiaId(), zone.getTopiaVersion(), this.formatDate(zone.getTopiaCreateDate()), this.versionId, this.versionLibelle, this.versionStartDate, this.versionEndDate, zone.getQuadrant(), zone.getSquareLatitude(), zone.getSquareLongitude(), zone.getMinLatitude(), zone.getMaxLatitude(), zone.getMinLongitude(), zone.getMaxLongitude(), postgis);
        if (log.isDebugEnabled()) {
            log.debug((Object)insertLine);
        }
        return insertLine;
    }
}

