/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.tools.db.zone;

import fr.ird.t3.entities.T3DAOHelper;
import fr.ird.t3.entities.reference.zone.ZoneEE;
import fr.ird.t3.entities.reference.zone.ZoneEEDAO;
import fr.ird.t3.tools.db.zone.AbstractZoneImporter;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ZoneEEImporter
extends AbstractZoneImporter<ZoneEE, ZoneEEDAO> {
    private static final Log log = LogFactory.getLog(ZoneEEImporter.class);
    public static final String INSERT_LINE_PATTERN = "INSERT INTO ZONEEE(TOPIAID, TOPIAVERSION, TOPIACREATEDATE, VERSIONID, VERSIONLIBELLE, VERSIONSTARTDATE, VERSIONENDDATE, GID, CODE, LIBELLE, THE_GEOM) VALUES ('%s', %s, %s, '%s', '%s', %s, %s, %s, %s, '%s', '%s');";

    public ZoneEEImporter(String versionId, String versionLibelle, Date versionStartDate, Date versionEndDate) {
        super(versionId, versionLibelle, versionStartDate, versionEndDate, 4);
    }

    @Override
    protected ZoneEEDAO getDAO(TopiaContext tx) throws TopiaException {
        return T3DAOHelper.getZoneEEDAO((TopiaContext)tx);
    }

    @Override
    protected String loadLine(List<ZoneEE> result, int lineNumber, String[] cells) throws TopiaException {
        int gid = this.convertToInt(cells, lineNumber, 0);
        int zoneCode = this.convertToInt(cells, lineNumber, 1);
        String libelle = this.convertToString(cells, lineNumber, 2);
        String postgis = this.convertToString(cells, lineNumber, 3);
        ZoneEE zone = (ZoneEE)((ZoneEEDAO)this.dao).create(new Object[]{"gid", gid, "libelle", libelle, "code", zoneCode});
        result.add(zone);
        String insertLine = String.format(INSERT_LINE_PATTERN, zone.getTopiaId(), zone.getTopiaVersion(), this.formatDate(zone.getTopiaCreateDate()), this.versionId, this.versionLibelle, this.versionStartDate, this.versionEndDate, zone.getGid(), zone.getCode(), zone.getLibelle().replaceAll("'", "''"), postgis);
        if (log.isDebugEnabled()) {
            log.debug((Object)insertLine);
        }
        return insertLine;
    }
}

