/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.maven.plugins.toolbox;

import fr.ird.observe.maven.plugins.toolbox.ToolboxMojoSupport;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.atteo.evo.inflector.English;
import org.nuiton.plugin.PluginHelper;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Mojo(name="generate-i18n-types", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
class GenerateI18nTypesMojo
extends ToolboxMojoSupport {
    @Parameter(property="generateI18nTypes.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(property="generateI18nTypes.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="generateI18nTypes.packageName")
    private String packageName;
    @Parameter(property="generateI18nTypes.className", defaultValue="I18nTypeHelper", required=true)
    private String className;
    @Parameter(property="generateI18nTypes.prefix")
    private String prefix;
    @Parameter(property="generateI18nTypes.removeSuffix")
    private String removeSuffix;
    @Parameter(property="generateI18nTypes.skipSuffix")
    private String skipSuffix;
    @Parameter(property="generateI18nTypes.outputDirectory", defaultValue="${basedir}/target/generated-sources/java", required=true)
    private File outputDirectory;
    private Set<String> typeNames;

    GenerateI18nTypesMojo() {
    }

    @Override
    protected Path createOutputFile() throws IOException {
        if (this.packageName == null) {
            this.packageName = this.getProject().getGroupId() + "." + this.getProject().getArtifactId().replaceAll("-", ".");
        }
        Path directory = PluginHelper.getFile((File)this.outputDirectory, (String[])this.packageName.trim().split("\\.")).toPath();
        Files.createDirectories(directory, new FileAttribute[0]);
        return directory.resolve(this.className + ".java");
    }

    @Override
    protected boolean isSkip() {
        return this.skip;
    }

    public void doAction() throws Exception {
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("project = " + this.getProject()));
        }
        this.getLog().info((CharSequence)("Generate to " + this.getOutputFile()));
        List compileSourceRoots = this.getProject().getCompileSourceRoots();
        if (!compileSourceRoots.contains(this.outputDirectory.getAbsolutePath())) {
            this.getLog().info((CharSequence)("Add to compile source root: " + this.outputDirectory));
            this.getProject().addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        this.generate(this.packageName, this.className, this.prefix, this.typeNames, this.getOutputFile());
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.typeNames = new TreeSet<String>();
        List<String> removeSuffixes = Arrays.asList(this.removeSuffix.split("\\s*,\\s*"));
        List<String> skipSuffixes = Arrays.asList(this.skipSuffix.split("\\s*,\\s*"));
        Collections.sort(removeSuffixes);
        Collections.reverse(removeSuffixes);
        Class<?> idDtoClass = Class.forName("fr.ird.observe.services.dto.IdDto");
        block0: for (Class aClass : new Reflections("fr.ird.observe.services.dto", new Scanner[0]).getSubTypesOf(idDtoClass)) {
            if (Modifier.isAbstract(aClass.getModifiers())) continue;
            String simpleName = aClass.getSimpleName();
            boolean skip = false;
            for (String skipSuffix : skipSuffixes) {
                if (!simpleName.endsWith(skipSuffix)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            for (String suffix : removeSuffixes) {
                if (!simpleName.endsWith(suffix)) continue;
                String typeName = Introspector.decapitalize(StringUtils.removeEnd((String)simpleName, (String)suffix));
                this.typeNames.add(typeName);
                this.typeNames.add(English.plural((String)typeName));
                continue block0;
            }
        }
        this.getLog().info((CharSequence)(this.typeNames.size() + " types(s) detected."));
    }

    protected boolean checkSkip() {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping goal (skip flag is on).");
            return false;
        }
        if (this.typeNames.isEmpty()) {
            this.getLog().info((CharSequence)"Skipping goal (no type detected).");
            return false;
        }
        return true;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

