/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree.loadors;

import fr.ird.observe.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.constants.GearType;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.ui.tree.EntityNodeSupport;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import fr.ird.observe.ui.tree.ProgramLonglineNode;
import fr.ird.observe.ui.tree.ProgramSeineNode;
import fr.ird.observe.ui.tree.loadors.AbstractNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ReferenceCommonNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ReferenceLonglineNodeChildLoador;
import fr.ird.observe.ui.tree.loadors.ReferenceSeineNodeChildLoador;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeNodeChildLoador;
import org.nuiton.i18n.I18n;

public class RootNodeChildLoador
extends AbstractNodeChildLoador<Program> {
    private static final long serialVersionUID = 1L;
    protected boolean addData;
    protected boolean addReferentiel;

    public RootNodeChildLoador() {
        super(Program.class);
    }

    public RootNodeChildLoador(boolean addData, boolean addReferentiel) {
        this();
        this.addData = addData;
        this.addReferentiel = addReferentiel;
    }

    public void setAddData(boolean addData) {
        this.addData = addData;
    }

    public void setAddReferentiel(boolean addReferentiel) {
        this.addReferentiel = addReferentiel;
    }

    public List<Program> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {
        List data;
        DataSource dataSource = this.getDataSource(dataProvider);
        DataService service = this.getDataService();
        DataSelectionModel selectionModel = this.getSelectionModel(dataProvider);
        if (this.addData) {
            if (selectionModel != null) {
                data = new ArrayList<Program>();
                for (String programId : selectionModel.getDatas().keySet()) {
                    data.add((Program)selectionModel.getEntityCache(programId));
                }
            } else {
                data = service.getAllProgramStub(dataSource);
            }
        } else {
            data = Collections.emptyList();
        }
        return data;
    }

    public void addChildNodes(ObserveNode parentNode, List<Program> datas, NavDataProvider dataProvider) {
        super.addChildNodes((NavNode)parentNode, datas, dataProvider);
        if (this.addReferentiel) {
            ObserveNode child = new ObserveNode(String.class, I18n.n((String)"observe.tree.reference.common", (Object[])new Object[0]), (NavTreeNodeChildLoador)ObserveTreeHelper.getChildLoador(ReferenceCommonNodeChildLoador.class), true);
            parentNode.add(child);
            child = new ObserveNode(String.class, I18n.n((String)"observe.tree.reference.seine", (Object[])new Object[0]), (NavTreeNodeChildLoador)ObserveTreeHelper.getChildLoador(ReferenceSeineNodeChildLoador.class), true);
            parentNode.add(child);
            child = new ObserveNode(String.class, I18n.n((String)"observe.tree.reference.longline", (Object[])new Object[0]), (NavTreeNodeChildLoador)ObserveTreeHelper.getChildLoador(ReferenceLonglineNodeChildLoador.class), true);
            parentNode.add(child);
        }
    }

    public ObserveNode createNode(Program data, NavDataProvider dataProvider) {
        EntityNodeSupport result;
        GearType gearType = data.getGearType();
        switch (gearType) {
            case seine: {
                result = new ProgramSeineNode(data);
                break;
            }
            case longline: {
                result = new ProgramLonglineNode(data);
                break;
            }
            default: {
                throw new IllegalStateException("The program has a gearType " + gearType + " we can't deal with");
            }
        }
        return result;
    }
}

