/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import com.google.common.base.Preconditions;
import fr.ird.observe.DataService;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.entities.referentiel.Programs;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import fr.ird.observe.ui.tree.actions.ChangeTripProgramActionListener;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;

public class ObserveNavigationTreeShowPopupAction {
    private static final Log log = LogFactory.getLog(ObserveNavigationTreeShowPopupAction.class);
    private final ObserveTreeHelper treeHelper;
    private final JScrollPane pane;
    private final JPopupMenu popup;
    private final JTree tree;
    private final JMenuItem moveTripPopup;
    private final JMenuItem noAction;

    public ObserveNavigationTreeShowPopupAction(ObserveTreeHelper treeHelper, JScrollPane pane, JPopupMenu popup) {
        this.treeHelper = treeHelper;
        this.pane = pane;
        this.popup = popup;
        this.tree = (JTree)treeHelper.getUI();
        JMenuItem moveTripComponent = null;
        JMenuItem noActionComponent = null;
        for (MenuElement menuElement : popup.getSubElements()) {
            if (menuElement.getComponent().getName().equals("navigationMoveTripAction")) {
                moveTripComponent = (JMenuItem)menuElement.getComponent();
            }
            if (!menuElement.getComponent().getName().equals("navigationNoAction")) continue;
            noActionComponent = (JMenuItem)menuElement.getComponent();
        }
        this.moveTripPopup = moveTripComponent;
        this.noAction = noActionComponent;
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ObserveNavigationTreeShowPopupAction.this.tree.isEnabled()) {
                    ObserveNavigationTreeShowPopupAction.this.openNodeMenu(e);
                }
            }
        };
        this.tree.addKeyListener(keyAdapter);
        pane.addKeyListener(keyAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ObserveNavigationTreeShowPopupAction.this.tree.isEnabled()) {
                    ObserveNavigationTreeShowPopupAction.this.autoSelectNodeInTree(e);
                }
            }
        };
        this.tree.addMouseListener(mouseAdapter);
        pane.addMouseListener(mouseAdapter);
    }

    protected void autoSelectNodeInTree(MouseEvent e) {
        boolean rightClick = SwingUtilities.isRightMouseButton(e);
        if (rightClick) {
            Point p = e.getPoint();
            int closestRowForLocation = this.tree.getClosestRowForLocation(e.getX(), e.getY());
            int rowToSelect = -1;
            if (this.isRowSelected(closestRowForLocation)) {
                rowToSelect = closestRowForLocation;
            }
            if (rowToSelect == -1) {
                TreePath pathForRow = this.tree.getPathForRow(closestRowForLocation);
                this.tree.setSelectionPath(pathForRow);
                if (this.isRowSelected(closestRowForLocation)) {
                    rowToSelect = closestRowForLocation;
                }
            }
            if (rowToSelect != -1) {
                this.showPopup(rowToSelect, p);
            }
        }
    }

    public void openNodeMenu(KeyEvent e) {
        if (e.getKeyCode() == 525 && !this.tree.isSelectionEmpty()) {
            int lowestRow = this.getLowestSelectedRowCount();
            Rectangle r = this.tree.getRowBounds(lowestRow);
            Point p = new Point(r.x + r.width / 2, r.y + r.height);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row " + lowestRow + " found t point [" + p + "]"));
            }
            this.showPopup(lowestRow, p);
        }
    }

    protected void showPopup(int row, Point p) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will show popup from row: " + row));
        }
        ObserveNode selectedNode = (ObserveNode)((Object)this.tree.getPathForRow(row).getLastPathComponent());
        if (log.isInfoEnabled()) {
            log.info((Object)("Found selected node: " + (Object)((Object)selectedNode)));
        }
        this.beforeOpenPopup(selectedNode);
        this.popup.show(this.tree, p.x, p.y);
    }

    protected void beforeOpenPopup(ObserveNode selectedNode) {
        this.popup.removeAll();
        if (selectedNode.isTripNode() && selectedNode.isOpen().booleanValue()) {
            List programs;
            if (log.isInfoEnabled()) {
                log.info((Object)"Will load popup for trip node.");
            }
            this.popup.add(this.moveTripPopup);
            this.moveTripPopup.removeAll();
            DataService dataService = this.treeHelper.getDataService();
            DataSource dataSource = this.treeHelper.getDataProvider().getDataSource();
            String tripId = selectedNode.getId();
            try {
                programs = dataService.getPossibleProgramsForTrip(dataSource, tripId);
                Programs.sort((List)programs);
            }
            catch (DataSourceException e) {
                throw new ObserveTechnicalException("Can't get possible programs for trip " + tripId, (Throwable)e);
            }
            String openProgramId = dataService.getDataContext().getOpenProgramId();
            Decorator programDecorator = dataService.getDecoratorService().getDecoratorByType(Program.class);
            for (Program program : programs) {
                String programId = program.getTopiaId();
                if (programId.equals(openProgramId)) continue;
                JMenuItem item = new JMenuItem(programDecorator.toString((Object)program));
                item.setName(programId);
                item.addActionListener(new ChangeTripProgramActionListener(this.treeHelper, dataService, dataSource, tripId, programId));
                this.moveTripPopup.add(item);
            }
        } else {
            this.popup.add(this.noAction);
        }
    }

    protected boolean isRowSelected(int requiredRow) {
        boolean result = false;
        int[] selectedRows = this.tree.getSelectionRows();
        if (selectedRows != null) {
            for (int selectedRow : selectedRows) {
                if (requiredRow != selectedRow) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected int getLowestSelectedRowCount() {
        Preconditions.checkState((!this.tree.isSelectionEmpty() ? 1 : 0) != 0);
        int[] selectedRows = this.tree.getSelectionRows();
        int lowestRow = -1;
        if (selectedRows != null) {
            for (int row : selectedRows) {
                lowestRow = Math.max(lowestRow, row);
            }
        }
        return lowestRow;
    }
}

