/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.Encounter;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.referentiel.longline.EncounterType;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.impl.longline.EncounterUI;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EncounterUIHandler
extends ContentTableUIHandler<ActivityLongline, Encounter> {
    private static Log log = LogFactory.getLog(EncounterUIHandler.class);

    public EncounterUIHandler(EncounterUI ui) {
        super(ui, DataContextType.ActivityLongline);
    }

    @Override
    public EncounterUI getUi() {
        return (EncounterUI)super.getUi();
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, Encounter bean, boolean create) {
        if (this.getTableModel().isEditable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row has changed to " + editingRow));
            }
            this.getUi().getEncounterType().requestFocus();
        }
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.encounter.table.encouterType", (Object[])new Object[0]), I18n.n((String)"observe.encounter.table.encouterType.tip", (Object[])new Object[0]), I18n.n((String)"observe.encounter.table.species", (Object[])new Object[0]), I18n.n((String)"observe.encounter.table.species.tip", (Object[])new Object[0]), I18n.n((String)"observe.encounter.table.distance", (Object[])new Object[0]), I18n.n((String)"observe.encounter.table.distance.tip", (Object[])new Object[0]), I18n.n((String)"observe.encounter.table.count", (Object[])new Object[0]), I18n.n((String)"observe.encounter.table.count.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EncounterType.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Species.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedActivityId();
    }

    @Override
    public void initUI() throws Exception {
        ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
        String speciesListId = config.getSpeciesListLonglineEncounterId();
        this.prepareSpeciesList(speciesListId, (JComponent)this.getUi().getSpecies(), I18n.n((String)"observe.error.speciesList.longline.encounter.notFound", (Object[])new Object[0]));
        super.initUI();
    }
}

