/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.export;

import fr.ird.observe.entities.Trip;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.ui.admin.export.TripEntry;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class TripToExportTableModel
extends AbstractTableModel {
    protected static final Class<?>[] COLUMN_CLASSES = new Class[]{Boolean.class, Program.class, Trip.class, Boolean.class};
    private static final long serialVersionUID = 1L;
    protected TripEntry[] data;
    protected Set<Integer> selected = new HashSet<Integer>();
    protected boolean selectAll;

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public int[] getSelected() {
        int[] result = new int[this.selected.size()];
        int i = 0;
        for (Integer index : this.selected) {
            result[i++] = index;
        }
        return result;
    }

    public boolean hasSelection() {
        return !this.selected.isEmpty();
    }

    public void init(List<TripEntry> data) {
        this.data = data.toArray(new TripEntry[data.size()]);
        this.selected.clear();
        this.setSelectAll(true);
    }

    public void clear() {
        this.data = null;
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_CLASSES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TripEntry tripEntry;
        Object value = null;
        TripEntry tripEntry2 = tripEntry = this.data == null ? null : this.data[rowIndex];
        if (tripEntry != null) {
            switch (columnIndex) {
                case 0: {
                    value = this.selected.contains(rowIndex);
                    break;
                }
                case 1: {
                    value = tripEntry.getTrip().getProgram();
                    break;
                }
                case 2: {
                    value = tripEntry.getTrip();
                    break;
                }
                case 3: {
                    value = tripEntry.isExist();
                    break;
                }
                default: {
                    throw new IllegalStateException("can not get value for row " + rowIndex + ", col " + columnIndex);
                }
            }
        }
        return value;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
        if (selectAll) {
            int max = this.getRowCount();
            for (int i = 0; i < max; ++i) {
                this.selected.add(i);
            }
        } else {
            this.selected.clear();
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            Boolean value = (Boolean)aValue;
            if (value.booleanValue()) {
                this.selected.add(rowIndex);
                if (this.selected.size() == this.getRowCount()) {
                    this.selectAll = true;
                }
            } else {
                this.selected.remove(rowIndex);
                if (this.selected.isEmpty()) {
                    this.selectAll = false;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

