/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveCLAction;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.admin.AdminActionWorker;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminUIModel;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jaxx.runtime.swing.application.ActionExecutor;
import jaxx.runtime.swing.application.ActionWorker;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObserveActionExecutor
extends ActionExecutor {
    private static final Log log = LogFactory.getLog(ObserveActionExecutor.class);
    private static ExecutorService executorService;

    public void onActionStart(ActionWorker<?, ?> source) {
        ObserveMainUI ui;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action [" + source.getActionLabel() + "] was started at " + new Date(source.getStartTime())));
        }
        if (source instanceof ObserveCLAction.CommandLineActionWorker) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Action [" + source.getActionLabel() + "] d\u00e9marr\u00e9e \u00e0 " + new Date(source.getStartTime())));
            }
            return;
        }
        if (ObserveContext.isClosed()) {
            return;
        }
        if (source instanceof AdminActionWorker) {
            AdminActionWorker admin = (AdminActionWorker)source;
            AdminUIModel model = admin.getHandler().getModel();
            model.setBusy(true);
            model.setStepState(WizardState.RUNNING);
        }
        if ((ui = ObserveContext.get().getObserveMainUI()) != null) {
            ui.setBusy(true);
        }
    }

    public void onActionFail(ActionWorker<?, ?> source) {
        Exception error = source.getError();
        if (log.isInfoEnabled() && log.isErrorEnabled()) {
            log.error((Object)("Action [" + source.getActionLabel() + "] failed with error " + error.getCause()), (Throwable)error);
        }
        if (ObserveContext.isClosed()) {
            return;
        }
        if (source instanceof AdminActionWorker) {
            AdminActionWorker admin = (AdminActionWorker)source;
            AdminUIModel model = admin.getHandler().getModel();
            model.getStepModel((AdminStep)model.getOperation()).setError(error);
            model.setStepState(WizardState.FAILED);
            return;
        }
        ObserveMainUI ui = ObserveContext.get().getObserveMainUI();
        if (ui != null) {
            ui.getStatus().setStatus("Action [" + source.getActionLabel() + "] arr\u00eat\u00e9 \u00e0 cause d'un erreur " + error.getMessage());
        }
    }

    public void onActionCancel(ActionWorker<?, ?> source) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action [" + source.getActionLabel() + "] was canceled"));
        }
        if (ObserveContext.isClosed()) {
            return;
        }
        if (source instanceof AdminActionWorker) {
            AdminActionWorker admin = (AdminActionWorker)source;
            admin.getHandler().getModel().setStepState(WizardState.CANCELED);
            return;
        }
        ObserveMainUI ui = ObserveContext.get().getObserveMainUI();
        if (ui != null) {
            ui.getStatus().setStatus("Action [" + source.getActionLabel() + "] annul\u00e9e");
        }
    }

    public void onActionEnd(ActionWorker<?, ?> source) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action [" + source.getActionLabel() + " ] was done in " + source.getTime()));
        }
        if (ObserveContext.isClosed()) {
            return;
        }
        if (source instanceof AdminActionWorker) {
            block6: {
                AdminActionWorker admin = (AdminActionWorker)source;
                try {
                    WizardState state = (WizardState)admin.get();
                    admin.getHandler().getModel().setStepState(state);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)("Could not retrive data from worker " + (Object)((Object)admin)), (Throwable)e);
                }
            }
            return;
        }
        ObserveMainUI ui = ObserveContext.get().getObserveMainUI();
        if (ui != null) {
            ui.getStatus().setStatus("Action [" + source.getActionLabel() + "] termin\u00e9e.");
        }
    }

    public void onAfterAction(ActionWorker<?, ?> source) {
        long count = this.getNbActions();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action [" + source.getActionLabel() + " ] is consumed (still " + count + " tasks to treat)."));
        }
        if (ObserveContext.isClosed()) {
            return;
        }
        if (source instanceof ObserveCLAction.CommandLineActionWorker) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Action [" + source.getActionLabel() + "] termin\u00e9e \u00e0 " + new Date(source.getStartTime())));
            }
            ObserveContext context = ObserveContext.get();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unlock main context " + (Object)((Object)context)));
            }
            context.releaseLock();
            return;
        }
        if (source instanceof AdminActionWorker) {
            AdminActionWorker admin = (AdminActionWorker)source;
            admin.getHandler().getModel().setBusy(false);
        }
        ObserveMainUI ui = ObserveContext.get().getObserveMainUI();
        if (count < 1L && ui != null) {
            ui.setBusy(false);
        }
    }

    public ActionWorker<?, ?> addAction(ActionWorker<?, ?> worker) {
        this.addAction(worker.getActionLabel(), (Runnable)worker);
        return worker;
    }

    public ActionWorker<?, ?> addAction(String actionLabel, Runnable action) {
        ActionWorker worker = action instanceof ActionWorker ? (ActionWorker)action : new ActionWorker(actionLabel, action);
        worker.addPropertyChangeListener(this.workerListener);
        this.tasks.add(worker);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launch worker [" + actionLabel + "] now..."));
        }
        ObserveActionExecutor.getWorkersExecutorService().execute((Runnable)worker);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launch worker [" + actionLabel + "] is on..."));
        }
        return worker;
    }

    private static ExecutorService getWorkersExecutorService() {
        if (executorService == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = this.defaultFactory.newThread(r);
                    thread.setName("ActionWorker-" + thread.getName());
                    thread.setDaemon(true);
                    return thread;
                }
            };
            executorService = new ThreadPoolExecutor(5, 10, 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), threadFactory);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (executorService != null) {
                        executorService.shutdownNow();
                    }
                }
            });
        }
        return executorService;
    }
}

