/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.longline;

import com.google.common.base.Predicate;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import fr.ird.observe.DataService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.SensorUsed;
import fr.ird.observe.entities.referentiel.longline.SensorBrand;
import fr.ird.observe.entities.referentiel.longline.SensorDataFormat;
import fr.ird.observe.entities.referentiel.longline.SensorType;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.impl.longline.SensorUsedUI;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.JaxxFileChooser;

public class SensorUsedUIHandler
extends ContentTableUIHandler<ActivityLongline, SensorUsed> {
    private static Log log = LogFactory.getLog(SensorUsedUIHandler.class);

    public SensorUsedUIHandler(SensorUsedUI ui) {
        super(ui, DataContextType.ActivityLongline);
    }

    @Override
    public SensorUsedUI getUi() {
        return (SensorUsedUI)super.getUi();
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, SensorUsed bean, boolean create) {
        if (this.getTableModel().isEditable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row has changed to " + editingRow));
            }
            this.getUi().getSensorType().requestFocus();
        }
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.sensorUsed.table.sensorType", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.sensorType.tip", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.sensorBrand", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.sensorBrand.tip", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.sensorDataFormat", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.sensorDataFormat.tip", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.sensorSerialNo", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.sensorSerialNo.tip", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.data", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.data.tip", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.dataLocation", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.dataLocation.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, SensorType.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, SensorBrand.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, SensorDataFormat.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((TableCellRenderer)renderer, (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return input != null;
            }
        }));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedActivityId();
    }

    public void importData() {
        File file = UIHelper.chooseFile((Component)((Object)this.ui), I18n.t((String)"observe.title.choose.sensorUsed.importData", (Object[])new Object[0]), I18n.t((String)"observe.action.choose.sensorUsed.importData", (Object[])new Object[0]), null, new String[0]);
        if (file != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Set data from file: " + file));
            }
            try {
                byte[] fileContent = FileUtils.readFileToByteArray((File)file);
                SerialBlob serialBlob = new SerialBlob(fileContent);
                ((SensorUsed)this.getTableEditBean()).setData((Blob)serialBlob);
                ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
                mainUI.getStatus().setStatus(I18n.t((String)"observe.sensorUsed.message.data.imported", (Object[])new Object[]{file}));
            }
            catch (IOException e) {
                throw new ObserveTechnicalException("Could not read file: " + file, (Throwable)e);
            }
            catch (SQLException e) {
                throw new ObserveTechnicalException("Could not create binary data from file: " + file, (Throwable)e);
            }
        }
    }

    public void deleteData() {
        boolean doDelete;
        int response = UIHelper.askUser((Component)((Object)this.ui), I18n.t((String)"observe.title.delete", (Object[])new Object[0]), I18n.t((String)"observe.sensorUsed.delete.data.message", (Object[])new Object[0]), 2, new Object[]{I18n.t((String)"observe.choice.confirm.delete", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 1);
        boolean bl = doDelete = response == 0;
        if (doDelete) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete sensorUsed data " + ((SensorUsed)this.getTableEditBean()).getData()));
            }
            ((SensorUsed)this.getTableEditBean()).setData(null);
        }
    }

    public void exportData() {
        File file = JaxxFileChooser.forSaving().setParent((Component)((Object)this.getUi())).setTitle(I18n.t((String)"observe.title.choose.sensorUsed.exportData", (Object[])new Object[0])).setApprovalText(I18n.t((String)"observe.action.choose.sensorUsed.exportData", (Object[])new Object[0])).setFilename("sensorData-" + ((SensorUsed)this.getTableEditBean()).getSensorSerialNo()).setUseAcceptAllFileFilter(true).choose();
        if (file != null) {
            InputStream binaryStream;
            if (log.isInfoEnabled()) {
                log.info((Object)("save sensorUsed data to " + file));
            }
            try {
                binaryStream = ((SensorUsed)this.getTableEditBean()).getData().getBinaryStream();
            }
            catch (SQLException e) {
                throw new ObserveTechnicalException("Could not read binary data", (Throwable)e);
            }
            OutputStream outputstream = null;
            try {
                outputstream = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).openBufferedStream();
                IOUtils.copy((InputStream)binaryStream, (OutputStream)outputstream);
                outputstream.close();
                ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
                mainUI.getStatus().setStatus(I18n.t((String)"observe.sensorUsed.message.data.exported", (Object[])new Object[]{file}));
            }
            catch (IOException e) {
                try {
                    throw new ObserveTechnicalException("Could not save binary data to " + file, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outputstream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)outputstream);
        }
    }
}

