/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public class LonglineDetailUIHandler
extends ContentUIHandler<SetLongline> {
    private static Log log = LogFactory.getLog(LonglineDetailUIHandler.class);

    public LonglineDetailUIHandler(LonglineDetailUI ui) {
        super(ui, DataContextType.ActivitySeine, DataContextType.SetLongline);
    }

    public LonglineDetailUI getUi() {
        return (LonglineDetailUI)super.getUi();
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        if (dataContext.isSelectedOpen(ActivityLongline.class)) {
            return ContentMode.UPDATE;
        }
        LonglineDetailUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(ActivityLongline.class), I18n.t((String)"observe.message.activity.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String activityId = this.getSelectedParentId();
        String setId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activityId = " + activityId));
            log.info((Object)("setId      = " + setId));
        }
        ContentMode mode = this.computeContentMode();
        DataService dataService = this.getDataService();
        DataSource source = this.getDataSource();
        dataService.loadEditEntity(source, setId, this.getLoadExecutor());
        this.setContentMode(mode);
        if (mode != ContentMode.READ) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        ContentUIModel model = this.getModel();
        boolean create = model.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(model.getMode());
        this.getUi().getValidator().setContext(contextName);
        this.addInfoMessage(I18n.t((String)"observe.message.updating.longlineDetail", (Object[])new Object[0]));
        super.startEditUI(new String[0]);
        model.setModified(create);
    }

    @Override
    protected boolean doSave(SetLongline bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<SetLongline> binder) throws Exception {
        dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        return true;
    }

    @Override
    protected SetLongline onUpdate(TopiaContext tx, Object parentBean, SetLongline beanToSave) throws TopiaException {
        this.getLoadBinder().copy(this.getBean(), (Object)beanToSave, new String[]{"baitsComposition", "floatlinesComposition", "hooksComposition", "branchlinesComposition"});
        return beanToSave;
    }
}

