/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import fr.ird.observe.ui.content.table.ContentTableModel;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.Set;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.beans.BeanUtil;

public class ContentTableMeta<B>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Class<B> klass;
    protected boolean unmodiableWhenExisting;
    protected transient PropertyDescriptor propertyDescriptor;

    public ContentTableMeta(Class<B> klass, String name, boolean unmodiableWhenExisting) {
        this.name = name;
        this.klass = klass;
        this.unmodiableWhenExisting = unmodiableWhenExisting;
        if (ContentTableModel.log.isDebugEnabled()) {
            ContentTableModel.log.debug((Object)(this + " : " + name + " : " + this.getType().getName()));
        }
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.getPropertyDescriptor().getPropertyType();
    }

    public Object getValue(ContentTableModel<?, ?> model, B bean, int row) {
        try {
            return this.getPropertyDescriptor().getReadMethod().invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean setValue(ContentTableModel<?, ?> model, B bean, Object aValue, int row) {
        Object oldValue = this.getValue(model, bean, row);
        return oldValue == null && aValue != null || oldValue != null && !oldValue.equals(aValue);
    }

    public boolean isNullValue(ContentTableModel<?, ?> model, B bean, int row) {
        Object value = this.getValue(model, bean, row);
        return ObjectUtil.isNullValue((Object)value);
    }

    protected PropertyDescriptor getPropertyDescriptor() {
        if (this.propertyDescriptor == null) {
            Predicate predicate = Predicates.and((Predicate)BeanUtil.IS_READ_DESCRIPTOR, (Predicate)new Predicate<PropertyDescriptor>(){

                public boolean apply(PropertyDescriptor input) {
                    return ContentTableMeta.this.name.equals(input.getName());
                }
            });
            Set descriptors = BeanUtil.getDescriptors(this.klass, (Predicate)predicate);
            Preconditions.checkState((!descriptors.isEmpty() ? 1 : 0) != 0, (Object)("could not find readable property " + this.name + " for bean " + this.klass));
            this.propertyDescriptor = (PropertyDescriptor)Iterables.get((Iterable)descriptors, (int)0);
        }
        return this.propertyDescriptor;
    }
}

