/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.table.ContentTableMeta;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUI;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityListUpdator;

public class ContentTableUIModel<E extends TopiaEntity, D extends TopiaEntity>
extends ContentUIModel<E> {
    private static Log log = LogFactory.getLog(ContentTableUIModel.class);
    public static final String PROPERTY_CAN_SAVE_ROW = "canSaveRow";
    public static final String PROPERTY_CAN_RESET_ROW = "canResetRow";
    public static final String PROPERTY_SHOW_DATA = "showData";
    public static final String PROPERTY_ROW_SAVED = "rowSaved";
    protected final Class<D> childType;
    protected final String[] parentProperties;
    protected final String[] childProperties;
    private final ContentTableModel<E, D> tableModel;
    private final EntityListUpdator<E, D> childsUpdator;
    private final ListSelectionModel selectionModel;
    protected D tableEditBean;
    protected boolean canSaveRow;
    protected boolean canResetRow;
    protected boolean showData;
    protected boolean rowSaved;

    public ContentTableUIModel(Class<E> beanType, Class<D> childType, String[] parentProperties, String[] childProperties, ContentTableUI<E, D> ui, ContentTableMeta<D> ... metas) {
        super(beanType);
        this.childType = childType;
        this.parentProperties = parentProperties;
        this.childProperties = childProperties;
        this.childsUpdator = EntityListUpdator.newEntityListUpdator(beanType, childType, (String)parentProperties[0]);
        this.tableModel = new ContentTableModel<E, D>(ui, metas);
        this.selectionModel = new ContentTableListSelectionModel();
    }

    public Class<D> getChildType() {
        return this.childType;
    }

    public String[] getParentProperties() {
        return this.parentProperties;
    }

    public String[] getChildProperties() {
        return this.childProperties;
    }

    public EntityListUpdator<E, D> getChildsUpdator() {
        return this.childsUpdator;
    }

    public ContentTableModel<E, D> getTableModel() {
        return this.tableModel;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public D getTableEditBean() {
        block3: {
            if (this.tableEditBean == null) {
                try {
                    this.tableEditBean = this.newTableEditBean();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)e);
                }
            }
        }
        return this.tableEditBean;
    }

    public final D newTableEditBean() {
        try {
            Class klass = ObserveDAOHelper.getImplementationClass(this.getChildType());
            return (D)((TopiaEntity)klass.newInstance());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isCanSaveRow() {
        return this.canSaveRow;
    }

    public boolean isCanResetRow() {
        return this.canResetRow;
    }

    public boolean isRowSaved() {
        return this.rowSaved;
    }

    public void setRowSaved(boolean rowSaved) {
        boolean oldValue = this.rowSaved;
        this.rowSaved = rowSaved;
        this.firePropertyChange(PROPERTY_ROW_SAVED, oldValue, rowSaved);
    }

    public void setCanSaveRow(boolean canSaveRow) {
        boolean oldValue = this.canSaveRow;
        this.canSaveRow = canSaveRow;
        this.firePropertyChange(PROPERTY_CAN_SAVE_ROW, oldValue, canSaveRow);
    }

    public void setCanResetRow(boolean canResetRow) {
        boolean oldValue = this.canResetRow;
        this.canResetRow = canResetRow;
        this.firePropertyChange(PROPERTY_CAN_RESET_ROW, oldValue, canResetRow);
    }

    public boolean isShowData() {
        return this.showData;
    }

    public void setShowData(boolean showData) {
        boolean oldValue = this.showData;
        this.showData = showData;
        this.firePropertyChange(PROPERTY_SHOW_DATA, oldValue, showData);
    }

    public class ContentTableListSelectionModel
    extends DefaultListSelectionModel {
        private static final long serialVersionUID = 1L;

        @Override
        public void setSelectionInterval(int index0, int index1) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(index0 + " - " + index1));
            }
            ContentTableModel model = ContentTableUIModel.this.getTableModel();
            boolean canContinue = this.canContinue(model, index0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("can continue  for row " + index0 + " : " + canContinue));
            }
            if (canContinue) {
                super.setSelectionInterval(index0, index1);
            }
        }

        protected boolean canContinue(ContentTableModel<?, ?> model, int newIndex) {
            if (model == null) {
                return false;
            }
            if (!model.isEditable()) {
                return true;
            }
            if (model.isValueAdjusting()) {
                return true;
            }
            int editingRow = model.getSelectedRow();
            if (this.isSelectionEmpty() || editingRow == -1) {
                return true;
            }
            if (editingRow == newIndex) {
                return true;
            }
            boolean canContinue = model.isCanQuitEditingRow();
            return canContinue;
        }
    }
}

