/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.actions.AbstractUIAction;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.tree.AbstractObserveTreeCellRenderer;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.swing.nav.NavNode;
import org.nuiton.i18n.I18n;

public class GoDownUIAction
extends AbstractUIAction {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_NAME = "goDown";

    public GoDownUIAction(ObserveMainUI mainUI) {
        super(mainUI, ACTION_NAME, I18n.n((String)"observe.action.goDown", (Object[])new Object[0]), I18n.n((String)"observe.action.goDown.tip", (Object[])new Object[0]), "go-down");
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent c = (JComponent)e.getSource();
                JPopupMenu p = (JPopupMenu)c.getClientProperty("popup");
                if (p == null) {
                    throw new IllegalStateException("could not find client property popup on component" + c);
                }
                p.show(c, 2, c.getHeight());
            }
        });
    }

    @Override
    public void initAction(ContentUI<?> ui, AbstractButton editor) {
        super.initAction(ui, editor);
        editor.putClientProperty("popup", this.getMainUI().getScopeDownPopup());
    }

    @Override
    public void updateAction(ContentUI<?> ui, AbstractButton editor) {
        int nbNodes;
        JMenuItem mi;
        ObserveNode node;
        ObserveMainUI mainUI = this.getMainUI();
        ObserveTreeHelper treeHelper = this.getMainUI().getTreeHelper();
        DefaultTreeModel navigationModel = (DefaultTreeModel)treeHelper.getModel();
        AbstractObserveTreeCellRenderer render = treeHelper.getTreeCellRenderer();
        super.updateAction(ui, editor);
        JPopupMenu scopePopup = mainUI.getScopeDownPopup();
        Action action = mainUI.getRootPane().getActionMap().get("selectNode");
        ObserveNode nodeOriginal = node = (ObserveNode)treeHelper.getSelectedNode();
        scopePopup.removeAll();
        Enumeration e = node.children();
        while (e.hasMoreElements()) {
            node = (ObserveNode)((Object)e.nextElement());
            String text = render.getNodeText((NavNode)node);
            if (text == null) continue;
            Color color = render.getNavigationTextColor(node);
            Icon icon = render.getNavigationIcon(node, "-16");
            mi = new JMenuItem();
            mi.setAction(action);
            mi.setText(text.trim());
            mi.setIcon(icon);
            mi.setForeground(color);
            mi.putClientProperty("node", (Object)node);
            mi.putClientProperty("ui", ui);
            mi.setAction(action);
            scopePopup.add(mi);
        }
        if (nodeOriginal.getChildCount() == 1 && !((ObserveNode)nodeOriginal.getChildAt(0)).isLeaf()) {
            e = ((ObserveNode)nodeOriginal.getChildAt(0)).children();
            while (e.hasMoreElements()) {
                node = (ObserveNode)((Object)e.nextElement());
                Color color = render.getNavigationTextColor(node);
                Icon icon = render.getNavigationIcon(node, "-16");
                String text = render.getNodeText((NavNode)node);
                mi = new JMenuItem();
                mi.setAction(action);
                mi.setText(text.trim());
                mi.setIcon(icon);
                mi.setForeground(color);
                mi.putClientProperty("node", (Object)node);
                mi.putClientProperty("ui", ui);
                mi.setAction(action);
                scopePopup.add(mi);
            }
        }
        editor.setEnabled((nbNodes = scopePopup.getComponentCount()) > 0);
    }
}

