/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util.table;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AutotSelectRowAndShowPopupActionSupport {
    private static final Log log = LogFactory.getLog(AutotSelectRowAndShowPopupActionSupport.class);
    private final JScrollPane pane;
    private final JTable table;
    private final JPopupMenu popup;

    protected AutotSelectRowAndShowPopupActionSupport(JScrollPane pane, final JTable table, JPopupMenu popup) {
        this.pane = pane;
        this.table = table;
        this.popup = popup;
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (table.isEnabled()) {
                    AutotSelectRowAndShowPopupActionSupport.this.openRowMenu(e);
                }
            }
        };
        this.table.addKeyListener(keyAdapter);
        pane.addKeyListener(keyAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AutotSelectRowAndShowPopupActionSupport.this.table.isEnabled()) {
                    Point p = e.getPoint();
                    if (AutotSelectRowAndShowPopupActionSupport.this.pane.getViewport().contains(p)) {
                        AutotSelectRowAndShowPopupActionSupport.this.autoSelectRowInTable(e);
                    }
                }
            }
        };
        this.table.addMouseListener(mouseAdapter);
        pane.addMouseListener(mouseAdapter);
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    public JTable getTable() {
        return this.table;
    }

    protected abstract void beforeOpenPopup(int var1, int var2);

    public void autoSelectRowInTable(MouseEvent e) {
        boolean rightClick = SwingUtilities.isRightMouseButton(e);
        if (rightClick || SwingUtilities.isLeftMouseButton(e)) {
            boolean stopEdit;
            Point p = e.getPoint();
            int[] selectedRows = this.table.getSelectedRows();
            int[] selectedColumns = this.table.getSelectedColumns();
            int rowIndex = this.table.rowAtPoint(p);
            int columnIndex = this.table.columnAtPoint(p);
            if (log.isDebugEnabled()) {
                log.debug((Object)("At point [" + p + "] found Row " + rowIndex + ", Column " + columnIndex));
            }
            boolean canContinue = true;
            if (this.table.isEditing() && !(stopEdit = this.table.getCellEditor().stopCellEditing())) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Could not stop edit cell...");
                }
                canContinue = false;
            }
            if (canContinue) {
                if (rowIndex == -1) {
                    this.table.clearSelection();
                } else if (!ArrayUtils.contains((int[])selectedRows, (int)rowIndex)) {
                    this.table.setRowSelectionInterval(rowIndex, rowIndex);
                }
                if (columnIndex == -1) {
                    this.table.clearSelection();
                } else if (!ArrayUtils.contains((int[])selectedColumns, (int)columnIndex)) {
                    this.table.setColumnSelectionInterval(columnIndex, columnIndex);
                }
                if (rightClick) {
                    this.showPopup(rowIndex, columnIndex, p);
                }
            }
        }
    }

    public void openRowMenu(KeyEvent e) {
        if (e.getKeyCode() == 525) {
            boolean stopEdit;
            int[] selectedRows = this.table.getSelectedRows();
            int lowestRow = -1;
            for (int row : selectedRows) {
                lowestRow = Math.max(lowestRow, row);
            }
            int selectedColumn = this.table.getSelectedColumn();
            Rectangle r = this.table.getCellRect(lowestRow, selectedColumn, true);
            Point p = new Point(r.x + r.width / 2, r.y + r.height);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row " + lowestRow + " found t point [" + p + "]"));
            }
            boolean canContinue = true;
            if (this.table.isEditing() && !(stopEdit = this.table.getCellEditor().stopCellEditing())) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Could not stop edit cell...");
                }
                canContinue = false;
            }
            if (canContinue) {
                this.showPopup(lowestRow, selectedColumn, p);
            }
        }
    }

    protected void showPopup(int row, int column, Point p) {
        int rowIndex = row == -1 ? -1 : this.table.convertRowIndexToModel(row);
        int columnIndex = column == -1 ? -1 : this.table.convertColumnIndexToModel(column);
        this.beforeOpenPopup(rowIndex, columnIndex);
        this.popup.show(this.table, p.x, p.y);
    }
}

