/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.open.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.longline.ActivityLonglines;
import fr.ird.observe.entities.longline.TripLongline;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.open.ContentOpenableUIHandler;
import fr.ird.observe.ui.content.open.ContentOpenableUIModel;
import fr.ird.observe.ui.content.open.impl.longline.TripLonglineUI;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.DateUtil;

public class TripLonglineUIHandler
extends ContentOpenableUIHandler<TripLongline> {
    private static final Log log = LogFactory.getLog(TripLonglineUIHandler.class);

    public TripLonglineUIHandler(TripLonglineUI ui) {
        super(ui, DataContextType.Program, DataContextType.TripLongline, I18n.n((String)"observe.tripLongline.message.not.open", (Object[])new Object[0]));
    }

    @Override
    public TripLonglineUI getUi() {
        return (TripLonglineUI)super.getUi();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String mareeId = this.getSelectedId();
        if (mareeId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(TripLongline.class)) {
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n.t((String)this.closeMessage, (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        boolean create;
        super.openUI();
        ContentMode mode = this.computeContentMode();
        String programId = this.getSelectedParentId();
        String tripId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "programId = " + programId));
            log.info((Object)(this.prefix + "tripId    = " + tripId));
            log.info((Object)(this.prefix + "mode      = " + (Object)((Object)mode)));
        }
        DataService dataService = this.getDataService();
        TripLongline bean = (TripLongline)this.getBean();
        DataSource source = this.getDataSource();
        boolean bl = create = tripId == null;
        if (create) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.prefix + "create a new trip"));
            }
            dataService.preCreate(source, programId, (TopiaEntity)bean, this.getLoadBinder(), this.getPreCreateExecutor());
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.prefix + "using existing trip " + tripId));
            }
            dataService.loadEditEntity(source, tripId, this.getLoadExecutor());
            if (!bean.isActivityLonglineEmpty()) {
                ActivityLonglines.sort((List)bean.getActivityLongline());
            }
        }
        this.finalizeOpenUI(mode, create);
    }

    @Override
    protected TripLongline onPreCreate(TopiaContext tx, Object parent, TripLongline bean) throws TopiaException {
        Program parentBean = (Program)parent;
        Date date = DateUtil.getDay((Date)new Date());
        bean.setStartDate(date);
        bean.setEndDate(date);
        if (log.isDebugEnabled()) {
            log.debug((Object)("start date : " + date));
            log.debug((Object)("program    : " + parentBean));
        }
        bean.setProgram(parentBean);
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        TripLonglineUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        ContentMode mode = model.getMode();
        boolean create = mode == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(mode);
        ui.getValidator().setContext(contextName);
        if (create) {
            this.addInfoMessage(I18n.t((String)"observe.tripLongline.message.creating", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.t((String)"observe.tripLongline.message.updating", (Object[])new Object[0]));
            if (((ContentOpenableUIModel)model).isHistoricalData()) {
                this.addInfoMessage(I18n.t((String)"observe.message.historical.data", (Object[])new Object[0]));
            }
        }
        if (model.getMode() == ContentMode.UPDATE && ((TripLongline)this.getBean()).getEndDate() == null) {
            Date date = DateUtil.getEndOfDay((Date)new Date());
            ((TripLongline)this.getBean()).setEndDate(date);
            if (log.isDebugEnabled()) {
                log.debug((Object)("date fin " + date));
            }
        }
        super.startEditUI("vessel.selectedItem", "observer.selectedItem", "captain.selectedItem", "tripType.selectedItem", "dataEntryOperator.selectedItem", "totalFishingOperationsNumber.model", "ocean.selectedItem", "startDate.date", "endDate.date", "comment2.text", "homeId.text", "close.enabled", "closeAndCreate.enabled");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(TripLongline bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<TripLongline> binder) throws Exception {
        String programId = this.getDataContext().getSelectedProgramId();
        Date startDate = DateUtil.getDay((Date)bean.getStartDate());
        if (log.isDebugEnabled()) {
            log.debug((Object)("startDate = " + startDate));
        }
        bean.setStartDate(startDate);
        bean.updateDateFin();
        Date endDate = bean.getEndDate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("endDate   = " + endDate));
        }
        bean.setOpen(true);
        if (bean.getTopiaId() == null) {
            dataService.create(dataSource, programId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        this.obtainChildPosition(bean, dataService, dataSource);
        return true;
    }

    @Override
    protected TripLongline onCreate(TopiaContext tx, Object parent, TripLongline editBean) throws TopiaException {
        TripLongline beanToSave = (TripLongline)ObserveDAOHelper.getTripLonglineDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        return beanToSave;
    }

    @Override
    protected TripLongline onUpdate(TopiaContext tx, Object parentBean, TripLongline beanToSave) throws TopiaException {
        this.getLoadBinder().copyExcluding(this.getBean(), (Object)beanToSave, new String[]{"activityLongline"});
        return beanToSave;
    }

    @Override
    protected boolean doDelete(TripLongline bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, TripLongline> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete Trip " + bean.getTopiaId()));
        }
        dataService.delete(dataSource, null, (TopiaEntity)bean, deletor);
        if (log.isInfoEnabled()) {
            log.info((Object)("Delete done for Trip " + bean.getTopiaId()));
        }
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parentBean, TripLongline beanToDelete) throws TopiaException {
        TopiaDAO dao = this.getDataSource().getDAO(tx, TripLongline.class);
        dao.delete((TopiaEntity)beanToDelete);
    }

    @Override
    protected boolean obtainCanReopen(boolean create) {
        DataContext dataContext = this.getDataContext();
        return !create && !dataContext.isOpenTrip();
    }
}

