/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl.longline;

import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.TripLongline;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.list.ContentListUIHandler;
import fr.ird.observe.ui.content.list.impl.longline.ActivityLonglinesUI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ActivityLonglinesUIHandler
extends ContentListUIHandler<TripLongline, ActivityLongline> {
    private static Log log = LogFactory.getLog(ActivityLonglinesUIHandler.class);

    public ActivityLonglinesUIHandler(ActivityLonglinesUI ui) {
        super(ui, DataContextType.TripLongline, DataContextType.ActivityLongline);
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openTripLonglineId = dataContext.getOpenTripId();
        if (openTripLonglineId == null) {
            this.addInfoMessage(I18n.n((String)"observe.tripLongline.message.no.active.found", (Object[])new Object[0]));
            return ContentMode.READ;
        }
        boolean openActivity = dataContext.isOpenActivity();
        if (dataContext.isSelectedOpen(TripLongline.class)) {
            if (openActivity) {
                this.addInfoMessage(I18n.n((String)"observe.activityLongline.message.active.found", (Object[])new Object[0]));
                return ContentMode.UPDATE;
            }
            this.addInfoMessage(I18n.n((String)"observe.activityLongline.message.no.active.found", (Object[])new Object[0]));
            return ContentMode.CREATE;
        }
        if (openActivity) {
            this.addInfoMessage(I18n.n((String)"observe.activityLongline.message.active.found.for.other.trip", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.n((String)"observe.activityLongline.message.no.active.found.for.other.trip", (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    protected List<ActivityLongline> getChilds(TripLongline bean) {
        List list = bean.getActivityLongline();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use " + (list == null ? 0 : list.size()) + " activities."));
        }
        return list;
    }
}

