/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.model.DataSelectionModel;
import jaxx.runtime.swing.nav.NavDataProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObserveDataProvider
implements NavDataProvider {
    private static final Log log = LogFactory.getLog(ObserveDataProvider.class);
    protected DataSource dataSource;
    protected DataService dataService;
    protected DataSelectionModel selectionModel;

    public ObserveDataProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSelectionModel(DataSelectionModel selectionModel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Set selection model : " + selectionModel));
        }
        this.selectionModel = selectionModel;
    }

    public boolean isEnabled() {
        return this.dataSource != null && this.dataSource.isOpen() || this.selectionModel != null;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected DataService getDataService() {
        if (this.dataService == null) {
            this.dataService = ObserveServiceHelper.getDataService();
        }
        return this.dataService;
    }
}

