/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.open.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.TripLongline;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.open.ContentOpenableUIHandler;
import fr.ird.observe.ui.content.open.ContentOpenableUIModel;
import fr.ird.observe.ui.content.open.impl.longline.ActivityLonglineUI;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public class ActivityLonglineUIHandler
extends ContentOpenableUIHandler<ActivityLongline> {
    private static Log log = LogFactory.getLog(ActivityLonglineUIHandler.class);

    public ActivityLonglineUIHandler(ActivityLonglineUI ui) {
        super(ui, DataContextType.TripLongline, DataContextType.ActivityLongline, I18n.n((String)"observe.activityLongline.message.not.open", (Object[])new Object[0]));
    }

    @Override
    public ActivityLonglineUI getUi() {
        return (ActivityLonglineUI)super.getUi();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String activityId = this.getSelectedId();
        if (activityId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(ActivityLongline.class)) {
            return ContentMode.UPDATE;
        }
        ActivityLonglineUI ui = this.getUi();
        if (!dataContext.isSelectedOpen(TripLongline.class)) {
            ActivityLonglineUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(TripLongline.class), I18n.t((String)"observe.tripLongline.message.not.open", (Object[])new Object[0]));
            if (((ContentOpenableUIModel)this.getModel()).isHistoricalData()) {
                this.addInfoMessage(I18n.t((String)"observe.message.historical.data", (Object[])new Object[0]));
            }
        } else {
            this.addInfoMessage(I18n.t((String)this.closeMessage, (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String tripId = this.getSelectedParentId();
        String activityId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "tripId     = " + tripId));
            log.info((Object)(this.prefix + "activityId = " + activityId));
        }
        ContentMode mode = this.computeContentMode();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "content mode " + (Object)((Object)mode)));
        }
        ActivityLongline bean = (ActivityLongline)this.getBean();
        DataService dataService = this.getDataService();
        boolean create = activityId == null;
        TopiaEntityBinder binder = this.getLoadBinder();
        DataSource source = this.getDataSource();
        if (create) {
            dataService.preCreate(source, tripId, (TopiaEntity)bean, binder, this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(source, activityId, this.getLoadExecutor());
            bean.initCoordinates();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("           long  - lat  = " + bean.getLongitude() + " - " + bean.getLatitude()));
        }
        this.finalizeOpenUI(mode, create);
        this.getModel().setModified(create);
    }

    @Override
    protected ActivityLongline onPreCreate(TopiaContext tx, Object parent, ActivityLongline bean) throws TopiaException {
        Date timestamp;
        TripLongline parentBean = (TripLongline)parent;
        bean.setOpen(true);
        ActivityLongline lastActivityLongline = parentBean.getLastActivity();
        if (lastActivityLongline == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.set(11, 12);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            timestamp = calendar.getTime();
        } else {
            lastActivityLongline.initCoordinates();
            Integer quadrant = lastActivityLongline.getQuadrant();
            if (log.isDebugEnabled()) {
                log.debug((Object)("use quadrant of previous activity [" + quadrant + "]"));
            }
            this.getUi().getCoordinatesEditor().getModel().setQuadrant(quadrant);
            timestamp = lastActivityLongline.getTimeStamp();
        }
        bean.setTimeStamp(timestamp);
        if (log.isDebugEnabled()) {
            log.debug((Object)("has pre-created :  " + bean));
        }
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        ActivityLonglineUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        boolean create = model.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(model.getMode());
        ui.getValidator().setContext(contextName);
        if (create) {
            ActivityLonglineUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(ActivityLongline.class), I18n.t((String)"observe.activityLongline.message.creating", (Object[])new Object[0]));
        } else {
            ActivityLonglineUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(ActivityLongline.class), I18n.t((String)"observe.activityLongline.message.updating", (Object[])new Object[0]));
        }
        super.startEditUI("timeStamp.date", "coordinatesEditor.latitude", "coordinatesEditor.longitude", "coordinatesEditor.quadrant", "seaSurfaceTemperature.model", "comment2.text", "vesselActivityLongline.selectedItem", "fpaZone.selectedItem", "close.enabled", "closeAndCreate.enabled");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(ActivityLongline bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<ActivityLongline> binder) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("           long  - lat = " + bean.getLongitude() + " - " + bean.getLatitude()));
        }
        boolean create = bean.getTopiaId() == null;
        String routeId = this.getSelectedParentId();
        bean.setOpen(true);
        if (create) {
            bean = (ActivityLongline)dataService.create(dataSource, routeId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, routeId, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        this.obtainChildPosition(bean, dataService, dataSource);
        return true;
    }

    @Override
    protected ActivityLongline onCreate(TopiaContext tx, Object parent, ActivityLongline editBean) throws TopiaException {
        TripLongline parentBean = (TripLongline)parent;
        ActivityLongline beanToSave = (ActivityLongline)ObserveDAOHelper.getActivityLonglineDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addActivityLongline(beanToSave);
        return beanToSave;
    }

    @Override
    protected ActivityLongline onUpdate(TopiaContext tx, Object parentBean, ActivityLongline beanToSave) throws TopiaException {
        ActivityLongline editBean = (ActivityLongline)this.getBean();
        if (log.isInfoEnabled()) {
            log.info((Object)("Final time to use : " + editBean.getTimeStamp()));
        }
        this.getLoadBinder().copyExcluding((Object)editBean, (Object)beanToSave, new String[]{"encounter", "sensorUsed"});
        if (log.isInfoEnabled()) {
            log.info((Object)("Is activity open ? : " + beanToSave.isOpen()));
        }
        return beanToSave;
    }

    @Override
    protected boolean doDelete(ActivityLongline bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, ActivityLongline> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete Activity " + bean.getTopiaId()));
        }
        String tripId = this.getSelectedParentId();
        dataService.delete(dataSource, tripId, (TopiaEntity)bean, deletor);
        if (log.isInfoEnabled()) {
            log.info((Object)("Delete done for Activity " + bean.getTopiaId()));
        }
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, ActivityLongline beanToDelete) {
        TripLongline parentBean = (TripLongline)parent;
        parentBean.removeActivityLongline(beanToDelete);
    }

    @Override
    protected boolean obtainCanReopen(boolean create) {
        DataContext dataContext = this.getDataContext();
        boolean canReopen = !create && dataContext.isSelectedOpen(TripLongline.class) && !dataContext.isOpenActivity();
        return canReopen;
    }
}

