/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.referentiel.Sex;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.seine.NonTargetLength;
import fr.ird.observe.entities.seine.NonTargetSample;
import fr.ird.observe.entities.seine.SetSeine;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.seine.ModeSaisieEchantillonEnum;
import fr.ird.observe.ui.content.table.impl.seine.NonTargetSampleUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.validator.NuitonValidatorScope;

public class NonTargetSampleUIHandler
extends ContentTableUIHandler<NonTargetSample, NonTargetLength> {
    private static Log log = LogFactory.getLog(NonTargetSampleUIHandler.class);
    protected final JAXXContextEntryDef<List<Species>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"NonTargetSampleUI-all-speciess");
    protected final PropertyChangeListener weightChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NonTargetLength source = (NonTargetLength)evt.getSource();
            source.setWeightSource(false);
        }
    };
    protected final PropertyChangeListener lengthChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NonTargetLength source = (NonTargetLength)evt.getSource();
            source.setLengthSource(false);
        }
    };

    public NonTargetSampleUIHandler(NonTargetSampleUI ui) {
        super(ui, DataContextType.SetSeine);
    }

    @Override
    public NonTargetSampleUI getUi() {
        return (NonTargetSampleUI)super.getUi();
    }

    public void resetWeightSource() {
        ((NonTargetLength)this.getTableEditBean()).setWeightSource(false);
        this.getUi().getWeight().grabFocus();
    }

    public void resetLengthSource() {
        ((NonTargetLength)this.getTableEditBean()).setLengthSource(false);
        this.getUi().getLength().grabFocus();
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        String setId = dataContext.getSelectedSetId();
        String id = dataService.getNonTargetSampleId(dataSource, setId);
        return id;
    }

    @Override
    protected NonTargetSample loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        String setId = dataContext.getSelectedSetId();
        List speciess = mode == ContentMode.UPDATE ? dataService.getAvailableEspeceForNonTargetSample(dataSource, setId) : new ArrayList();
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)this.getUi(), speciess);
        String id = this.getEditBeanIdToLoad(dataContext, dataService, dataSource);
        NonTargetSample editBean = (NonTargetSample)this.getBean();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + " - set id             : " + setId));
            log.info((Object)(this.prefix + " - echantillon faune id : " + id));
            log.info((Object)(this.prefix + " - edit bean id         : " + editBean.getTopiaId()));
        }
        if (id == null) {
            this.getLoadBinder().load(null, (TopiaEntity)editBean, true, new String[0]);
            ((ContentTableUIModel)this.getModel()).getChildsUpdator().setChilds((TopiaEntity)editBean, new ArrayList());
        } else {
            dataService.loadEditEntity(dataSource, id, this.getLoadExecutor());
        }
        this.getModel().setMode(mode);
        this.getUi().getTableModel().attachModel();
        return editBean;
    }

    @Override
    protected boolean prepareSave(NonTargetSample bean, List<NonTargetLength> objets) throws DataSourceException {
        if (bean.getTopiaId() == null) {
            String setId = this.getDataContext().getSelectedSetId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will create echantillon faune " + bean + " for " + setId));
            }
            this.getDataService().create(this.getDataSource(), setId, (TopiaEntity)bean, null, this.getCreateExecutor());
        }
        return true;
    }

    @Override
    protected NonTargetSample onCreate(TopiaContext tx, Object parent, NonTargetSample editBean) throws TopiaException {
        SetSeine parentBean = (SetSeine)parent;
        NonTargetSample beanToSave = (NonTargetSample)ObserveDAOHelper.getNonTargetSampleDAO((TopiaContext)tx).create(new Object[0]);
        if (log.isInfoEnabled()) {
            log.info((Object)("Echantillon faune " + beanToSave.getTopiaId() + " was created."));
        }
        editBean.setTopiaId(beanToSave.getTopiaId());
        editBean.setTopiaCreateDate(beanToSave.getTopiaCreateDate());
        editBean.setTopiaVersion(beanToSave.getTopiaVersion());
        parentBean.addNonTargetSample(beanToSave);
        return beanToSave;
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, NonTargetLength bean, boolean create) {
        BeanComboBox<Species> requestFocus;
        List<Object> availableEspeces;
        ContentTableModel model = this.getTableModel();
        if (!model.isEditable()) {
            return;
        }
        Species species = bean.getSpecies();
        NonTargetSampleUI ui = this.getUi();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected species " + species));
        }
        if (create) {
            if (model.isCreate()) {
                ui.getAcquisitionModeGroup().setSelectedValue(null);
                ui.getAcquisitionModeGroup().setSelectedValue((Object)ModeSaisieEchantillonEnum.byEffectif);
            }
            availableEspeces = new ArrayList((Collection)this.ALL_ESPECES_ENTRY.getContextValue((JAXXContext)ui));
            requestFocus = ui.getSpecies();
        } else {
            requestFocus = ui.getCount();
            int acquisitionMode = bean.getAcquisitionMode();
            ModeSaisieEchantillonEnum enumValue = ModeSaisieEchantillonEnum.valueOf(acquisitionMode);
            ui.getAcquisitionModeGroup().setSelectedValue(null);
            ui.getAcquisitionModeGroup().setSelectedValue((Object)enumValue);
            availableEspeces = Arrays.asList(species);
        }
        ui.getSpecies().setData(availableEspeces);
        requestFocus.requestFocus();
        NonTargetLength tableEditBean = (NonTargetLength)this.getTableEditBean();
        tableEditBean.removePropertyChangeListener("weight", this.weightChanged);
        tableEditBean.addPropertyChangeListener("weight", this.weightChanged);
        tableEditBean.removePropertyChangeListener("length", this.lengthChanged);
        tableEditBean.addPropertyChangeListener("length", this.lengthChanged);
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)1, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)2, (int)100);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.nonTargetSample.table.speciesFaune", (Object[])new Object[0]), I18n.n((String)"observe.nonTargetSample.table.speciesFaune.tip", (Object[])new Object[0]), I18n.n((String)"observe.nonTargetSample.table.length", (Object[])new Object[0]), I18n.n((String)"observe.nonTargetSample.table.length.tip", (Object[])new Object[0]), I18n.n((String)"observe.nonTargetSample.table.meanWeight", (Object[])new Object[0]), I18n.n((String)"observe.nonTargetSample.table.meanWeight.tip", (Object[])new Object[0]), I18n.n((String)"observe.nonTargetSample.table.count", (Object[])new Object[0]), I18n.n((String)"observe.nonTargetSample.table.count.tip", (Object[])new Object[0]), I18n.n((String)"observe.nonTargetSample.table.gender", (Object[])new Object[0]), I18n.n((String)"observe.nonTargetSample.table.gender.tip", (Object[])new Object[0]), I18n.n((String)"observe.nonTargetSample.table.picturesReferences", (Object[])new Object[0]), I18n.n((String)"observe.nonTargetSample.table.picturesReferences.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Species.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Sex.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)renderer);
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        boolean showData;
        ContentMode mode;
        block3: {
            mode = super.getContentMode(dataContext);
            showData = false;
            try {
                String setId = this.getDataContext().getSelectedSetId();
                showData = this.getDataService().canUseNonTargetSample(this.getDataSource(), setId);
            }
            catch (DataSourceException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)e);
            }
        }
        this.getUi().getModel().setShowData(showData);
        if (mode == ContentMode.UPDATE && !showData) {
            mode = ContentMode.READ;
            NonTargetSampleUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(SetSeine.class), I18n.t((String)"observe.setSeine.message.no.nonTargetDiscarded", (Object[])new Object[0]));
        }
        return mode;
    }

    public void updateModeSaisie(ModeSaisieEchantillonEnum newMode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Change mode saisie to " + (Object)((Object)newMode)));
        }
        if (newMode == null) {
            return;
        }
        NonTargetSampleUI ui = this.getUi();
        boolean createMode = ui.getTableModel().isCreate();
        NonTargetLength editBean = ui.getTableEditBean();
        switch (newMode) {
            case byEffectif: {
                ui.getWeight().setEnabled(false);
                ui.getCount().setEnabled(true);
                if (!createMode) break;
                editBean.setWeight(null);
                editBean.setCount(null);
                break;
            }
            case byIndividu: {
                ui.getWeight().setEnabled(true);
                ui.getCount().setEnabled(false);
                if (!createMode) break;
                editBean.setCount(Integer.valueOf(1));
            }
        }
        if (createMode) {
            editBean.setAcquisitionMode(newMode.ordinal());
        }
    }
}

