/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminActionModel;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.access.AccessModel;
import fr.ird.observe.ui.admin.access.AccessUI;
import fr.ird.observe.ui.admin.access.AnalyzeAccessUI;
import fr.ird.observe.ui.admin.config.ConfigUI;
import fr.ird.observe.ui.admin.config.SelectDataUI;
import fr.ird.observe.ui.admin.consolidate.ConsolidateModel;
import fr.ird.observe.ui.admin.consolidate.ConsolidateUI;
import fr.ird.observe.ui.admin.export.ExportModel;
import fr.ird.observe.ui.admin.export.ExportUI;
import fr.ird.observe.ui.admin.gps.ImportGPSModel;
import fr.ird.observe.ui.admin.gps.ImportGPSUI;
import fr.ird.observe.ui.admin.report.ReportModel;
import fr.ird.observe.ui.admin.report.ReportUI;
import fr.ird.observe.ui.admin.resume.ShowResumeUI;
import fr.ird.observe.ui.admin.save.SaveLocalModel;
import fr.ird.observe.ui.admin.save.SaveLocalUI;
import fr.ird.observe.ui.admin.synchronize.SynchronizeModel;
import fr.ird.observe.ui.admin.synchronize.SynchronizeUI;
import fr.ird.observe.ui.admin.validate.ValidateModel;
import fr.ird.observe.ui.admin.validate.ValidateUI;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import javax.swing.ImageIcon;
import jaxx.runtime.swing.wizard.ext.WizardExtStep;
import jaxx.runtime.swing.wizard.ext.WizardExtUI;
import org.nuiton.i18n.I18n;

public enum AdminStep implements WizardExtStep
{
    CONFIG(I18n.n_((String)"observe.synchro.step.config", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.config.description", (Object[])new Object[0]), null, ConfigUI.class, true),
    SELECT_DATA(I18n.n_((String)"observe.synchro.step.selectData", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.selectData.description", (Object[])new Object[0]), null, SelectDataUI.class, true),
    SYNCHRONIZE(I18n.n_((String)"observe.synchro.step.synchronize", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.synchronize.description", (Object[])new Object[0]), I18n.n_((String)"observe.title.synchronize", (Object[])new Object[0]), I18n.n_((String)"observe.title.synchronize.tip", (Object[])new Object[0]), "synchronizeReferentiel", I18n.n_((String)"observe.synchro.operation.synchronize", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.operation.synchronize.description", (Object[])new Object[0]), SynchronizeModel.class, SynchronizeUI.class, true, false, true, false, DbMode.USE_LOCAL, DbMode.USE_REMOTE),
    VALIDATE(I18n.n_((String)"observe.synchro.step.validate", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.validate.description", (Object[])new Object[0]), I18n.n_((String)"observe.title.validate", (Object[])new Object[0]), I18n.n_((String)"observe.title.validate.tip", (Object[])new Object[0]), "validate", I18n.n_((String)"observe.synchro.operation.validate", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.operation.validate.description", (Object[])new Object[0]), ValidateModel.class, ValidateUI.class, false, true, false, false, DbMode.USE_LOCAL, DbMode.USE_REMOTE),
    CONSOLIDATE(I18n.n_((String)"observe.synchro.step.consolidate", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.consolidate.description", (Object[])new Object[0]), I18n.n_((String)"observe.title.consolidate", (Object[])new Object[0]), I18n.n_((String)"observe.title.consolidate.tip", (Object[])new Object[0]), "consolidate", I18n.n_((String)"observe.synchro.operation.consolidate", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.operation.consolidate.description", (Object[])new Object[0]), ConsolidateModel.class, ConsolidateUI.class, false, true, false, false, DbMode.USE_LOCAL, DbMode.USE_REMOTE),
    REPORT(I18n.n_((String)"observe.synchro.step.report", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.report.description", (Object[])new Object[0]), I18n.n_((String)"observe.title.report", (Object[])new Object[0]), I18n.n_((String)"observe.title.report.tip", (Object[])new Object[0]), "report", I18n.n_((String)"observe.synchro.operation.report", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.operation.report.description", (Object[])new Object[0]), ReportModel.class, ReportUI.class, false, true, false, false, DbMode.USE_LOCAL, DbMode.USE_REMOTE),
    ANALYZE_ACCESS(I18n.n_((String)"observe.synchro.step.analyze.access", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.analyze.access.description", (Object[])new Object[0]), I18n.n_((String)"observe.title.analyze.access", (Object[])new Object[0]), I18n.n_((String)"observe.title.analyze.access.tip", (Object[])new Object[0]), "analyze.access", I18n.n_((String)"observe.synchro.operation.analyze.access", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.operation.analyze.access.description", (Object[])new Object[0]), AccessModel.class, AnalyzeAccessUI.class, true, false, false, false, new DbMode[0]),
    ACCESS(I18n.n_((String)"observe.synchro.step.access", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.access.description", (Object[])new Object[0]), I18n.n_((String)"observe.title.access", (Object[])new Object[0]), I18n.n_((String)"observe.title.access.tip", (Object[])new Object[0]), "access", I18n.n_((String)"observe.synchro.operation.access", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.operation.access.description", (Object[])new Object[0]), AccessModel.class, AccessUI.class, true, false, false, false, new DbMode[0]),
    IMPORT_GPS(I18n.n_((String)"observe.synchro.step.importGPS", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.importGPS.description", (Object[])new Object[0]), I18n.n_((String)"observe.title.importGPS", (Object[])new Object[0]), I18n.n_((String)"observe.title.importGPS.tip", (Object[])new Object[0]), "importGPS", I18n.n_((String)"observe.synchro.operation.importGPS", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.operation.importGPS.description", (Object[])new Object[0]), ImportGPSModel.class, ImportGPSUI.class, false, false, false, false, DbMode.USE_LOCAL, DbMode.USE_REMOTE),
    SAVE_LOCAL(I18n.n_((String)"observe.synchro.step.saveLocal", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.saveLocal.description", (Object[])new Object[0]), null, null, "save", I18n.n_((String)"observe.synchro.operation.saveLocal", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.operation.saveLocal.description", (Object[])new Object[0]), SaveLocalModel.class, SaveLocalUI.class, false, false, false, false, new DbMode[0]),
    EXPORT_DATA(I18n.n_((String)"observe.synchro.step.exportData", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.exportData.description", (Object[])new Object[0]), I18n.n_((String)"observe.title.exportData", (Object[])new Object[0]), I18n.n_((String)"observe.title.exportData.tip", (Object[])new Object[0]), "remote-export", I18n.n_((String)"observe.synchro.operation.exportData", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.operation.exportData.description", (Object[])new Object[0]), ExportModel.class, ExportUI.class, true, true, false, false, DbMode.USE_LOCAL, DbMode.USE_REMOTE),
    SHOW_RESUME(I18n.n_((String)"observe.synchro.step.showResume", (Object[])new Object[0]), I18n.n_((String)"observe.synchro.step.showResume.description", (Object[])new Object[0]), null, ShowResumeUI.class, false);

    private final String iconName;
    private final String title;
    private final String titleTip;
    private final String label;
    private final String description;
    private final String operationLabel;
    private final String operationDescription;
    private final Class<? extends AdminActionModel> modelClass;
    private final Class<? extends AdminTabUI> uiClass;
    private final DbMode[] incomingModes;
    private final boolean needReferentiel;
    private final boolean needSave;
    private final boolean needSelect;
    private final boolean config;
    private transient ImageIcon icon;

    public static EnumSet<AdminStep> getOperations() {
        EnumSet<AdminStep> operations = EnumSet.noneOf(AdminStep.class);
        for (AdminStep step : AdminStep.values()) {
            if (!step.isOperation()) continue;
            operations.add(step);
        }
        return operations;
    }

    private AdminStep(String label, String description, Class<? extends AdminActionModel> modelClass, Class<? extends AdminTabUI> uiClass, boolean config) {
        this(label, description, null, null, null, null, null, modelClass, uiClass, false, false, false, config, new DbMode[0]);
    }

    private AdminStep(String label, String description, String title, String titleTip, String iconName, String operationLabel, String operationDescription, Class<? extends AdminActionModel> modelClass, Class<? extends AdminTabUI> uiClass, boolean needReferentiel, boolean needSelect, boolean needSave, boolean config, DbMode ... incomingModes) {
        this.label = label;
        this.description = description;
        this.title = title;
        this.titleTip = titleTip;
        this.iconName = iconName;
        this.operationDescription = operationDescription;
        this.operationLabel = operationLabel;
        this.needReferentiel = needReferentiel;
        this.needSave = needSave;
        this.needSelect = needSelect;
        this.modelClass = modelClass;
        this.uiClass = uiClass;
        this.config = config;
        this.incomingModes = incomingModes;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleTip() {
        return this.titleTip;
    }

    public String getIconName() {
        return this.iconName;
    }

    public ImageIcon getIcon() {
        if (this.iconName != null && this.icon == null) {
            this.icon = (ImageIcon)UIHelper.getUIManagerActionIcon((String)this.iconName);
        }
        return this.icon;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOperationDescription() {
        return this.operationDescription;
    }

    public String getOperationLabel() {
        return this.operationLabel;
    }

    public boolean isOperation() {
        return this.operationLabel != null;
    }

    public boolean isConfig() {
        return this.config;
    }

    public boolean isNeedSelect() {
        return this.needSelect;
    }

    public Class<? extends AdminActionModel> getModelClass() {
        return this.modelClass;
    }

    public Class<? extends AdminTabUI> getUiClass() {
        return this.uiClass;
    }

    public AdminActionModel newModel() {
        if (!this.isOperation()) {
            throw new IllegalStateException("The current step [" + (Object)((Object)this) + "] is not an operation.");
        }
        try {
            return this.getModelClass().newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not init model : " + this.getModelClass(), e);
        }
    }

    public AdminTabUI newUI(WizardExtUI<?, ?> ui) {
        try {
            Constructor<? extends AdminTabUI> constructor = this.uiClass.getConstructor(AdminUI.class);
            AdminTabUI tabPanelUI = constructor.newInstance(ui);
            return tabPanelUI;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not init ui " + (Object)((Object)this), e);
        }
    }

    public boolean isNeedReferentiel() {
        return this.needReferentiel;
    }

    public boolean isNeedSave() {
        return this.needSave;
    }

    public DbMode[] getIncomingModes() {
        return this.incomingModes;
    }

    public boolean hasIncomingModes() {
        return this.incomingModes.length > 0;
    }

    public static AdminStep valueOfIgnoreCase(String value) {
        for (AdminStep step : AdminStep.values()) {
            if (!step.name().equalsIgnoreCase(value)) continue;
            return step;
        }
        return null;
    }
}

