/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.ref;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.entities.referentiel.ReferentielEntity;
import fr.ird.observe.ui.content.ref.ContentReferentielUI;
import fr.ird.observe.ui.content.ref.ContentReferentielUIHandler;
import java.util.EnumMap;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentReferentielUIHandlerFactory {
    private static final Log log = LogFactory.getLog(ContentReferentielUIHandlerFactory.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static EnumMap<ObserveEntityEnum, HandlerDefinition<?>> mapping;

    public static <E extends ReferentielEntity> ContentReferentielUIHandler<E> newHandler(ContentReferentielUI<E> ui) {
        ObserveEntityEnum constant;
        HandlerDefinition<E> definition;
        Class type = ui.getModel().getBeanType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("recherche handler pour " + type));
        }
        if ((definition = ContentReferentielUIHandlerFactory.getDefinition(constant = ObserveEntityEnum.valueOf(type))) == null) {
            throw new IllegalStateException("Aucune d\u00e9finition pour l'objet " + constant);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("create handler for " + type));
        }
        ContentReferentielUIHandler<E> result = definition.toHandler(ui);
        return result;
    }

    protected static <E extends ReferentielEntity> HandlerDefinition<E> getDefinition(ObserveEntityEnum constant) {
        HandlerDefinition<?> definition = ContentReferentielUIHandlerFactory.getMapping().get(constant);
        return definition;
    }

    protected static void loadMapping() {
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.ActiviteBateau);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.ActiviteEnvironnante);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.CauseCoupNul);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.CauseNonCoupSenne);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.DevenirFaune);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.DevenirObjet);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.GroupeEspeceFaune);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.ModeDetection);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.Ocean);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.OperationBalise);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.OperationObjet);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.RaisonRejet);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.StatutEspece);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.TypeBalise);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.TypeBateau);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.TypeObjet);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.Bateau, new String[]{"pecherie", "jauge", "pavillon", "codeQuille", "codeFlotte", "anneeService", "longueurHorsToute", "capaciteTransport", "puissanceGroupePrincipal", "vitesseMaximaleProcespection", "dateChargement"}, "pecherie.selectedItem", "jauge.selectedItem", "pavillon.selectedItem", "codeQuille.model", "codeFlotte.model", "anneeService.model", "longueurHorsToute.model", "capaciteTransport.model", "puissanceGroupePrincipal.model", "vitesseMaximaleProcespection.model", "dateChargement.date");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.CategorieBateau, new String[]{"libelleJauge", "libelleCapacite"}, "libelleCapacite.text", "libelleJauge.text");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.CategoriePoids, new String[]{"code", "espece"}, new String[]{"code", "espece"}, new String[]{"code.text", "espece.selectedItem"});
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.EspeceFaune, new String[]{"groupe", "ocean"}, "groupe.selectedItem");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.EspeceThon, new String[]{"ocean"}, new String[0]);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.Observateur, new String[]{"identifiant", "nom", "prenom"}, new String[]{"identifiant"}, new String[]{"identifiant.text", "nom.text", "prenom.text"});
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.Organisme, new String[]{"pays", "description"}, "pays.selectedItem", "description.text");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.ParametrageTaillePoidsFaune, EMPTY_STRING_ARRAY, new String[]{"sexe", "ocean", "espece", "debutValidite"}, EMPTY_STRING_ARRAY);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.ParametrageTaillePoidsThon, EMPTY_STRING_ARRAY, new String[]{"sexe", "ocean", "espece", "debutValidite"}, EMPTY_STRING_ARRAY);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.Pays, new String[]{"codeIso2", "codeIso3"}, "codeIso2.text", "codeIso3.text");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.Programme, new String[]{"organisme", "dateDebutProgramme", "dateFinProgramme", "observationActivitesDetaillees", "observationFauneAssociee", "observationGleure", "observationMammiferes", "observationMensurations", "observationObjetFlottant", "observationOiseaux", "observationRejetsThons"}, "organisme.selectedItem", "dateDebutProgramme.date", "dateFinProgramme.date", "observationActivitesDetaillees.selectedIndex", "observationFauneAssociee.selectedIndex", "observationGleure.selectedIndex", "observationMammiferes.selectedIndex", "observationMensurations.selectedIndex", "observationObjetFlottant.selectedIndex", "observationOiseaux.selectedIndex", "observationRejetsThons.selectedIndex");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.Senne, new String[]{"identifiant", "longueur", "chute", "poidsLest"}, new String[]{"identifiant"}, new String[]{"identifiant.text", "longueur.model", "chute.model", "poidsLest.model"});
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.SystemeObserve, new String[]{"typeBanc"}, "typeBanc.selectedIndex");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveEntityEnum.VentBeaufort, new String[]{"libelleDescriptifVent", "libelleVitesseVent", "libelleDescriptifMer", "libelleHauteurMoyenneVagues"}, "libelleDescriptifVent.text", "libelleVitesseVent.text", "libelleDescriptifMer.text", "libelleHauteurMoyenneVagues.text");
        if (log.isInfoEnabled()) {
            log.info((Object)(mapping.size() + " d\u00e9finitions de r\u00e9f\u00e9rentiel enregistr\u00e9es."));
        }
        if (mapping.size() != DBHelper.REFERENTIEL_ENTITIES_LIST.size()) {
            EnumSet missing = EnumSet.copyOf(DBHelper.REFERENTIEL_ENTITIES_LIST);
            missing.removeAll(mapping.keySet());
            throw new IllegalStateException("Un des \u00e9crans du r\u00e9f\u00e9rentiel n'est pas d\u00e9fini : " + missing);
        }
    }

    protected static EnumMap<ObserveEntityEnum, HandlerDefinition<?>> getMapping() {
        if (mapping == null) {
            mapping = new EnumMap(ObserveEntityEnum.class);
            ContentReferentielUIHandlerFactory.loadMapping();
        }
        return mapping;
    }

    protected static void registerMapping(ObserveEntityEnum entityClass) {
        ContentReferentielUIHandlerFactory.registerMapping(entityClass, null, new String[0]);
    }

    protected static void registerMapping(ObserveEntityEnum entityClass, String[] extraProperties, String ... extraDataBindings) {
        ContentReferentielUIHandlerFactory.registerMapping(entityClass, extraProperties, null, extraDataBindings);
    }

    protected static void registerMapping(ObserveEntityEnum entityClass, String[] extraProperties, String[] naturalIds, String ... extraDataBindings) {
        HandlerDefinition ref = new HandlerDefinition(entityClass.getContract(), naturalIds, extraProperties, extraDataBindings);
        mapping.put(entityClass, ref);
    }

    protected static class HandlerDefinition<E extends ReferentielEntity> {
        protected Class<E> entityClass;
        protected String[] extraProperties;
        protected String[] naturalIds;
        protected String[] extraDataBindings;

        public HandlerDefinition(Class<E> entityClass, String[] naturalIds, String[] extraProperties, String[] extraDataBindings) {
            this.entityClass = entityClass;
            this.naturalIds = naturalIds;
            this.extraProperties = extraProperties == null ? EMPTY_STRING_ARRAY : extraProperties;
            this.extraDataBindings = extraDataBindings == null ? EMPTY_STRING_ARRAY : extraDataBindings;
        }

        public Class<E> getEntityClass() {
            return this.entityClass;
        }

        public String[] getExtraProperties() {
            return this.extraProperties;
        }

        public String[] getNaturalIds() {
            return this.naturalIds;
        }

        public String[] getExtraDataBindings() {
            return this.extraDataBindings;
        }

        public ContentReferentielUIHandler<E> toHandler(ContentReferentielUI<E> ui) {
            ContentReferentielUIHandler<E> result = new ContentReferentielUIHandler<E>(ui, this.getExtraProperties(), this.getNaturalIds(), this.getExtraDataBindings());
            return result;
        }
    }
}

