/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl;

import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaptureFaune;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.TailleFaune;
import fr.ird.observe.entities.referentiel.DevenirFaune;
import fr.ird.observe.entities.referentiel.EspeceFaune;
import fr.ird.observe.entities.referentiel.RaisonRejet;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.CaptureFauneUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public class CaptureFauneUIHandler
extends ContentTableUIHandler<Calee, CaptureFaune> {
    private static Log log = LogFactory.getLog(CaptureFauneUIHandler.class);
    JAXXContextEntryDef<List<TailleFaune>> ALL_TAILLES_TO_DELETE_ENTRY = UIHelper.newListContextEntryDef((String)"all-taille-to-delete");

    public static ContentTableUIModel<Calee, CaptureFaune> newModel(CaptureFauneUI ui) {
        return new ContentTableUIModel<Calee, CaptureFaune>(Calee.class, CaptureFaune.class, new String[]{"captureFaune", "rejetFaune"}, new String[]{"espece", "poidsEstime", "nombreEstime", "poidsMoyen", "tailleMoyenne", "raisonRejet", "devenirFaune", "nombreEstimeCalcule", "poidsMoyenCalcule", "poidsEstimeCalcule", "tailleMoyenneCalcule", "commentaire"}, ui, ContentTableModel.newTableMeta(CaptureFaune.class, "espece", false), ContentTableModel.newTableMeta(CaptureFaune.class, "devenirFaune", false), ContentTableModel.newTableMeta(CaptureFaune.class, "raisonRejet", false), ContentTableModel.newTableMeta(CaptureFaune.class, "poidsEstime", false), ContentTableModel.newTableMeta(CaptureFaune.class, "nombreEstime", false), ContentTableModel.newTableMeta(CaptureFaune.class, "poidsMoyen", false), ContentTableModel.newTableMeta(CaptureFaune.class, "tailleMoyenne", false), ContentTableModel.newTableMeta(CaptureFaune.class, "commentaire", false));
    }

    public CaptureFauneUIHandler(CaptureFauneUI ui) {
        super(ui);
    }

    @Override
    public CaptureFauneUI getUi() {
        return (CaptureFauneUI)super.getUi();
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, CaptureFaune bean, boolean create) {
        CaptureFauneUI ui = this.getUi();
        if (this.getTableModel().isEditable()) {
            ui.getEspece().requestFocus();
        } else {
            ui.getTable().requestFocus();
        }
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)55);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)65);
        UIHelper.fixTableColumnWidth((JTable)table, (int)5, (int)75);
        UIHelper.fixTableColumnWidth((JTable)table, (int)6, (int)55);
        UIHelper.fixTableColumnWidth((JTable)table, (int)7, (int)50);
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.captureFaune.especeFaune"), I18n.n_((String)"observe.table.captureFaune.especeFaune.tip"), I18n.n_((String)"observe.table.captureFaune.devenirFaune"), I18n.n_((String)"observe.table.captureFaune.devenirFaune.tip"), I18n.n_((String)"observe.table.captureFaune.raisonRejet"), I18n.n_((String)"observe.table.captureFaune.raisonRejet.tip"), I18n.n_((String)"observe.table.captureFaune.poidsEstime"), I18n.n_((String)"observe.table.captureFaune.poidsEstime.tip"), I18n.n_((String)"observe.table.captureFaune.nombreEstime"), I18n.n_((String)"observe.table.captureFaune.nombreEstime.tip"), I18n.n_((String)"observe.table.captureFaune.poidsMoyen"), I18n.n_((String)"observe.table.captureFaune.poidsMoyen.tip"), I18n.n_((String)"observe.table.captureFaune.tailleMoyenne"), I18n.n_((String)"observe.table.captureFaune.tailleMoyenne.tip"), I18n.n_((String)"observe.table.captureFaune.commentaire"), I18n.n_((String)"observe.table.captureFaune.commentaire.tip")});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceFaune.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, DevenirFaune.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, RaisonRejet.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)5, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)6, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)7, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doSave(Calee bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Calee> binder) throws Exception {
        try {
            boolean bl = super.doSave(bean, dataService, dataSource, binder);
            return bl;
        }
        finally {
            this.ALL_TAILLES_TO_DELETE_ENTRY.removeContextValue((JAXXContext)this.getUi());
        }
    }

    @Override
    protected boolean prepareSave(Calee editBean, List<CaptureFaune> objets) throws Exception {
        super.prepareSave(editBean, objets);
        List especesUsed = this.getTableModel().getColumnValues(0);
        HashSet especesToDelete = new HashSet();
        ArrayList tailleToDelete = new ArrayList();
        this.getDataService().getObsoleteEspeceForEchantillonFaune(this.getDataSource(), editBean.getTopiaId(), especesUsed, especesToDelete, tailleToDelete);
        if (!tailleToDelete.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            Decorator decorator = this.getDecoratorService().getDecorator(EspeceFaune.class);
            Decorator decorator2 = this.getDecoratorService().getDecorator(TailleFaune.class);
            for (EspeceFaune e : especesToDelete) {
                sb.append("  - ").append(decorator.toString((Object)e)).append('\n');
            }
            for (TailleFaune t : tailleToDelete) {
                sb2.append("  - ").append(decorator2.toString((Object)t)).append('\n');
            }
            int reponse = UIHelper.askUser(I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.table.captureFaune.will.delete.tailleFaune", (Object[])new Object[]{sb.toString(), sb2.toString()}), 0, new Object[]{I18n._((String)"observe.choice.continue"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            boolean canContinue = false;
            switch (reponse) {
                case 0: {
                    canContinue = true;
                }
            }
            if (!canContinue) {
                return false;
            }
            this.ALL_TAILLES_TO_DELETE_ENTRY.setContextValue((JAXXContext)this.getUi(), tailleToDelete);
        }
        boolean hasRejet = false;
        for (CaptureFaune c : objets) {
            if (c.getRaisonRejet() == null) continue;
            hasRejet = true;
            break;
        }
        editBean.setRejetFaune(Boolean.valueOf(hasRejet));
        return true;
    }

    @Override
    protected void onUpdateFinalize(TopiaContext tx, Calee bean, Collection<CaptureFaune> oldChilds) {
        List tailleToDelete = (List)this.ALL_TAILLES_TO_DELETE_ENTRY.getContextValue((JAXXContext)this.getUi());
        if (tailleToDelete != null && !tailleToDelete.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will remove " + tailleToDelete.size() + " obsolete tailleFaune(s)."));
            }
            EchantillonFaune echantillon = (EchantillonFaune)bean.getEchantillonFaune().get(0);
            echantillon.getTailleFaune().removeAll(tailleToDelete);
        }
    }
}

