/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report;

import fr.ird.observe.report.model.DataMatrix;
import fr.ird.observe.report.model.Report;
import java.io.Serializable;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ResultTableModel.class);
    protected transient DataMatrix data;

    public void populate(Report report, DataMatrix data) {
        int i;
        boolean withRowHeader;
        if (report == null) {
            this.clear();
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("from report : " + report));
        }
        DataMatrix allData = new DataMatrix();
        DataMatrix rowData = null;
        DataMatrix columnData = null;
        int nbRows = data.getHeight();
        int nbCols = data.getWidth();
        String[] columnNames = report.getColumnHeaders();
        String[] rowNames = report.getRowHeaders();
        boolean withColumnHeader = columnNames != null && columnNames.length > 0;
        boolean bl = withRowHeader = rowNames != null && rowNames.length > 0;
        if (withColumnHeader) {
            ++nbRows;
            nbCols = columnNames.length;
            data.setY(1);
            rowData = new DataMatrix();
            rowData.setWidth(nbCols);
            rowData.setHeight(1);
            rowData.createData();
            for (i = 0; i < nbCols; ++i) {
                String columnName = columnNames[i];
                rowData.setValue(i, 0, (Object)columnName);
            }
            if (withRowHeader) {
                rowData.setX(1);
            }
        }
        if (withRowHeader) {
            ++nbCols;
            nbRows = rowNames.length;
            data.setX(1);
            columnData = new DataMatrix();
            columnData.setWidth(1);
            columnData.setHeight(nbRows);
            columnData.createData();
            for (i = 0; i < nbRows; ++i) {
                String rowName = rowNames[i];
                columnData.setValue(0, i, (Object)rowName);
            }
            if (withColumnHeader) {
                columnData.setY(1);
                ++nbRows;
            }
        }
        allData.setHeight(nbRows);
        allData.setWidth(nbCols);
        if (log.isInfoEnabled()) {
            log.info((Object)("final data dimension : " + allData.getDimension() + " vs " + data.getDimension()));
        }
        allData.createData();
        if (withRowHeader) {
            allData.copyData(columnData);
        }
        if (withColumnHeader) {
            allData.copyData(rowData);
        }
        allData.copyData(data);
        this.data = allData;
        this.fireTableStructureChanged();
    }

    public void clear() {
        this.data = null;
        this.fireTableStructureChanged();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.getHeight();
    }

    @Override
    public int getColumnCount() {
        return this.data == null ? 0 : this.data.getWidth();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Serializable data = this.data == null ? null : this.data.getValue(columnIndex, rowIndex);
        return data;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public String getClipbordContent() {
        return this.data == null ? "" : this.data.getClipbordContent();
    }
}

