/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.access;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.ui.admin.access.AccessEntityMeta;
import fr.ird.observe.ui.admin.access.metas.IntToBoolean;
import fr.ird.observe.ui.admin.access.metas.IntToCoordonne;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityOperator;

public class AccessEntityProxyHandler<E extends TopiaEntity>
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(AccessEntityProxyHandler.class);
    protected AccessEntityMeta<E> meta;
    protected int rowId;
    protected Object[] pkey;
    protected final E entity;
    protected final EntityOperator<E> operator;

    public AccessEntityProxyHandler(AccessEntityMeta<E> meta, int rowId, Object[] pkey) throws Exception {
        this.meta = meta;
        this.rowId = rowId;
        this.pkey = pkey;
        ObserveEntityEnum type = meta.getType();
        Class contract = type.getContract();
        this.operator = ObserveDAOHelper.getOperator((Class)contract);
        this.entity = (TopiaEntity)type.getImplementation().newInstance();
    }

    public E getEntity() {
        return this.entity;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getPkey".equals(methodName) && args == null) {
            return this.pkey;
        }
        if ("getRowId".equals(methodName) && args == null) {
            return this.rowId;
        }
        if ("getMeta".equals(methodName) && args == null) {
            return this.meta;
        }
        if ("getTopiaEntity".equals(methodName) && args == null) {
            return this.entity;
        }
        if ("setProperty".equals(methodName) && args != null && args.length == 2) {
            String propertyName = (String)args[0];
            Object value = args[1];
            this.setProperty(propertyName, value);
            return null;
        }
        if ("addListProperty".equals(methodName) && args != null && args.length == 2) {
            String propertyName = (String)args[0];
            Object value = args[1];
            this.addListProperty(propertyName, value);
            return null;
        }
        if ("accept".equals(methodName) && args != null && args.length == 1 && args[0] instanceof EntityVisitor) {
            EntityVisitor visitor = (EntityVisitor)args[0];
            this.accept((TopiaEntity)proxy, visitor);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will invoke on entity " + method));
        }
        return method.invoke(this.entity, args);
    }

    public void setProperty(String propertyName, Object value) {
        if (value == null) {
            return;
        }
        try {
            if (!(value instanceof TopiaEntity)) {
                AccessEntityMeta.PropertyMapping mapping = this.meta.getPropertyMapping(propertyName);
                if (mapping.getType().equals(Float.class)) {
                    value = Float.valueOf(value + "");
                }
                if (mapping.getType().equals(IntToCoordonne.class)) {
                    IntToCoordonne c = new IntToCoordonne(Integer.valueOf(value + ""));
                    value = c.getFloatValue();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(propertyName + " " + c.getIntValue() + " --> " + value));
                    }
                }
                if (mapping.getType().equals(Integer.class)) {
                    value = new Integer(Float.valueOf(value + "").intValue());
                }
                if (mapping.getType().equals(IntToBoolean.class)) {
                    IntToBoolean bValue = new IntToBoolean(Float.valueOf(value + "").intValue());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Will set [" + propertyName + ":" + bValue.getIntValue() + "-" + bValue.getBooleanvalue() + "] to " + this.entity));
                    }
                    value = bValue.getBooleanvalue();
                }
                if (this.meta.getType() == ObserveEntityEnum.EchantillonThon && "capture".equals(propertyName)) {
                    String sCapture = (value + "").trim();
                    value = sCapture.equalsIgnoreCase("C");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("echantillonThon [capture] = " + sCapture + " - " + value));
                    }
                }
                if (this.meta.getType() == ObserveEntityEnum.Maree && "dateArriveePort".equals(propertyName)) {
                    value = value + "";
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will set [" + propertyName + ":" + value + "] to " + this.entity));
            }
            this.operator.set(propertyName, this.entity, value);
        }
        catch (RuntimeException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Could not set [" + propertyName + ":" + value + "] on " + this.entity), (Throwable)e);
            }
            throw e;
        }
    }

    public void addListProperty(String name, Object value) {
        if (this.entity == null) {
            throw new IllegalStateException("Can not add any association while entity [" + this + "] is not created...");
        }
        this.operator.addChild(name, this.entity, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(E entity, EntityVisitor visitor) throws TopiaException {
        this.operator.getNaturalId(entity);
        visitor.start(entity);
        try {
            for (AccessEntityMeta.PropertyMapping propertyMapping : this.meta.getPropertyMapping()) {
                visitor.visit(entity, propertyMapping.getProperty(), propertyMapping.getType(), null);
            }
            for (Serializable serializable : this.meta.getReverseAssociationMapping()) {
                visitor.visit(entity, ((AccessEntityMeta.AssociationMapping)serializable).getProperty(), ((AccessEntityMeta.AssociationMapping)serializable).getType(), null);
            }
            for (Serializable serializable : this.meta.getAssocationMapping()) {
                visitor.visit(entity, ((AccessEntityMeta.AssociationMapping)serializable).getProperty(), Collection.class, ((AccessEntityMeta.AssociationMapping)serializable).getType(), null);
            }
        }
        finally {
            visitor.end(entity);
        }
    }
}

