/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.ObserveContext;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NavigationTreeSelectionModel
extends DefaultTreeSelectionModel {
    private static final Log log = LogFactory.getLog(NavigationTreeSelectionModel.class);
    private static final long serialVersionUID = 1L;

    @Override
    public void addSelectionPath(TreePath newPath) {
        TreePath oldPath = this.getSelectionPath();
        if (log.isDebugEnabled()) {
            log.debug((Object)">------------------------------------------------------------------------------");
            log.debug((Object)"Try to change selection");
            log.debug((Object)("old path " + oldPath));
            log.debug((Object)("new path " + newPath));
        }
        boolean canChange = this.beforeSelectionPath(oldPath, newPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can change path ? " + canChange));
            log.debug((Object)"<------------------------------------------------------------------------------");
        }
        if (!canChange) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("will select path " + newPath));
        }
        super.addSelectionPath(newPath);
    }

    @Override
    public void setSelectionPath(TreePath newPath) {
        TreePath oldPath = this.getSelectionPath();
        if (log.isDebugEnabled()) {
            log.debug((Object)">------------------------------------------------------------------------------");
            log.debug((Object)"Try to change selection");
            log.debug((Object)("old path " + oldPath));
            log.debug((Object)("new path " + newPath));
        }
        boolean canChange = this.beforeSelectionPath(oldPath, newPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can change path ? " + canChange));
            log.debug((Object)"<------------------------------------------------------------------------------");
        }
        if (!canChange) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("will select path " + newPath));
        }
        super.setSelectionPath(newPath);
    }

    protected boolean beforeSelectionPath(TreePath oldPath, TreePath newPath) {
        boolean canChange = true;
        if (newPath.equals(oldPath)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("skip stay on path " + newPath));
            }
            canChange = false;
        }
        if (canChange && !this.isSelectionEmpty()) {
            canChange = ObserveContext.get().closeSelectedContentUI();
        }
        return canChange;
    }
}

