/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util;

import javax.swing.JComboBox;
import org.apache.commons.lang.xwork.StringUtils;
import org.nuiton.i18n.I18n;

public class BooleanEditor
extends JComboBox {
    protected static ValueEntry[] buildModel(String nullLibelle, String falseLibelle, String trueLibelle) {
        ValueEntry[] result = new ValueEntry[3];
        String text = StringUtils.isBlank((String)nullLibelle) ? Value.NULL.getDefaultLibelle() : nullLibelle;
        result[0] = new ValueEntry(Value.NULL, I18n._((String)text));
        text = StringUtils.isBlank((String)falseLibelle) ? Value.FALSE.getDefaultLibelle() : falseLibelle;
        result[1] = new ValueEntry(Value.FALSE, I18n._((String)text));
        text = StringUtils.isBlank((String)trueLibelle) ? Value.TRUE.getDefaultLibelle() : trueLibelle;
        result[2] = new ValueEntry(Value.TRUE, I18n._((String)text));
        return result;
    }

    public BooleanEditor() {
        this(null, null, null);
    }

    public BooleanEditor(String nullLibelle, String falseLibelle, String trueLibelle) {
        super(BooleanEditor.buildModel(nullLibelle, falseLibelle, trueLibelle));
    }

    public void setBooleanValue(Boolean b) {
        Value v = Value.valueOf(b);
        ValueEntry e = (ValueEntry)this.dataModel.getElementAt(v.ordinal());
        this.setSelectedItem(e);
    }

    public Boolean getBooleanValue() {
        Object o = this.getSelectedItem();
        if (o == null) {
            return null;
        }
        ValueEntry v = (ValueEntry)o;
        Boolean result = v.getValue().getBooleanValue();
        return result;
    }

    protected static class ValueEntry {
        protected final Value value;
        protected final String text;

        ValueEntry(Value value, String text) {
            this.value = value;
            this.text = text;
        }

        public Value getValue() {
            return this.value;
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueEntry that = (ValueEntry)o;
            if (!this.text.equals(that.text)) {
                return false;
            }
            return this.value == that.value;
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + this.text.hashCode();
            return result;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum Value {
        NULL(I18n.n_((String)"observe.common.boolean.null"), null),
        FALSE(I18n.n_((String)"observe.common.boolean.false"), false),
        TRUE(I18n.n_((String)"observe.common.boolean.true"), true);

        private final String defaultLibelle;
        private final Boolean booleanValue;

        private Value(String defaultLibelle, Boolean booleanValue) {
            this.defaultLibelle = defaultLibelle;
            this.booleanValue = booleanValue;
        }

        public Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public String getDefaultLibelle() {
            return this.defaultLibelle;
        }

        public static Value valueOf(Boolean value) {
            Value result = null;
            for (Value v : Value.values()) {
                if (v.getBooleanValue() != value) continue;
                result = v;
                break;
            }
            return result;
        }
    }
}

