/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.ObserveEntityEnum;
import fr.ird.observe.ui.content.ContentMode;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public class ContentUIModel<E extends TopiaEntity> {
    private static final Log log = LogFactory.getLog(ContentUIModel.class);
    public static final String PROPERTY_EDIT_BEAN = "editBean";
    public static final String PROPERTY_MODE = "mode";
    public static final String PROPERTY_READING_MODE = "readingMode";
    public static final String PROPERTY_CREATING_MODE = "creatingMode";
    public static final String PROPERTY_UPDATING_MODE = "updatingMode";
    public static final String PROPERTY_ENABLED = "enabled";
    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_EDITING = "editing";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_VALID = "valid";
    public static final String PROPERTY_CAN_WRITE = "canWrite";
    protected final Class<E> beanType;
    protected E bean;
    protected ContentMode mode = ContentMode.READ;
    protected boolean enabled;
    protected boolean editing;
    protected boolean valid;
    protected boolean modified;
    protected boolean editable;
    protected boolean canWrite;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public ContentUIModel(Class<E> beanType) {
        this.beanType = beanType;
        ObserveEntityEnum constant = ObserveEntityEnum.valueOf(beanType);
        if (constant != null) {
            try {
                this.setBean((TopiaEntity)constant.getImplementation().newInstance());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public E getBean() {
        return this.bean;
    }

    public ContentMode getMode() {
        return this.mode;
    }

    public boolean isCreatingMode() {
        return ContentMode.CREATE.equals((Object)this.getMode());
    }

    public boolean isUpdatingMode() {
        return ContentMode.UPDATE.equals((Object)this.getMode());
    }

    public boolean isReadingMode() {
        return ContentMode.READ.equals((Object)this.getMode());
    }

    public Class<E> getBeanType() {
        return this.beanType;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isCanWrite() {
        return this.canWrite;
    }

    public void setBean(E bean) {
        E oldValue = this.bean;
        this.bean = bean;
        this.firePropertyChange(PROPERTY_EDIT_BEAN, oldValue, bean);
    }

    public void setMode(ContentMode mode) {
        ContentMode oldValue = this.mode;
        this.mode = mode;
        this.firePropertyChange(PROPERTY_MODE, (Object)oldValue, (Object)mode);
        this.firePropertyChange(PROPERTY_READING_MODE, ContentMode.READ.equals((Object)oldValue), this.isReadingMode());
        this.firePropertyChange(PROPERTY_CREATING_MODE, ContentMode.CREATE.equals((Object)oldValue), this.isCreatingMode());
        this.firePropertyChange(PROPERTY_UPDATING_MODE, ContentMode.UPDATE.equals((Object)oldValue), this.isUpdatingMode());
    }

    public void setEnabled(boolean enabled) {
        Boolean oldValue = this.enabled;
        this.enabled = enabled;
        this.firePropertyChange(PROPERTY_ENABLED, oldValue, enabled);
    }

    public void setEditing(boolean editing) {
        Boolean oldValue = this.editing;
        this.editing = editing;
        this.firePropertyChange(PROPERTY_EDITING, oldValue, editing);
    }

    public void setEditable(boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        this.firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setValid(boolean valid) {
        Boolean oldValue = this.valid;
        this.valid = valid;
        this.firePropertyChange(PROPERTY_VALID, oldValue, valid);
    }

    public void setModified(boolean modified) {
        Boolean oldValue = this.modified;
        this.modified = modified;
        this.firePropertyChange(PROPERTY_MODIFIED, oldValue, modified);
    }

    public void setCanWrite(boolean canWrite) {
        boolean oldValue = this.isCanWrite();
        this.canWrite = canWrite;
        this.firePropertyChange(PROPERTY_CAN_WRITE, oldValue, canWrite);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        this.firePropertyChange(propertyName, null, newValue);
    }
}

