/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceConfig;
import fr.ird.observe.db.constants.ConnexionStatus;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.impl.H2DataSourceConfig;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.db.util.PGInstall;
import fr.ird.observe.db.util.SecurityModel;
import fr.ird.observe.ui.storage.ObstunaAdminAction;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.wizard.WizardModel;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.WizardUILancher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;

public class StorageUIModel
extends WizardModel<StorageStep> {
    private static Log log = LogFactory.getLog(StorageUIModel.class);
    public static final String DB_MODE_PROPERTY_NAME = "dbMode";
    public static final String CREATION_MODE_PROPERTY_NAME = "creationMode";
    public static final String DO_BACKUP_PROPERTY_NAME = "doBackup";
    public static final String BACKUP_FILE_PROPERTY_NAME = "backupFile";
    public static final String DUMP_FILE_PROPERTY_NAME = "dumpFile";
    public static final String LOCAL_STORAGE_EXIST_PROPERTY_NAME = "localStorageExist";
    public static final String USE_SSL_PROPERTY_NAME = "useSsl";
    public static final String SSL_CERTIFICAT_FILE_PROPERTY_NAME = "sslCertificatFile";
    public static final String SSL_CERTIFICAT_PASSWORD_PROPERTY_NAME = "sslCertificatPassword";
    public static final String REMOTE_URL_ROPERTY_NAME = "remoteUrl";
    public static final String REMOTE_LOGIN_ROPERTY_NAME = "remoteLogin";
    public static final String REMOTE_PASSWORD_PROPERTY_NAME = "remotePassword";
    public static final String STORE_REMOTE_CONFIG_PROPERTY_NAME = "storeRemoteConfig";
    public static final String CONNEXION_STATUS_PROPERTY_NAME = "connexionStatus";
    public static final String PREVIOUS_SERVICE_PROPERTY_NAME = "previousSource";
    public static final String CAN_MIGRATE_PROPERTY_NAME = "canMigrate";
    public static final String SHOW_MIGRATION_SQL_PROPERTY_NAME = "showMigrationSql";
    public static final String SHOW_MIGRATION_PROGRESSION_PROPERTY_NAME = "showMigrationProgression";
    private static final String CAN_USE_LOCALE_SERVICE_PROPERTY_NAME = "canUseLocalService";
    private static final String CAN_CREATE_LOCALE_SERVICE_PROPERTY_NAME = "canCreateLocalService";
    private static final String CAN_USE_REMOTE_SERVICE_PROPERTY_NAME = "canUseRemoteService";
    public static final String VALID_PROPERTY_NAME = "valid";
    private static final char[] EMPTY_PASSWORD = new char[0];
    private static final String LOGIN_REFERENTIEL = "referentiel";
    protected DbMode dbMode;
    protected boolean localStorageExist;
    protected boolean doBackup;
    protected File backupFile = new File("");
    protected boolean storeRemoteConfig;
    protected DataSource previousService;
    protected boolean canUseLocalService = true;
    protected boolean canCreateLocalService = true;
    protected boolean canUseRemoteService = true;
    protected DataSelectionModel selectDataModel;
    protected SecurityModel securityModel;
    protected H2DataSourceConfig h2Config;
    protected PGDataSourceConfig pgConfig = new PGDataSourceConfig(I18n.n_((String)"observe.storage.label.remote"));
    protected ObserveConfig config;
    protected List<StorageStep> excludeSteps;
    protected ObstunaAdminAction adminAction;
    protected StorageUIModel centralSourceModel;
    protected PGInstall pgInstall;

    public StorageUIModel() {
        super(StorageStep.class, (WizardStep[])new StorageStep[]{StorageStep.CHOOSE_DB_MODE, StorageStep.BACKUP, StorageStep.CONFIRM});
        this.h2Config = new H2DataSourceConfig(I18n.n_((String)"observe.storage.label.local"));
        this.h2Config.setImportConfig((DataSourceConfig)this.pgConfig);
        this.securityModel = new SecurityModel();
        this.pgInstall = new PGInstall(this.pgConfig, this.securityModel);
    }

    public void init(JAXXContext context, DataSource source) {
        this.config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        JAXXContextEntryDef entryDef = WizardUILancher.newModelEntry(StorageUIModel.class);
        StorageUIModel incomingModel = (StorageUIModel)((Object)entryDef.getContextValue(context));
        if (incomingModel != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("from a incoming model " + incomingModel.getLabel() + " : " + (Object)((Object)incomingModel)));
            }
            incomingModel.copyTo(this);
            return;
        }
        StorageUIHandler storageUIHandler = (StorageUIHandler)context.getContextValue(StorageUIHandler.class);
        DataSelectionModel dataModel = (DataSelectionModel)context.getContextValue(DataSelectionModel.class);
        boolean localStorageExist = this.config.isLocalStorageExist();
        this.setLocalStorageExist(localStorageExist);
        if (!localStorageExist) {
            this.setCanUseLocalService(false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Local storage exists     ? " + this.isLocalStorageExist()));
            log.debug((Object)("can use local storage    ? " + this.isCanUseLocalService()));
            log.debug((Object)("can create local storage ? " + this.isCanCreateLocalService()));
            log.debug((Object)("can use remote   storage ? " + this.isCanUseRemoteService()));
            log.debug((Object)("previous service         ? " + source));
        }
        this.setStoreRemoteConfig(this.config.isStoreRemoteStorage());
        this.setBackupFile(new File(this.config.getBackupDirectory(), storageUIHandler.getDefaultBackupFilename()));
        this.setDumpFile(this.config.getBackupDirectory());
        this.setShowMigrationProgression(this.config.isShowMigrationProgression());
        this.setShowMigrationSql(this.config.isShowMigrationSql());
        this.setDoBackup(false);
        this.setPreviousService(source);
        if (log.isDebugEnabled()) {
            log.debug((Object)("canMigrate ? " + this.isCanMigrate()));
        }
        CreationMode mode = this.config.getDefaultCreationMode();
        if (source != null) {
            DataSourceConfig previousConfig;
            if (log.isDebugEnabled()) {
                log.debug((Object)("from a previous service " + source));
            }
            if ((previousConfig = source.getConfig()) instanceof H2DataSourceConfig) {
                this.fromStorageConfig(this.config.toPostgresStorageConfig(this.pgConfig.getLabel()));
                this.fromStorageConfig((H2DataSourceConfig)previousConfig);
            } else {
                this.fromStorageConfig(this.config.toH2StorageConfig(this.pgConfig.getLabel()));
                if (!localStorageExist) {
                    this.setCreationMode(mode);
                }
                this.fromStorageConfig((PGDataSourceConfig)previousConfig);
            }
            if (dataModel != null) {
                this.setSelectDataModel(dataModel);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"no service found, using default configuration ");
        }
        this.fromStorageConfig(this.config.toH2StorageConfig(this.pgConfig.getLabel()));
        this.fromStorageConfig(this.config.toPostgresStorageConfig(this.pgConfig.getLabel()));
        DbMode dbMode = this.config.getDefaultDbMode();
        if (this.getAdminAction() != null) {
            dbMode = DbMode.USE_REMOTE;
        } else if (this.isCanUseLocalService()) {
            mode = null;
        } else if (this.isCanCreateLocalService()) {
            mode = CreationMode.IMPORT_EXTERNAL_DUMP;
        } else if (this.isCanUseRemoteService()) {
            mode = CreationMode.IMPORT_REMOTE_STORAGE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use creationMode : " + mode));
        }
        this.setDbMode(dbMode);
        this.setCreationMode(mode);
    }

    public void initFromPreviousConfig(JAXXContext context, DataSourceConfig previousConfig) {
        if (previousConfig == null) {
            throw new NullPointerException("previousConfig parameter can not be null in method initFromPreviousConfig");
        }
        this.config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        StorageUIHandler storageUIHandler = (StorageUIHandler)context.getContextValue(StorageUIHandler.class);
        boolean localStorageExist = this.config.isLocalStorageExist();
        this.setLocalStorageExist(localStorageExist);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Local storage exists     ? " + this.isLocalStorageExist()));
            log.debug((Object)("can use local storage    ? " + this.isCanUseLocalService()));
            log.debug((Object)("can create local storage ? " + this.isCanCreateLocalService()));
            log.debug((Object)("can use remote   storage ? " + this.isCanUseRemoteService()));
            log.debug((Object)("previous service         ? " + previousConfig));
        }
        this.setStoreRemoteConfig(this.config.isStoreRemoteStorage());
        this.setBackupFile(new File(this.config.getBackupDirectory(), storageUIHandler.getDefaultBackupFilename()));
        this.setDumpFile(this.config.getBackupDirectory());
        this.setShowMigrationProgression(this.config.isShowMigrationProgression());
        this.setShowMigrationSql(this.config.isShowMigrationSql());
        this.setDoBackup(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("canMigrate ? " + this.isCanMigrate()));
        }
        if (previousConfig instanceof H2DataSourceConfig) {
            this.fromStorageConfig(this.config.toPostgresStorageConfig(this.pgConfig.getLabel()));
            this.fromStorageConfig((H2DataSourceConfig)previousConfig);
        } else {
            this.fromStorageConfig(this.config.toH2StorageConfig(this.pgConfig.getLabel()));
            if (!localStorageExist) {
                this.setCanUseLocalService(false);
            }
            this.fromStorageConfig((PGDataSourceConfig)previousConfig);
        }
    }

    public void initFromModel() {
        ObserveContext context = ObserveContext.get();
        this.config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        boolean localStorageExist = this.config.isLocalStorageExist();
        this.setLocalStorageExist(localStorageExist);
        if (!localStorageExist) {
            this.setCanUseLocalService(false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Local storage exists     ? " + this.isLocalStorageExist()));
            log.debug((Object)("can use local storage    ? " + this.isCanUseLocalService()));
            log.debug((Object)("can create local storage ? " + this.isCanCreateLocalService()));
            log.debug((Object)("can use remote   storage ? " + this.isCanUseRemoteService()));
        }
        this.setStoreRemoteConfig(this.config.isStoreRemoteStorage());
        this.setDumpFile(this.config.getBackupDirectory());
        this.setShowMigrationProgression(this.config.isShowMigrationProgression());
        this.setShowMigrationSql(this.config.isShowMigrationSql());
        this.setDoBackup(false);
        this.setPreviousService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("canMigrate ? " + this.isCanMigrate()));
        }
        CreationMode mode = this.config.getDefaultCreationMode();
        if (log.isDebugEnabled()) {
            log.debug((Object)"no service found, using default configuration ");
        }
        this.fromStorageConfig(this.config.toH2StorageConfig(this.pgConfig.getLabel()));
        this.fromStorageConfig(this.config.toPostgresStorageConfig(this.pgConfig.getLabel()));
        DbMode dbMode = this.config.getDefaultDbMode();
        if (this.getAdminAction() != null) {
            dbMode = DbMode.USE_REMOTE;
        } else if (this.isCanUseLocalService()) {
            mode = null;
        } else if (this.isCanCreateLocalService()) {
            mode = CreationMode.IMPORT_EXTERNAL_DUMP;
        } else if (this.isCanUseRemoteService()) {
            mode = CreationMode.IMPORT_REMOTE_STORAGE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use creationMode : " + mode));
        }
        this.setDbMode(dbMode);
        this.setCreationMode(mode);
    }

    protected void startCentralSourceModel() {
        if (!this.isNeedReferentielDataSource()) {
            return;
        }
        this.getCentralSourceModel().initFromModel();
        this.centralSourceModel.setCanCreateLocalService(false);
        this.centralSourceModel.setCanUseLocalService(false);
        this.centralSourceModel.setCanUseRemoteService(true);
        this.centralSourceModel.start(DbMode.USE_REMOTE);
        if (log.isDebugEnabled()) {
            this.centralSourceModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    Object oldValue = evt.getOldValue();
                    Object newValue = evt.getNewValue();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(evt.getSource() + " - Property [" + name + "] has changed from  " + oldValue + " to " + newValue));
                    }
                }
            });
        }
        this.centralSourceModel.testRemote();
    }

    public boolean isNeedReferentielDataSource() {
        return this.adminAction != null && this.adminAction == ObstunaAdminAction.CREATE;
    }

    public void start(DbMode dbMode) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use dbMode       : " + dbMode + " vs previous mode " + this.getDbMode()));
        }
        this.setDbMode(dbMode);
        this.startCentralSourceModel();
        this.start();
        this.firePropertyChange(DB_MODE_PROPERTY_NAME, this.getDbMode());
        this.firePropertyChange(CREATION_MODE_PROPERTY_NAME, this.getCreationMode());
        this.firePropertyChange(DUMP_FILE_PROPERTY_NAME, this.h2Config.getDbDump());
        this.firePropertyChange(BACKUP_FILE_PROPERTY_NAME, this.getBackupFile());
        this.firePropertyChange(DO_BACKUP_PROPERTY_NAME, this.isDoBackup());
        this.firePropertyChange(CAN_USE_LOCALE_SERVICE_PROPERTY_NAME, this.isCanUseLocalService());
        this.firePropertyChange(CAN_CREATE_LOCALE_SERVICE_PROPERTY_NAME, this.isCanCreateLocalService());
        this.firePropertyChange(CAN_USE_REMOTE_SERVICE_PROPERTY_NAME, this.isCanUseRemoteService());
        this.firePropertyChange(CONNEXION_STATUS_PROPERTY_NAME, this.pgConfig.getConnexionStatus());
        this.firePropertyChange(PREVIOUS_SERVICE_PROPERTY_NAME, this.getPreviousService());
        this.firePropertyChange(LOCAL_STORAGE_EXIST_PROPERTY_NAME, this.isLocalStorageExist());
        this.firePropertyChange(STORE_REMOTE_CONFIG_PROPERTY_NAME, this.isStoreRemoteConfig());
        this.firePropertyChange(REMOTE_URL_ROPERTY_NAME, this.getRemoteUrl());
        this.firePropertyChange(REMOTE_LOGIN_ROPERTY_NAME, this.getRemoteLogin());
        this.firePropertyChange(REMOTE_PASSWORD_PROPERTY_NAME, this.getRemotePassword());
        this.firePropertyChange(USE_SSL_PROPERTY_NAME, null, this.isUseSsl());
        this.firePropertyChange(SSL_CERTIFICAT_FILE_PROPERTY_NAME, this.getSslCertificatFile());
        this.firePropertyChange(SSL_CERTIFICAT_PASSWORD_PROPERTY_NAME, this.getSslCertificatPassword());
        this.firePropertyChange(CAN_MIGRATE_PROPERTY_NAME, this.isCanMigrate());
        this.firePropertyChange(SHOW_MIGRATION_SQL_PROPERTY_NAME, this.isShowMigrationSql());
        this.firePropertyChange(SHOW_MIGRATION_PROGRESSION_PROPERTY_NAME, this.isShowMigrationProgression());
    }

    public boolean isCanUseLocalService() {
        return this.canUseLocalService;
    }

    public boolean isCanCreateLocalService() {
        return this.canCreateLocalService;
    }

    public boolean isCanUseRemoteService() {
        return this.canUseRemoteService;
    }

    public SecurityModel getSecurityModel() {
        return this.securityModel;
    }

    public ObstunaAdminAction getAdminAction() {
        return this.adminAction;
    }

    public PGInstall getPgInstall() {
        return this.pgInstall;
    }

    public StorageUIModel getCentralSourceModel() {
        if (this.centralSourceModel == null) {
            this.centralSourceModel = new StorageUIModel(){

                @Override
                public String getLabel() {
                    String txt = I18n.n_((String)"observe.storage.label.import.referentiel");
                    String params = this.getDbMode() == DbMode.CREATE_LOCAL ? this.getH2Config().getDataDirectory().getAbsolutePath() : this.getRemoteUrl();
                    txt = I18n._((String)txt, (Object[])new Object[]{params});
                    return txt;
                }

                @Override
                public void validate() {
                    super.validate();
                    StorageUIModel.this.firePropertyChange(StorageUIModel.VALID_PROPERTY_NAME, this.isValid());
                }
            };
        }
        return this.centralSourceModel;
    }

    public void setAdminAction(ObstunaAdminAction adminAction) {
        this.adminAction = adminAction;
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        this.firePropertyChange(propertyName, null, newValue);
    }

    public void updateUniverse() {
        if (this.dbMode == null) {
            return;
        }
        ArrayList<StorageStep> universe = new ArrayList<StorageStep>();
        universe.add(StorageStep.CHOOSE_DB_MODE);
        this.h2Config.setImportConfig(null);
        boolean canBackup = this.localStorageExist;
        switch (this.dbMode) {
            case CREATE_LOCAL: {
                CreationMode creationMode = this.getCreationMode();
                if (creationMode == null) break;
                switch (creationMode) {
                    case IMPORT_EXTERNAL_DUMP: {
                        universe.add(StorageStep.CONFIG);
                        break;
                    }
                    case IMPORT_REMOTE_STORAGE: {
                        this.h2Config.setImportConfig((DataSourceConfig)this.pgConfig);
                        universe.add(StorageStep.CONFIG);
                    }
                }
                break;
            }
            case USE_REMOTE: {
                canBackup = false;
                universe.add(StorageStep.CONFIG);
                break;
            }
            case USE_LOCAL: {
                canBackup = false;
            }
        }
        if (canBackup) {
            universe.add(StorageStep.BACKUP);
        }
        if (this.adminAction != null) {
            if (this.adminAction == ObstunaAdminAction.CREATE) {
                universe.add(StorageStep.CONFIG_REFERENTIEL);
            }
            universe.add(StorageStep.ROLES);
        }
        universe.add(StorageStep.CONFIRM);
        if (this.excludeSteps != null) {
            universe.removeAll(this.excludeSteps);
        }
        this.setSteps(universe.toArray(new StorageStep[universe.size()]));
    }

    public boolean validate(StorageStep s) {
        boolean validate = super.validate((WizardStep)s);
        if (validate) {
            switch (s) {
                case CHOOSE_DB_MODE: {
                    boolean bl = validate = this.dbMode != null;
                    if (validate) {
                        if (!this.isCanUseRemoteService() && this.dbMode.equals((Object)DbMode.USE_REMOTE)) {
                            validate = false;
                        } else if (!this.isCanUseLocalService() && this.dbMode.equals((Object)DbMode.USE_LOCAL)) {
                            validate = false;
                        } else if (!this.isCanCreateLocalService() && this.dbMode.equals((Object)DbMode.CREATE_LOCAL)) {
                            validate = false;
                        }
                    }
                    if (!validate || !this.isLocal() || this.dbMode != DbMode.CREATE_LOCAL) break;
                    validate = this.h2Config.getCreationMode() != null;
                    break;
                }
                case CONFIG: {
                    if (this.dbMode == DbMode.USE_REMOTE) {
                        validate = this.pgConfig.isValid();
                        break;
                    }
                    validate = this.h2Config.isValid();
                    break;
                }
                case CONFIG_REFERENTIEL: {
                    validate = this.centralSourceModel.isValid();
                    break;
                }
                case BACKUP: {
                    validate = !this.doBackup || this.backupFile != null && !this.backupFile.exists() && this.backupFile.getName().endsWith(".sql.gz");
                    break;
                }
                case SELECT_DATA: {
                    validate = this.selectDataModel != null;
                    break;
                }
                case ROLES: {
                    Set role = this.getSecurityModel().getRole();
                    int assigned = this.getSecurityModel().getAssigned();
                    validate = role.size() == assigned;
                    break;
                }
                case CONFIRM: {
                    validate = true;
                }
            }
        }
        return validate;
    }

    public void validate() {
        super.validate();
        this.firePropertyChange(VALID_PROPERTY_NAME, this.isValid());
    }

    public boolean isValid() {
        boolean result = false;
        if (this.dbMode != null) {
            switch (this.dbMode) {
                case CREATE_LOCAL: {
                    result = this.getCreationMode() != null && this.validate(StorageStep.CONFIG);
                    break;
                }
                case USE_REMOTE: {
                    result = this.validate(StorageStep.CONFIG);
                    break;
                }
                case USE_LOCAL: {
                    result = this.h2Config.isValid() && this.h2Config.isStorageExists();
                }
            }
        }
        return result;
    }

    public boolean isUseSelectData() {
        return this.getSteps() != null && this.getSteps().contains((Object)StorageStep.SELECT_DATA);
    }

    public boolean isBackupAction() {
        return this.getSteps() != null && this.getStepIndex(StorageStep.BACKUP) == 0;
    }

    public boolean isLocal() {
        return this.dbMode != null && this.dbMode != DbMode.USE_REMOTE;
    }

    public boolean isRemote() {
        return this.dbMode != null && this.dbMode == DbMode.USE_REMOTE;
    }

    public boolean isCanMigrate() {
        boolean result = false;
        if (this.dbMode != null) {
            switch (this.dbMode) {
                case CREATE_LOCAL: 
                case USE_LOCAL: {
                    result = this.h2Config.isCanMigrate();
                    break;
                }
                case USE_REMOTE: {
                    result = this.pgConfig.isCanMigrate();
                }
            }
        }
        return result;
    }

    public String getLabel() {
        String txt = this.dbMode == DbMode.CREATE_LOCAL ? this.h2Config.getLabel() : this.pgConfig.getLabel();
        return txt;
    }

    public boolean isLocalStorageExist() {
        return this.localStorageExist;
    }

    public boolean isStoreRemoteConfig() {
        return this.storeRemoteConfig;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public boolean isDoBackup() {
        return this.doBackup;
    }

    public Version getDbVersion() {
        if (this.config == null) {
            return Version.VZERO;
        }
        return this.config.getDbVersion();
    }

    public DbMode getDbMode() {
        return this.dbMode;
    }

    public DataSource getPreviousService() {
        return this.previousService;
    }

    public ObserveConfig getConfig() {
        return this.config;
    }

    public void setDbMode(DbMode dbMode) {
        DbMode oldValue = this.dbMode;
        this.dbMode = dbMode;
        this.firePropertyChange(DB_MODE_PROPERTY_NAME, oldValue, dbMode);
        if (oldValue != dbMode) {
            this.updateUniverse();
        }
        this.validate();
        this.firePropertyChange(CAN_MIGRATE_PROPERTY_NAME, null, this.isCanMigrate());
    }

    public void setCanMigrate(boolean canMigrate) {
        if (this.dbMode != null) {
            switch (this.dbMode) {
                case CREATE_LOCAL: 
                case USE_LOCAL: {
                    this.h2Config.setCanMigrate(canMigrate);
                    break;
                }
                case USE_REMOTE: {
                    this.pgConfig.setCanMigrate(canMigrate);
                }
            }
        }
        this.firePropertyChange(CAN_MIGRATE_PROPERTY_NAME, null, canMigrate);
    }

    public void setLocalStorageExist(boolean localStorageExist) {
        boolean oldValue = this.localStorageExist;
        this.localStorageExist = localStorageExist;
        this.firePropertyChange(LOCAL_STORAGE_EXIST_PROPERTY_NAME, oldValue, localStorageExist);
        this.validate();
    }

    public void setStoreRemoteConfig(boolean storeRemoteConfig) {
        boolean oldValue = this.storeRemoteConfig;
        this.storeRemoteConfig = storeRemoteConfig;
        this.firePropertyChange(STORE_REMOTE_CONFIG_PROPERTY_NAME, oldValue, storeRemoteConfig);
    }

    public void setDoBackup(boolean doBackup) {
        boolean oldValue = this.doBackup;
        this.doBackup = doBackup;
        this.firePropertyChange(DO_BACKUP_PROPERTY_NAME, oldValue, doBackup);
    }

    public void setBackupFile(File backupFile) {
        File oldValue = this.backupFile;
        this.backupFile = backupFile;
        this.firePropertyChange(BACKUP_FILE_PROPERTY_NAME, oldValue, backupFile);
        this.validate();
    }

    public void setExcludeSteps(List<StorageStep> excludeSteps) {
        this.excludeSteps = excludeSteps;
    }

    public void destroy() {
        super.destroy();
    }

    public void setShowMigrationSql(boolean showMigrationSql) {
        boolean oldValue = this.pgConfig.isShowMigrationSql();
        this.pgConfig.setShowMigrationSql(showMigrationSql);
        this.h2Config.setShowMigrationSql(showMigrationSql);
        this.firePropertyChange(SHOW_MIGRATION_SQL_PROPERTY_NAME, oldValue, showMigrationSql);
    }

    public void setShowMigrationProgression(boolean showMigrationProgression) {
        boolean oldValue = this.pgConfig.isShowMigrationProgression();
        this.pgConfig.setShowMigrationProgression(showMigrationProgression);
        this.h2Config.setShowMigrationProgression(showMigrationProgression);
        this.firePropertyChange(SHOW_MIGRATION_PROGRESSION_PROPERTY_NAME, oldValue, showMigrationProgression);
    }

    public CreationMode getCreationMode() {
        CreationMode result = null;
        if (this.dbMode != null) {
            switch (this.dbMode) {
                case CREATE_LOCAL: 
                case USE_LOCAL: {
                    result = this.h2Config.getCreationMode();
                    break;
                }
                case USE_REMOTE: {
                    result = this.pgConfig.getCreationMode();
                }
            }
        }
        return result;
    }

    public File getDumpFile() {
        URL dbDump = this.h2Config.getDbDump();
        if (dbDump == null) {
            return new File("");
        }
        File file = new File(dbDump.getFile().replaceAll("%20", " "));
        file = new File(file.getAbsolutePath());
        return file;
    }

    public void setCreationMode(CreationMode creationMode) {
        String s;
        CreationMode oldValue = this.getCreationMode();
        this.pgConfig.setCreationMode(creationMode);
        this.h2Config.setCreationMode(creationMode);
        this.firePropertyChange(CREATION_MODE_PROPERTY_NAME, oldValue, creationMode);
        if (oldValue != creationMode) {
            this.updateUniverse();
        }
        if (creationMode == CreationMode.IMPORT_REMOTE_STORAGE && (s = this.getRemoteLogin()) != null && !LOGIN_REFERENTIEL.equals(s)) {
            this.setRemoteLogin(LOGIN_REFERENTIEL);
            this.setRemotePassword(EMPTY_PASSWORD);
        }
        this.validate();
    }

    public void setDumpFile(File dumpFile) {
        try {
            File oldValue = this.getDumpFile();
            URL url = null;
            if (dumpFile != null) {
                url = dumpFile.toURI().toURL();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("dumpFile : " + dumpFile + " (exist ? : " + dumpFile.exists() + ')'));
                    log.debug((Object)("dumpFile url : " + url));
                }
                String filePath = url.getFile().replaceAll("%20", " ");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("dumpFile file from url : " + filePath + " (exist ? : " + new File(filePath).exists() + ')'));
                }
            }
            this.h2Config.setDbDump(dumpFile == null ? null : url);
            this.firePropertyChange(DUMP_FILE_PROPERTY_NAME, oldValue, dumpFile);
            this.validate();
        }
        catch (MalformedURLException ex) {
            log.warn((Object)ex);
        }
    }

    public String getRemoteLogin() {
        return this.pgConfig.getLogin();
    }

    public char[] getRemotePassword() {
        return this.pgConfig.getPassword();
    }

    public String getRemoteUrl() {
        return this.pgConfig.getUrl();
    }

    public boolean isUseSsl() {
        return this.pgConfig.isUseSsl();
    }

    public File getSslCertificatFile() {
        return this.pgConfig.getSslCertificatFile();
    }

    public char[] getSslCertificatPassword() {
        return this.pgConfig.getSslCertificatPassword();
    }

    public ConnexionStatus getConnexionStatus() {
        return this.pgConfig.getConnexionStatus();
    }

    public void setPreviousService(DataSource previousService) {
        this.previousService = previousService;
    }

    public H2DataSourceConfig getH2Config() {
        return this.h2Config;
    }

    public PGDataSourceConfig getPgConfig() {
        return this.pgConfig;
    }

    public void setRemoteLogin(String remoteLogin) {
        String oldValue = this.getRemoteLogin();
        this.pgConfig.setLogin(remoteLogin);
        this.firePgConfigChanged(REMOTE_LOGIN_ROPERTY_NAME, oldValue, remoteLogin);
    }

    public void setRemotePassword(char[] remotePassword) {
        char[] oldValue = this.getRemotePassword();
        this.pgConfig.setPassword(remotePassword);
        this.firePgConfigChanged(REMOTE_PASSWORD_PROPERTY_NAME, oldValue, remotePassword);
    }

    public void setCanUseLocalService(boolean canUseLocalService) {
        this.canUseLocalService = canUseLocalService;
        this.firePgConfigChanged(CAN_USE_LOCALE_SERVICE_PROPERTY_NAME, null, canUseLocalService);
    }

    public void setCanCreateLocalService(boolean canCreateLocalService) {
        this.canCreateLocalService = canCreateLocalService;
        this.firePgConfigChanged(CAN_CREATE_LOCALE_SERVICE_PROPERTY_NAME, null, canCreateLocalService);
    }

    public void setCanUseRemoteService(boolean canUseRemoteService) {
        this.canUseRemoteService = canUseRemoteService;
        this.firePropertyChange(CAN_USE_REMOTE_SERVICE_PROPERTY_NAME, null, canUseRemoteService);
    }

    public void setRemoteUrl(String remoteUrl) {
        String oldValue = this.getRemoteUrl();
        this.pgConfig.setUrl(remoteUrl);
        this.firePgConfigChanged(REMOTE_URL_ROPERTY_NAME, oldValue, remoteUrl);
    }

    public void setUseSsl(boolean useSsl) {
        boolean oldValue = this.pgConfig.isUseSsl();
        this.pgConfig.setUseSsl(useSsl);
        this.firePgConfigChanged(USE_SSL_PROPERTY_NAME, oldValue, useSsl);
    }

    public void setSslCertificatFile(File sslCertificatFile) {
        File oldValue = this.getSslCertificatFile();
        this.pgConfig.setSslCertificatFile(sslCertificatFile);
        this.firePgConfigChanged(SSL_CERTIFICAT_FILE_PROPERTY_NAME, oldValue, sslCertificatFile);
    }

    public void setSslCertificatPassword(char[] password) {
        char[] oldValue = this.getRemotePassword();
        this.pgConfig.setSslCertificatPassword(password);
        this.firePgConfigChanged(SSL_CERTIFICAT_PASSWORD_PROPERTY_NAME, oldValue, password);
    }

    public void fromStorageConfig(H2DataSourceConfig config) {
        this.setDbMode(config.isStorageExists() ? DbMode.USE_LOCAL : DbMode.CREATE_LOCAL);
        config.copyTo((DataSourceConfig)this.h2Config);
    }

    public void fromStorageConfig(PGDataSourceConfig config) {
        this.setDbMode(DbMode.USE_REMOTE);
        config.copyTo((DataSourceConfig)this.pgConfig);
    }

    public H2DataSourceConfig toH2StorageConfig(String label) {
        H2DataSourceConfig result = this.h2Config.clone();
        result.setShortLabel(label);
        if (this.getDbMode() == DbMode.CREATE_LOCAL) {
            CreationMode m = result.getCreationMode();
            switch (m) {
                case IMPORT_EXTERNAL_DUMP: 
                case EMPTY: {
                    break;
                }
                case IMPORT_INTERNAL_DUMP: {
                    try {
                        result.setDbDump(this.config.getInitialDbDump().toURI().toURL());
                        break;
                    }
                    catch (MalformedURLException ex) {
                        throw new IllegalArgumentException("can not build url for initialDbDump for reason " + ex.getMessage(), ex);
                    }
                }
                case IMPORT_LOCAL_STORAGE: {
                    result.getH2ImportConfig().setShortLabel(I18n.n_((String)"observe.storage.label.import.local"));
                    break;
                }
                case IMPORT_REMOTE_STORAGE: {
                    result.getPGImportConfig().setShortLabel(I18n.n_((String)"observe.storage.label.import.remote"));
                }
            }
        }
        return result;
    }

    public PGDataSourceConfig toPostgresStorageConfig(String label) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("before clone pg : policy = " + this.pgConfig.getPolicy()));
        }
        PGDataSourceConfig result = this.pgConfig.clone();
        if (log.isDebugEnabled()) {
            log.debug((Object)("after clone pg : policy = " + result.getPolicy()));
        }
        result.setShortLabel(label);
        return result;
    }

    public DataSelectionModel getSelectDataModel() {
        return this.selectDataModel;
    }

    public void setSelectDataModel(DataSelectionModel selectDataModel) {
        this.selectDataModel = selectDataModel;
    }

    protected void copyTo(StorageUIModel dst) {
        dst.setLocalStorageExist(this.isLocalStorageExist());
        dst.setDbMode(this.getDbMode());
        dst.setBackupFile(this.getBackupFile());
        dst.setDoBackup(this.isDoBackup());
        dst.setStoreRemoteConfig(this.isStoreRemoteConfig());
        dst.setPreviousService(this.getPreviousService());
        dst.setCanCreateLocalService(this.isCanCreateLocalService());
        dst.setCanUseLocalService(this.isCanUseLocalService());
        dst.setCanUseRemoteService(this.isCanUseRemoteService());
        this.pgConfig.copyTo((DataSourceConfig)dst.pgConfig);
        this.h2Config.copyTo((DataSourceConfig)dst.h2Config);
        dst.setSelectDataModel(this.getSelectDataModel());
        dst.setSecurityModel(this.getSecurityModel());
        dst.setPgInstall(this.getPgInstall());
        dst.setAdminAction(this.getAdminAction());
    }

    public void firePgConfigChanged(String propertyName, Object oldValue, Object newValue) {
        if (!CONNEXION_STATUS_PROPERTY_NAME.equals(propertyName)) {
            this.firePropertyChange(propertyName, oldValue, newValue);
        }
        this.firePropertyChange(CONNEXION_STATUS_PROPERTY_NAME, this.pgConfig.getConnexionStatus());
        this.validate();
    }

    public boolean testRemote() {
        boolean result = this.getPgConfig().canConnect();
        if (log.isDebugEnabled()) {
            log.debug((Object)("result : " + result));
        }
        this.firePgConfigChanged(CONNEXION_STATUS_PROPERTY_NAME, null, this.pgConfig.getConnexionStatus());
        return result;
    }

    public void setSecurityModel(SecurityModel securityModel) {
        this.securityModel = securityModel;
    }

    public void setPgInstall(PGInstall pgInstall) {
        this.pgInstall = pgInstall;
    }

    public boolean isShowMigrationSql() {
        return this.pgConfig.isShowMigrationSql();
    }

    public boolean isShowMigrationProgression() {
        return this.pgConfig.isShowMigrationProgression();
    }

    public void setConnexionStatus(ConnexionStatus connexionStatus) {
        this.pgConfig.setConnexionStatus(connexionStatus);
        this.firePgConfigChanged(CONNEXION_STATUS_PROPERTY_NAME, null, connexionStatus);
    }
}

