/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.report.model.operations;

import fr.ird.observe.ui.admin.report.model.DataMatrix;
import fr.ird.observe.ui.admin.report.model.Report;
import fr.ird.observe.ui.admin.report.model.ReportOperation;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class SumColumn
extends ReportOperation {
    private static final Log log = LogFactory.getLog(SumColumn.class);
    private static final long serialVersionUID = 1L;
    private static final String OPERATION_NAME = "SumColumn";

    @Override
    public String getOperationName() {
        return OPERATION_NAME;
    }

    @Override
    public DataMatrix execute(TopiaContext tx, Report model, DataMatrix incoming) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launch " + this));
        }
        DataMatrix tmpMatrix = this.createTmpMatrix(model, incoming);
        int nbColumns = incoming.getWidth();
        for (int i = 0; i < nbColumns; ++i) {
            Object result = this.getColumnData(i, incoming);
            tmpMatrix.setValue(i, 0, result);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("operation [" + i + ",0] = " + result));
        }
        DataMatrix result = DataMatrix.merge(incoming, tmpMatrix);
        return result;
    }

    protected Object getColumnData(int column, DataMatrix incoming) {
        Double result = 0.0;
        int nbRows = incoming.getHeight();
        for (int row = 0; row < nbRows; ++row) {
            Double d;
            Serializable o = incoming.getValue(column, row);
            if (o == null || "null".equals(o)) {
                o = Integer.valueOf(0);
            }
            try {
                d = Double.valueOf(o.toString());
            }
            catch (NumberFormatException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Could not convert " + o + " to number"), (Throwable)e);
                }
                return "-";
            }
            result = result + d;
        }
        return result;
    }

    @Override
    protected Point computeLocation(Report model, DataMatrix incoming) {
        Point result = new Point(0, incoming.getHeight());
        return result;
    }

    @Override
    protected Dimension computeDimension(Report model, DataMatrix incoming) {
        Dimension result = new Dimension(incoming.getWidth(), 1);
        return result;
    }
}

