/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.open.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.referentiel.ActiviteBateau;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.open.ContentOpenableUIHandler;
import fr.ird.observe.ui.content.open.impl.ActiviteUI;
import fr.ird.observe.ui.content.open.impl.RouteUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderBuilder;

public class RouteUIHandler
extends ContentOpenableUIHandler<Route> {
    private static Log log = LogFactory.getLog(RouteUIHandler.class);

    public RouteUIHandler(RouteUI ui) {
        super(ui, DataContextType.Maree, DataContextType.Route, I18n.n_((String)"observe.message.route.not.open"));
    }

    @Override
    public RouteUI getUi() {
        return (RouteUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<Route> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Route.class, binderName);
        if (r == null) {
            BinderBuilder builder = new BinderBuilder(Route.class, new String[]{"jourObservation", "lochMatin", "lochSoir", "niveauVerification", "activite", "open", "commentaire"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"activite"});
            BinderBuilder builder2 = new BinderBuilder(Activite.class, new String[]{"quadrant", "latitude", "longitude", "heureObservation", "temperatureSurface", "causeNonCoupSenne", "activiteBateau", "ventBeaufort", "open"});
            TopiaEntityBinder binder = binderService.registerTopiaBinder(Activite.class, builder2, binderName);
            builder.addBinder("activite", (Binder)binder);
            r = binderService.registerTopiaBinder(Route.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String routeId = this.getSelectedId();
        if (routeId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Route.class)) {
            return ContentMode.UPDATE;
        }
        RouteUI ui = this.getUi();
        if (!dataContext.isSelectedOpen(Maree.class)) {
            RouteUIHandler.addMessage(ui, BeanValidatorScope.INFO, this.getEntityLabel(Maree.class), I18n._((String)"observe.message.maree.not.open"));
        } else {
            RouteUIHandler.addMessage(ui, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)this.closeMessage));
        }
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        boolean create;
        super.openUI();
        String mareeId = this.getSelectedParentId();
        String routeId = this.getSelectedId();
        log.info((Object)(this.prefix + "mareeId = " + mareeId));
        log.info((Object)(this.prefix + "routeId = " + routeId));
        ContentMode mode = this.computeContentMode();
        log.info((Object)(this.prefix + "content mode = " + (Object)((Object)mode)));
        DataService dataService = this.getDataService();
        Route editBean = (Route)this.getBean();
        boolean bl = create = routeId == null;
        if (create) {
            dataService.preCreate(this.getDataSource(), mareeId, (TopiaEntity)editBean, this.getLoadBinder(), this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(this.getDataSource(), routeId, this.getLoadExecutor());
            if (!editBean.isActiviteEmpty()) {
                DBHelper.sortActivites((List)editBean.getActivite());
            }
        }
        this.finalizeOpenUI(mode, create);
    }

    @Override
    protected Route onPreCreate(TopiaContext tx, Object parent, Route bean) throws TopiaException {
        Maree parentBean = (Maree)parent;
        Route lastRoute = parentBean.getLastRoute();
        if (lastRoute == null) {
            bean.setJourObservation(parentBean.getDateDebut());
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(lastRoute.getJourObservation());
            calendar.add(6, 1);
            Date date = DBHelper.getDay((Date)calendar.getTime());
            bean.setJourObservation(date);
            bean.setLochMatin(lastRoute.getLochSoir());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use jourObservation : " + bean.getJourObservation()));
            log.info((Object)("Will loch matin ast last loch soir : " + bean.getLochMatin()));
        }
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        boolean create = this.getModel().getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(this.getModel().getMode());
        RouteUI ui = this.getUi();
        ui.getValidator().setContextName(contextName);
        if (create) {
            RouteUIHandler.addMessage(ui, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.creating.route"));
        } else {
            RouteUIHandler.addMessage(ui, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.updating.route"));
        }
        super.startEditUI("jourObservation.date", "lochMatin.model", "lochSoir.model", "commentaire2.text", "close.enabled", "closeAndCreate.enabled");
        this.getModel().setModified(create);
    }

    @Override
    protected boolean doSave(Route bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Route> binder) throws Exception {
        String mareeId = this.getSelectedParentId();
        log.info((Object)("will save route " + bean.getTopiaId()));
        Date date = DBHelper.getDay((Date)bean.getJourObservation());
        bean.setJourObservation(date);
        bean.setOpen(true);
        if (bean.getTopiaId() == null) {
            dataService.create(dataSource, mareeId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, mareeId, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        this.obtainChildPosition(bean, dataService, dataSource);
        return true;
    }

    @Override
    protected Route onCreate(TopiaContext tx, Object parent, Route editBean) throws TopiaException {
        Maree parentBean = (Maree)parent;
        Route beanToSave = (Route)ObserveDAOHelper.getRouteDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addRoute(beanToSave);
        beanToSave.setJourObservation(editBean.getJourObservation());
        parentBean.updateDateFin();
        return beanToSave;
    }

    @Override
    protected Route onUpdate(TopiaContext tx, Object parent, Route beanToSave) throws TopiaException {
        Maree parentBean = (Maree)parent;
        Route editBean = (Route)this.getBean();
        Date oldDate = DBHelper.getDay((Date)beanToSave.getJourObservation());
        this.getLoadBinder().copyExcluding((Object)editBean, (Object)beanToSave, new String[]{"activite"});
        if (!oldDate.equals(editBean.getJourObservation())) {
            beanToSave.updateDates();
        }
        parentBean.updateDateFin();
        return beanToSave;
    }

    @Override
    protected boolean doDelete(Route bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, Route> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        String mareeId = this.getSelectedParentId();
        dataService.delete(dataSource, mareeId, (TopiaEntity)bean, deletor);
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, Route bean) {
        Maree parentBean = (Maree)parent;
        parentBean.removeRoute(bean);
        parentBean.updateDateFin();
    }

    @Override
    public boolean doCloseData() throws Exception {
        Route route = (Route)this.getBean();
        boolean mustAddFinVeille = !route.isActiviteFindDeVeilleFound();
        boolean createActiviteFinDeVeille = false;
        boolean closeActiviteFinDeVeille = false;
        boolean gotoActiviteFinDeVeille = false;
        ObserveTreeHelper treeHelper = RouteUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode routeNode = (ObserveNode)treeHelper.getSelectedNode();
        if (mustAddFinVeille) {
            int reponse = UIHelper.askUser((Component)((Object)this.getUi()), I18n._((String)"observe.title.need.confirm"), I18n._((String)"observe.message.need.fin.veille.activite"), 2, new Object[]{I18n._((String)"observe.choice.not.create.fin.veille.activite.and.continue"), I18n._((String)"observe.choice.create.fin.veille.activite.and.continue"), I18n._((String)"observe.choice.create.fin.veille.activite"), I18n._((String)"observe.choice.cancel")}, 0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("response : " + reponse));
            }
            switch (reponse) {
                case -1: 
                case 3: {
                    return false;
                }
                case 0: {
                    break;
                }
                case 1: {
                    createActiviteFinDeVeille = true;
                    closeActiviteFinDeVeille = true;
                    break;
                }
                case 2: {
                    createActiviteFinDeVeille = true;
                    gotoActiviteFinDeVeille = true;
                }
            }
        }
        if (createActiviteFinDeVeille) {
            this.stopEditUI();
            this.addActiviteFinDeVeille(closeActiviteFinDeVeille);
            if (gotoActiviteFinDeVeille) {
                return false;
            }
            treeHelper.selectNode((NavNode)routeNode);
        }
        super.doCloseData();
        return true;
    }

    protected ActiviteUI addActiviteFinDeVeille(boolean close) {
        ObserveTreeHelper treeHelper = RouteUIHandler.getTreeHelper((JAXXContext)this.getUi());
        ObserveNode parentNode = (ObserveNode)treeHelper.getSelectedNode();
        parentNode = (ObserveNode)treeHelper.findNode((NavNode)parentNode, new String[]{I18n.n_((String)"observe.common.activites")});
        if (log.isDebugEnabled()) {
            log.debug((Object)("PARENT NODE = " + (Object)((Object)parentNode)));
        }
        treeHelper.addUnsavedNode(parentNode, Activite.class);
        ActiviteUI selectedUI = (ActiviteUI)ObserveContext.get().getSelectedContentUI();
        ActiviteBateau activiteBateau = null;
        for (ActiviteBateau o : selectedUI.getActiviteBateau().getData()) {
            ActiviteBateau a = o;
            if (a.getCode() != 16) continue;
            activiteBateau = a;
            break;
        }
        selectedUI.getBean().setActiviteBateau(activiteBateau);
        if (close) {
            selectedUI.save(false);
            selectedUI.closeData();
            selectedUI.stopEdit();
        }
        return selectedUI;
    }

    @Override
    protected boolean obtainCanReopen(boolean create) {
        DataContext dataContext = this.getDataContext();
        boolean canReopen = !create && dataContext.isSelectedOpen(Maree.class) && !dataContext.isOpenRoute();
        return canReopen;
    }
}

