/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.consolidate;

import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveActionExecutor;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveRunner;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaptureFaune;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.TailleFaune;
import fr.ird.observe.entities.TaillePoidsComputable;
import fr.ird.observe.entities.TailleThon;
import fr.ird.observe.entities.referentiel.Espece;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.ParametrageTaillePoidsAble;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.entities.referentiel.TaillePoidsAble;
import fr.ird.observe.ui.admin.AdminActionWorker;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminTabUIHandler;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.AdminUIModel;
import fr.ird.observe.ui.admin.config.SelectDataUI;
import fr.ird.observe.ui.admin.consolidate.ConsolidateModel;
import fr.ird.observe.ui.admin.consolidate.ConsolidateUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.ext.WizardState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.persistence.util.TopiaEntityRef;
import org.nuiton.util.beans.BeanMonitor;

public class ConsolidateUIHandler
extends AdminTabUIHandler {
    private static final Log log = LogFactory.getLog(ConsolidateUIHandler.class);
    private static final String MESSAGE_FORMAT_3 = "[%1$s] %2$s calcul\u00e9 : %3$s (%4$s:%5$s, %6$s:%7$s)";
    protected final BeanMonitor tailleThonMonitor = new BeanMonitor(new String[]{"longueur", "longueurCalcule", "poids", "poidsCalcule"});
    protected final BeanMonitor tailleFauneMonitor = new BeanMonitor(new String[]{"longueur", "longueurCalcule", "poids", "poidsCalcule"});
    protected final BeanMonitor captureFauneMonitor = new BeanMonitor(new String[]{"longueur", "longueurCalcule", "poids", "poidsCalcule"});

    public ConsolidateUIHandler(AdminTabUI ui) {
        super(ui);
    }

    public ConsolidateModel getStepModel() {
        return this.model.getConsolidateModel();
    }

    public void initTabUI(AdminUI ui, ConsolidateUI tabUI) {
        super.initTabUI(ui, tabUI);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" specialized for [" + (Object)((Object)tabUI.getStep()) + "] for main ui " + ui.getClass().getName() + "@" + System.identityHashCode(ui)));
        }
        tabUI.getStartButton().setText(I18n._((String)"observe.action.synchro.launch.operation", (Object[])new Object[]{I18n._((String)tabUI.getStep().getOperationLabel())}));
        final SelectDataUI selectTabUI = (SelectDataUI)ui.getStepUI(AdminStep.SELECT_DATA);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AdminUIModel model = (AdminUIModel)((Object)evt.getSource());
                if (!model.containsStep((WizardStep)selectTabUI.getStep())) {
                    return;
                }
                DataSelectionModel value = (DataSelectionModel)evt.getNewValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("selection model changed to " + value));
                }
                ConsolidateUIHandler.this.updateSelectionModel(selectTabUI);
            }
        };
        tabUI.getModel().addPropertyChangeListener("selectionModelChanged", listener);
    }

    public void startAction() {
        ConsolidateUI tabUI = (ConsolidateUI)this.ui;
        ObserveActionExecutor executor = ObserveRunner.getActionExecutor();
        String actionLabel = tabUI.getStartButton().getToolTipText();
        AdminActionWorker worker = new AdminActionWorker(this, actionLabel){

            protected WizardState doInBackground() throws Exception {
                return ConsolidateUIHandler.this.doAction();
            }
        };
        executor.addAction(worker.getActionLabel(), (Runnable)((Object)worker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardState doAction() throws Exception {
        log.debug((Object)this);
        WizardState init = this.initDB();
        if (init != null) {
            return init;
        }
        Set mareeIds = this.model.getSelectionDataModel().getSelectedData();
        ArrayList<Maree> toUpdate = new ArrayList<Maree>(mareeIds.size());
        DataSource source = this.getStepModel().getSource();
        String txName = "consolidateData";
        TopiaContext tx = source.beginTransaction(txName);
        try {
            boolean needCommit;
            TopiaDAO dao = source.getDAO(tx, Maree.class);
            for (String mareeId : mareeIds) {
                Maree maree = (Maree)tx.findByTopiaId(mareeId);
                boolean needUpdate = this.consolidateMaree(tx, maree);
                if (!needUpdate) continue;
                dao.update((TopiaEntity)maree);
                toUpdate.add(maree);
            }
            boolean bl = needCommit = !toUpdate.isEmpty();
            if (needCommit) {
                this.sendMessage(I18n._((String)"observe.message.consolidate.save.changes", (Object[])new Object[]{toUpdate.size()}));
                source.commitTransaction(tx, txName);
            }
        }
        catch (Exception eee) {
            this.getStepModel().setError(eee);
            try {
                source.rollbackTransaction(tx, txName);
            }
            catch (DataSourceException e1) {
                log.error((Object)e1);
            }
            WizardState wizardState = WizardState.FAILED;
            return wizardState;
        }
        finally {
            this.tailleFauneMonitor.setBean(null);
            this.tailleThonMonitor.setBean(null);
            this.captureFauneMonitor.setBean(null);
            source.closeTransaction(tx, txName);
        }
        this.sendMessage(I18n._((String)"observe.message.consolidate.operation.done", (Object[])new Object[]{new Date()}));
        return WizardState.SUCCESSED;
    }

    protected boolean consolidateMaree(TopiaContext tx, Maree maree) throws Exception {
        ConsolidateModel stepModel = this.getStepModel();
        String mareeStr = stepModel.getMareeDecorator().toString((Object)maree);
        this.sendMessage(I18n._((String)"observe.message.consolidate.start.maree", (Object[])new Object[]{mareeStr}));
        String[] activiteIds = this.getActiviteIds(maree);
        if (activiteIds.length == 0) {
            this.sendMessage(I18n._((String)"observe.message.consolidate.no.activite.from.maree", (Object[])new Object[]{mareeStr}));
            return false;
        }
        SortedMap result = TopiaEntityHelper.detectReferences((TopiaEntityEnum[])ObserveDAOHelper.getContracts(), (String[])activiteIds, (TopiaEntity)maree);
        ArrayList<Activite> toUpdate = new ArrayList<Activite>(result.size());
        for (Map.Entry e : result.entrySet()) {
            Activite activite = (Activite)e.getKey();
            List refs = (List)e.getValue();
            TopiaEntityRef ref = (TopiaEntityRef)refs.get(0);
            TopiaEntity[] path = ref.getPath();
            Route route = (Route)path[path.length - 2];
            boolean needUpdate = this.consolidateActivite(tx, maree, route, activite);
            if (!needUpdate) continue;
            toUpdate.add(activite);
        }
        if (toUpdate.isEmpty()) {
            this.sendMessage(I18n._((String)"observe.message.consolidate.nothing.to.save.for.maree", (Object[])new Object[]{mareeStr}));
            return false;
        }
        this.sendMessage(I18n._((String)"observe.message.consolidate.maree.need.update", (Object[])new Object[]{this.getStepModel().getMareeDecorator().toString((Object)maree)}));
        return true;
    }

    protected boolean consolidateActivite(TopiaContext tx, Maree maree, Route route, Activite activite) throws Exception {
        this.sendMessage(I18n._((String)"observe.message.consolidate.start.activite", (Object[])new Object[]{this.getStepModel().getActiviteDecorator().toString((Object)activite)}));
        boolean needUpdate = false;
        Calee calee = activite.getCalee();
        Integer oldTypeBanc = calee.getTypeBanc();
        int newTypeBanc = activite.getTypeBanc();
        if (oldTypeBanc == null || oldTypeBanc != newTypeBanc) {
            needUpdate = true;
            calee.setTypeBanc(Integer.valueOf(newTypeBanc));
        }
        if (!calee.isEchantillonThonEmpty()) {
            for (EchantillonThon echantillonThon : calee.getEchantillonThon()) {
                if (echantillonThon.isTailleThonEmpty()) continue;
                for (TailleThon tailleThon : echantillonThon.getTailleThon()) {
                    this.tailleThonMonitor.setBean((Object)tailleThon);
                    this.updateTaillePoidsAble(tx, maree, route.getJourObservation(), (Espece)tailleThon.getEspece(), 0, (TaillePoidsComputable)tailleThon);
                    if (!this.tailleThonMonitor.wasModified()) continue;
                    needUpdate = true;
                }
            }
        }
        if (!calee.isEchantillonFauneEmpty()) {
            for (EchantillonFaune echantillonFaune : calee.getEchantillonFaune()) {
                if (echantillonFaune.isTailleFauneEmpty()) continue;
                for (TailleFaune tailleFaune : echantillonFaune.getTailleFaune()) {
                    this.tailleFauneMonitor.setBean((Object)tailleFaune);
                    this.updateTaillePoidsAble(tx, maree, route.getJourObservation(), (Espece)tailleFaune.getEspece(), tailleFaune.getSexe(), (TaillePoidsComputable)tailleFaune);
                    if (!this.tailleFauneMonitor.wasModified()) continue;
                    needUpdate = true;
                }
            }
        }
        if (!calee.isCaptureFauneEmpty()) {
            for (CaptureFaune captureFaune : calee.getCaptureFaune()) {
                this.captureFauneMonitor.setBean((Object)captureFaune);
                this.updateCaptureFaune(tx, maree, route.getJourObservation(), captureFaune);
                if (!this.captureFauneMonitor.wasModified()) continue;
                needUpdate = true;
            }
        }
        return needUpdate;
    }

    protected void updateCaptureFaune(TopiaContext tx, Maree maree, Date jour, CaptureFaune captureFaune) throws DataSourceException {
        this.updateTaillePoidsAble(tx, maree, jour, (Espece)captureFaune.getEspece(), 0, (TaillePoidsComputable)captureFaune);
        this.updateCaptureFaunePoidsEstimeNbEstimePoidsMoyen(captureFaune);
        this.updateTaillePoidsAble(tx, maree, jour, (Espece)captureFaune.getEspece(), 0, (TaillePoidsComputable)captureFaune);
    }

    protected void updateCaptureFaunePoidsEstimeNbEstimePoidsMoyen(CaptureFaune captureFaune) throws DataSourceException {
        String message;
        Float poidsMoyen = captureFaune.getPoidsMoyen();
        Float poidsEstime = captureFaune.getPoidsEstime();
        Integer nbEstime = captureFaune.getNombreEstime();
        boolean nbEstimeC = captureFaune.isNombreEstimeCalcule();
        boolean poidsEstimeC = captureFaune.isPoidsEstimeCalcule();
        boolean poidsMoyenC = captureFaune.isPoidsMoyenCalcule();
        String entityLabel = I18n._((String)this.getDecoratorService().getEntityLabel(CaptureFaune.class));
        if ((poidsEstime == null || poidsEstimeC) && nbEstime != null && poidsMoyen != null) {
            poidsEstime = Float.valueOf(poidsMoyen.floatValue() * (float)nbEstime.intValue() / 1000.0f);
            poidsEstimeC = true;
            captureFaune.setPoidsEstime(poidsEstime);
            captureFaune.setPoidsEstimeCalcule(poidsEstimeC);
            message = String.format(MESSAGE_FORMAT_3, entityLabel, I18n._((String)"observe.common.poidsEstime"), poidsEstime, I18n._((String)"observe.common.poidsMoyen"), poidsMoyen, I18n._((String)"observe.common.nombreEstime"), nbEstime);
            this.sendMessage(message);
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
        }
        if ((nbEstime == null || nbEstimeC) && poidsEstime != null && poidsMoyen != null) {
            nbEstime = (int)(1000.0f * poidsEstime.floatValue() / poidsMoyen.floatValue());
            nbEstimeC = true;
            captureFaune.setNombreEstime(nbEstime);
            captureFaune.setNombreEstimeCalcule(nbEstimeC);
            message = String.format(MESSAGE_FORMAT_3, entityLabel, I18n._((String)"observe.common.nombreEstime"), nbEstime, I18n._((String)"observe.common.poidsMoyen"), poidsMoyen, I18n._((String)"observe.common.poidsEstime"), poidsEstime);
            this.sendMessage(message);
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
        }
        if ((poidsMoyen == null || poidsMoyenC) && nbEstime != null && poidsEstime != null) {
            poidsMoyen = Float.valueOf(poidsEstime.floatValue() * 1000.0f / (float)nbEstime.intValue());
            captureFaune.setPoidsMoyen(poidsMoyen);
            captureFaune.setPoidsMoyenCalcule(true);
            message = String.format(MESSAGE_FORMAT_3, entityLabel, I18n._((String)"observe.common.poidsMoyen"), poidsMoyen, I18n._((String)"observe.common.nombreEstime"), nbEstime, I18n._((String)"observe.common.poidsEstime"), poidsEstime);
            this.sendMessage(message);
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
        }
    }

    protected void updateTaillePoidsAble(TopiaContext tx, Maree maree, Date jour, Espece espece, int sexe, TaillePoidsComputable e) throws DataSourceException {
        Ocean ocean = maree.getOcean();
        String entityLabel = this.getDecoratorService().getEntityLabel((TopiaEntity)e);
        Float poids = e.getPoids();
        boolean poidsC = e.isPoidsCalcule();
        boolean computePoids = false;
        boolean computeTaille = false;
        Float taille = e.getLongueur();
        boolean tailleC = e.isLongueurCalcule();
        if ((poids == null || poidsC) && taille != null) {
            computePoids = true;
        }
        if ((taille == null || tailleC) && poids != null) {
            computeTaille = true;
        }
        if (!computeTaille && !computePoids) {
            return;
        }
        ParametrageTaillePoidsAble parametrage = this.getDataService().findParametrageTaillePoids(tx, (TaillePoidsAble)espece, ocean, sexe, jour);
        if (parametrage == null) {
            String message = I18n._((String)"observe.message.consolidate.no.parametrage.found", (Object[])new Object[]{I18n._((String)entityLabel), this.getDecoratorService().decorate((Object)espece)});
            this.sendMessage(message);
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            return;
        }
        if (computeTaille) {
            Float newTaille = parametrage.computeTaille(poids.floatValue());
            if (newTaille != null) {
                String message = "[" + I18n._((String)entityLabel) + "] " + I18n._((String)"observe.message.consolidate.computed.taille", (Object[])new Object[]{newTaille, poids, parametrage.getRelationTaille(), parametrage.getCoefficients()});
                this.sendMessage(message);
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                e.setLongueur(newTaille);
                e.setLongueurCalcule(true);
                return;
            }
            return;
        }
        Float newPoids = parametrage.computePoids(taille.floatValue());
        if (newPoids != null) {
            String message = "[" + I18n._((String)entityLabel) + "] " + I18n._((String)"observe.message.consolidate.computed.poids", (Object[])new Object[]{newPoids, taille, parametrage.getRelationPoids(), parametrage.getCoefficients()});
            this.sendMessage(message);
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            e.setPoids(newPoids);
            e.setPoidsCalcule(true);
        }
    }

    protected String[] getActiviteIds(Maree maree) {
        ArrayList<String> tmpIds = new ArrayList<String>();
        if (!maree.isRouteEmpty()) {
            for (Route route : maree.getRoute()) {
                if (route.isActiviteEmpty()) continue;
                for (Activite activite : route.getActivite()) {
                    if (activite.getCalee() == null) continue;
                    tmpIds.add(activite.getTopiaId());
                }
            }
        }
        String[] result = tmpIds.toArray(new String[tmpIds.size()]);
        return result;
    }

    protected WizardState initDB() throws Exception {
        DataSource source = this.model.getSafeLocalSource(false);
        this.getStepModel().setSource(source);
        this.openSource(source);
        DecoratorService dProvider = this.getDecoratorService();
        ConsolidateModel stepModel = this.getStepModel();
        Decorator p = dProvider.getDecorator(Programme.class);
        Decorator m = dProvider.getDecorator(Maree.class);
        Decorator a = dProvider.getDecorator(Activite.class);
        Decorator c = dProvider.getDecorator(Calee.class);
        stepModel.setProgrammeDecorator((Decorator<Programme>)p);
        stepModel.setMareeDecorator((Decorator<Maree>)m);
        stepModel.setActiviteDecorator((Decorator<Activite>)a);
        stepModel.setCaleeDecorator((Decorator<Calee>)c);
        return null;
    }
}

