/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.referentiel.SystemeObserve;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.SystemeObserveUI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderBuilder;

public class SystemeObserveUIHandler
extends ContentUIHandler<Activite> {
    private static Log log = LogFactory.getLog(SystemeObserveUIHandler.class);

    public SystemeObserveUIHandler(SystemeObserveUI ui) {
        super(ui);
    }

    public SystemeObserveUI getUi() {
        return (SystemeObserveUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<Activite> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Activite.class, binderName);
        if (r == null) {
            BinderBuilder builder = new BinderBuilder(Activite.class, new String[]{"systemeObserve", "commentaire", "distanceSystemeObserve"});
            r = binderService.registerTopiaBinder(Activite.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        if (dataContext.isSelectedOpen(Activite.class)) {
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n._((String)"observe.message.activite.not.open"));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        DataContext dataContext = this.getDataContext();
        String activiteId = dataContext.getSelectedActiviteId();
        log.info((Object)("activiteId = " + activiteId));
        ContentMode mode = this.prepareContentMode();
        this.getDataService().loadEditEntity(this.getDataSource(), activiteId, this.getOpeningExecutor());
        this.getModel().setMode(mode);
        if (mode == ContentMode.UPDATE) {
            this.ui.startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        this.addInfoMessage(I18n._((String)"observe.message.updating.activite"));
        super.startEditUI(binding);
    }

    @Override
    protected boolean doSave(Activite bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Activite> binder) throws Exception {
        dataService.update(dataSource, (TopiaEntity)bean, binder, new String[0]);
        return true;
    }

    @Override
    protected void afterSave(boolean refresh) {
        this.getModel().setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSystemeObserve(Activite bean, Object[] selected) {
        boolean update;
        boolean bl = update = selected.length != bean.sizeSystemeObserve();
        if (!update && selected.length > 0) {
            List list = bean.getSystemeObserve();
            for (Object o : selected) {
                if (list.contains(o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            ListSelectionModel selectionModel = this.getUi().getSystemeObserve().getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                ArrayList<SystemeObserve> newList = new ArrayList<SystemeObserve>(selected.length);
                for (Object o : selected) {
                    newList.add((SystemeObserve)o);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update operations " + newList.size()));
                }
                bean.setSystemeObserve(newList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }
}

