/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.CaleeImpl;
import fr.ird.observe.entities.EchantillonFaune;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.StorageServiceException;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.CaleeUI;
import fr.ird.observe.ui.tree.ObserveTreeModelBuilder;
import java.util.Date;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class CaleeHandler
extends ObserveContentHandler<Activite, Calee, CaleeUI> {
    private static Log log = LogFactory.getLog(CaleeHandler.class);

    public CaleeHandler() {
        super(Activite.class, Calee.class, "commentaire", "nomSupply", "heureDebut", "heureFin", "heureFinCoulissage", "directionCourant", "vitesseCourant", "causeCoupNul", "epaisseurBanc", "profondeurMaximumEngin", "profondeurMoyenneBanc", "profondeurSommetBanc", "rejetThon", "rejetFaune", "utilisationSonar", "echantillonThon", "echantillonFaune");
    }

    @Override
    protected Calee onPreCreate(Activite parentBean, Calee bean) throws TopiaException {
        TopiaContext ctxt = bean.getTopiaContext();
        Date date = DBHelper.getCurrentHour((Date)parentBean.getHeureObservation());
        bean.setHeureDebut(date);
        bean.setHeureFin(date);
        bean.setHeureFinCoulissage(date);
        bean.addEchantillonThon((EchantillonThon)ObserveDAOHelper.getEchantillonThonDAO((TopiaContext)ctxt).create(new Object[0]));
        bean.addEchantillonFaune((EchantillonFaune)ObserveDAOHelper.getEchantillonFauneDAO((TopiaContext)ctxt).create(new Object[0]));
        return bean;
    }

    @Override
    protected Calee onCreate(Activite parentBean, Calee bean) throws TopiaException {
        TopiaContext ctxt = parentBean.getTopiaContext();
        Calee beanToSave = (Calee)ObserveDAOHelper.getCaleeDAO((TopiaContext)ctxt).create(new Object[0]);
        bean.setTopiaId(beanToSave.getTopiaId());
        parentBean.setCalee(beanToSave);
        return beanToSave;
    }

    @Override
    protected void onDelete(Activite parentBean, Calee bean) {
        try {
            parentBean.getCalee().delete();
            parentBean.setCalee(null);
        }
        catch (TopiaException e) {
            throw new IllegalStateException("Could not delete calee " + bean, e);
        }
    }

    @Override
    public void openUI(CaleeUI context) throws Exception {
        super.openUI(context);
        Activite activite = CaleeHandler.getData((JAXXContext)context, Activite.class);
        Calee bean = CaleeHandler.getData((JAXXContext)context, Calee.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        if (bean == null) {
            CaleeHandler.getStorageService((JAXXContext)context).preCreate((TopiaEntity)activite, (TopiaEntity)context.getEditBean(), this.loador, this.preCreator);
        } else {
            this.loador.load((Object)bean, (Object)context.getEditBean(), true, new String[0]);
        }
        context.setMode(mode);
        if (mode != ObserveContentMode.READ) {
            context.startEdit(bean);
        }
    }

    @Override
    protected ObserveContentMode getObserveContentMode(CaleeUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            boolean create;
            Activite activite = CaleeHandler.getData((JAXXContext)context, Activite.class);
            Calee bean = CaleeHandler.getData((JAXXContext)context, Calee.class);
            boolean bl = create = bean == null;
            if (create) {
                mode = ObserveContentMode.CREATE;
                context.removeContextValue(Calee.class);
            } else {
                mode = activite.isOpen() ? ObserveContentMode.UPDATE : ObserveContentMode.READ;
            }
            if (!create && !activite.isOpen()) {
                CaleeHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.activite.not.open"));
            }
        }
        return mode;
    }

    @Override
    public void startEditUI(CaleeUI context, Calee o, Calee editBean, String ... binding) {
        boolean create = context.getMode() == ObserveContentMode.CREATE;
        String contextName = this.getValidatorContextName(context.getMode());
        context.getValidator().setContextName(contextName);
        if (create) {
            CaleeHandler.addMessage(context, BeanValidatorScope.INFO, "calee", I18n._((String)"observe.message.creating.calee"));
        } else {
            CaleeHandler.addMessage(context, BeanValidatorScope.INFO, "calee", I18n._((String)"observe.message.updating.calee"));
        }
        super.startEditUI(context, o, editBean, "nomSupply.text", "commentaire2.text", "heureDebut.date", "heureFin.date", "heureFinCoulissage.date", "vitesseCourant.model", "directionCourant.model", "causeCoupNul.selectedItem", "utilisationSonar.selected", "vitesseCourant.model", "epaisseurBanc.model", "profondeurMaximumEngin.model", "profondeurMoyenneBanc.model", "profondeurSommetBanc.model");
        context.setModified(create);
    }

    @Override
    public void saveUI(CaleeUI context, boolean refresh) {
        Activite activite = CaleeHandler.getData((JAXXContext)context, Activite.class);
        CaleeImpl bean = context.getEditBean();
        boolean create = bean.getTopiaId() == null;
        try {
            StorageService<?> service = CaleeHandler.getStorageService((JAXXContext)context);
            if (create) {
                service.create((TopiaEntity)activite, (TopiaEntity)bean, this.loador, this.creator);
            } else {
                Calee beanToSave = CaleeHandler.getData((JAXXContext)context, Calee.class);
                service.update((TopiaEntity)beanToSave, (TopiaEntity)bean, this.loador);
            }
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        BeanValidatorUtil.setValidatorChanged((JAXXObject)context, (boolean)false, (String[])new String[0]);
        NavigationTreeNode node = CaleeHandler.getSelectedNode(context);
        if (create) {
            context.setMode(ObserveContentMode.UPDATE);
            ObserveTreeModelBuilder treeBuilder = CaleeHandler.getTreeBuilder((JAXXContext)context);
            NavigationTreeNode parentNode = (NavigationTreeNode)treeBuilder.removeChildNode((NavigationNode)node);
            node = treeBuilder.addCalee(parentNode, (Calee)bean);
            this.stopEditUI(context);
            CaleeHandler.selectNode((JAXXContext)context, node);
        } else {
            CaleeHandler.repaintNode((JAXXContext)context, node);
        }
    }

    @Override
    public void deleteUI(CaleeUI context) {
        Activite activite = CaleeHandler.getData((JAXXContext)context, Activite.class);
        CaleeImpl bean = context.getEditBean();
        if (!UIHelper.confirmForEntityDelete(context, Calee.class, bean)) {
            return;
        }
        try {
            CaleeHandler.getStorageService((JAXXContext)context).delete((TopiaEntity)activite, (TopiaEntity)bean, this.deletator);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        context.stopEdit();
        NavigationTreeNode node = CaleeHandler.getSelectedNode(context);
        NavigationTreeNode parentNode = (NavigationTreeNode)CaleeHandler.getTreeBuilder((JAXXContext)context).removeChildNode((NavigationNode)node);
        CaleeHandler.selectNode((JAXXContext)context, parentNode);
    }
}

