/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.referentiel.ActiviteBateau;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.StorageServiceException;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.ActiviteUI;
import fr.ird.observe.ui.content.data.ActivitesHandler;
import fr.ird.observe.ui.tree.ObserveTreeModelBuilder;
import java.util.Date;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationNode;
import jaxx.runtime.swing.navigation.tree.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public class ActiviteHandler
extends ObserveContentHandler<Route, Activite, ActiviteUI> {
    private static Log log = LogFactory.getLog(ActivitesHandler.class);

    public ActiviteHandler() {
        super(Route.class, Activite.class, "quadrant", "latitude", "longitude", "heureObservation", "temperatureSurface", "causeNonCoupSenne", "commentaire", "vitesseBateau", "systemeObserve", "distanceSystemeObserve", "activiteBateau", "activiteEnvironnante", "ventBeaufort", "modeDetection", "calee", "objetFlottant", "open", "latitudeAsDegre", "latitudeAsMinute", "latitudeAsSeconde", "longitudeAsDegre", "longitudeAsMinute", "longitudeAsSeconde", "useSexagecimalFormat");
    }

    @Override
    protected Activite onPreCreate(Route parentBean, Activite bean) throws TopiaException {
        Date d = DBHelper.getCurrentHour((Date)parentBean.getJourObservation());
        bean.setHeureObservation(d);
        return bean;
    }

    @Override
    protected Activite onCreate(Route parentBean, Activite bean) throws TopiaException {
        TopiaContext ctxt = parentBean.getTopiaContext();
        Activite beanToSave = (Activite)ObserveDAOHelper.getActiviteDAO((TopiaContext)ctxt).create(new Object[0]);
        bean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addActivite(beanToSave);
        return beanToSave;
    }

    @Override
    protected void onDelete(Route parentBean, Activite bean) {
        parentBean.removeActivite(bean);
    }

    @Override
    public void openOpenable(ActiviteUI ui) {
        ui.getEditBean().setOpen(true);
        try {
            Activite bean = ActiviteHandler.getData((JAXXContext)ui, Activite.class);
            ActiviteHandler.getStorageService((JAXXContext)ui).update((TopiaEntity)bean, (TopiaEntity)ui.getEditBean(), this.loador);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            return;
        }
        this.restartEditUI(ui);
    }

    @Override
    public void closeOpenable(ActiviteUI ui) {
        Activite bean;
        ui.getEditBean().setOpen(false);
        try {
            bean = ActiviteHandler.getData((JAXXContext)ui, Activite.class);
            bean = (Activite)ActiviteHandler.getStorageService((JAXXContext)ui).update((TopiaEntity)bean, (TopiaEntity)ui.getEditBean(), this.loador);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            return;
        }
        this.closeOpenable(ui, (Openable)bean, I18n._((String)"observe.message.activite.not.open"));
    }

    public void addObjetFlottant(ActiviteUI ui) {
        NavigationTreeNode parentNode = ActiviteHandler.getSelectedNode(ui);
        NavigationTreeNode node = ActiviteHandler.getTreeBuilder((JAXXContext)ui).addObjetFlottant(parentNode, null);
        ActiviteHandler.repaintNode((JAXXContext)ui, parentNode, true);
        ActiviteHandler.selectNode((JAXXContext)ui, node);
    }

    public void addCalee(ActiviteUI ui) {
        NavigationTreeNode parentNode = ActiviteHandler.getSelectedNode(ui);
        NavigationTreeNode node = ActiviteHandler.getTreeBuilder((JAXXContext)ui).addCalee(parentNode, null);
        ActiviteHandler.repaintNode((JAXXContext)ui, parentNode, true);
        ActiviteHandler.selectNode((JAXXContext)ui, node);
    }

    public String getActivite6Label(ActiviteUI ui) {
        try {
            List activites = ActiviteHandler.getStorageService((JAXXContext)ui).getList(ActiviteBateau.class);
            for (ActiviteBateau a : activites) {
                if (a.getCode() != 6) continue;
                Decorator d = this.getDecoratorService().getDecorator(ActiviteBateau.class);
                String label = d.toString((Object)a);
                return label;
            }
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        throw new IllegalStateException(I18n._((String)"observe.error.no.activite.6"));
    }

    @Override
    public void openUI(ActiviteUI context) throws Exception {
        boolean create;
        super.openUI(context);
        Route route = ActiviteHandler.getData((JAXXContext)context, Route.class);
        Activite bean = ActiviteHandler.getData((JAXXContext)context, Activite.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        context.getEditBean().setUseSexagecimalFormat(false);
        boolean bl = create = bean == null;
        if (create) {
            ActiviteHandler.getStorageService((JAXXContext)context).preCreate((TopiaEntity)route, (TopiaEntity)context.getEditBean(), this.loador, this.preCreator);
        } else {
            this.loador.load((Object)bean, (Object)context.getEditBean(), true, new String[0]);
        }
        context.setMode(null);
        context.setMode(mode);
        if (mode != ObserveContentMode.READ) {
            ActiviteHandler.getDataContext((JAXXContext)context).setEditingActivite(context.getEditBean());
            context.startEdit(bean);
        }
        context.getEditBean().setUseSexagecimalFormat(true);
        context.setModified(create);
    }

    @Override
    protected ObserveContentMode getObserveContentMode(ActiviteUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            boolean create;
            Maree maree = ActiviteHandler.getData((JAXXContext)context, Maree.class);
            Route route = ActiviteHandler.getData((JAXXContext)context, Route.class);
            Activite bean = ActiviteHandler.getData((JAXXContext)context, Activite.class);
            boolean bl = create = bean == null;
            if (create) {
                mode = ObserveContentMode.CREATE;
                context.removeContextValue(Activite.class);
            } else {
                mode = bean.isOpen() ? ObserveContentMode.UPDATE : ObserveContentMode.READ;
            }
            if (!create && !bean.isOpen()) {
                if (!route.isOpen()) {
                    ActiviteHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.route.not.open"));
                } else if (!maree.isOpen()) {
                    ActiviteHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Maree.class), I18n._((String)"observe.message.maree.not.open"));
                } else if (!bean.isOpen()) {
                    ActiviteHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.activite.not.open"));
                }
            }
        }
        return mode;
    }

    @Override
    public void saveUI(ActiviteUI context, boolean refresh) {
        Activite bean = context.getEditBean();
        boolean sexagecimalFormat = bean.isUseSexagecimalFormat();
        if (sexagecimalFormat) {
            bean.setUseSexagecimalFormat(false);
        }
        boolean create = bean.getTopiaId() == null;
        Route route = ActiviteHandler.getData((JAXXContext)context, Route.class);
        List oldActivites = route.getActivite();
        if (oldActivites != null && !oldActivites.isEmpty()) {
            DBHelper.sortActivites((List)oldActivites);
        }
        int position = 0;
        Date date = bean.getHeureObservation();
        if (oldActivites != null && !oldActivites.isEmpty()) {
            for (Activite a : oldActivites) {
                if (a.getTopiaId().equals(bean.getTopiaId())) continue;
                if (date.before(a.getHeureObservation())) break;
                ++position;
            }
        }
        try {
            StorageService<?> service = ActiviteHandler.getStorageService((JAXXContext)context);
            if (create) {
                bean.setOpen(true);
                service.create((TopiaEntity)route, (TopiaEntity)bean, this.loador, this.creator);
            } else {
                service.update((TopiaEntity)ActiviteHandler.getData((JAXXContext)context, Activite.class), (TopiaEntity)bean, this.loador);
            }
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        if (sexagecimalFormat) {
            bean.setUseSexagecimalFormat(true);
        }
        BeanValidatorUtil.setValidatorChanged((JAXXObject)context, (boolean)false, (String[])new String[0]);
        NavigationTreeNode node = ActiviteHandler.getSelectedNode(context);
        NavigationTreeNode parentNode = node.getParent();
        int oldPosition = create ? parentNode.getChildCount() : parentNode.getIndex(node);
        ObserveTreeModelBuilder modelBuilder = ActiviteHandler.getTreeBuilder((JAXXContext)context);
        if (create) {
            context.setMode(ObserveContentMode.UPDATE);
            modelBuilder.removeChildNode((NavigationNode)node);
            node = modelBuilder.addActivite(parentNode, bean);
            this.stopEditUI(context);
            if (oldPosition != position) {
                modelBuilder.moveNode((NavigationNode)parentNode, (NavigationNode)node, position);
            }
            ActiviteHandler.selectNode((JAXXContext)context, node);
        } else if (oldPosition != position) {
            modelBuilder.moveNode((NavigationNode)parentNode, (NavigationNode)node, position);
            ActiviteHandler.selectNode((JAXXContext)context, node);
        } else {
            ActiviteHandler.repaintNode((JAXXContext)context, node);
        }
    }

    @Override
    public void startEditUI(ActiviteUI context, Activite o, Activite editBean, String ... binding) {
        context.getQuadrantBG().clearSelection();
        boolean create = context.getMode() == ObserveContentMode.CREATE;
        String contextName = this.getValidatorContextName(context.getMode());
        context.getValidator().setContextName(contextName);
        if (create) {
            ActiviteHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.creating.activite"));
        } else {
            ActiviteHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.updating.activite"));
        }
        super.startEditUI(context, o, editBean, "heureObservation.date", "longitudeDecimal.model", "longitudeAsDegre.model", "longitudeAsMinute.model", "latitudeDecimal.model", "latitudeAsMinute.model", "latitudeAsDegre.model", "quadrant1.selected", "quadrant2.selected", "quadrant3.selected", "quadrant4.selected", "vitesseBateau.model", "temperatureSurface.model", "commentaire2.text", "activiteBateau.selectedItem", "activiteEnvironnante.selectedItem", "ventBeaufort.selectedItem");
        context.setModified(create);
    }

    @Override
    public void deleteUI(ActiviteUI context) {
        Route route = ActiviteHandler.getData((JAXXContext)context, Route.class);
        Activite bean = context.getEditBean();
        if (!UIHelper.confirmForEntityDelete(context, Activite.class, bean)) {
            return;
        }
        try {
            ActiviteHandler.getStorageService((JAXXContext)context).delete((TopiaEntity)route, (TopiaEntity)bean, this.deletator);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            return;
        }
        context.stopEdit();
        NavigationTreeNode node = ActiviteHandler.getSelectedNode(context);
        NavigationTreeNode parentNode = (NavigationTreeNode)ActiviteHandler.getTreeBuilder((JAXXContext)context).removeChildNode((NavigationNode)node);
        ActiviteHandler.selectNode((JAXXContext)context, parentNode);
    }
}

