/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content;

import fr.ird.observe.ui.content.ObserveContentTableModel;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import org.nuiton.util.ObjectUtil;

public class ObserveContentTableMeta<B>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected Class<B> klass;
    protected boolean unmodiableWhenExisting;
    protected transient PropertyDescriptor propertyDescriptor;

    public ObserveContentTableMeta(Class<B> klass, String name, boolean unmodiableWhenExisting) {
        this.name = name;
        this.klass = klass;
        this.unmodiableWhenExisting = unmodiableWhenExisting;
        if (ObserveContentTableModel.log.isDebugEnabled()) {
            ObserveContentTableModel.log.debug((Object)(this + " : " + name + " : " + this.getType().getName()));
        }
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.getPropertyDescriptor().getPropertyType();
    }

    public Object getValue(ObserveContentTableModel<?, ?> model, B bean, int row) {
        try {
            return this.getPropertyDescriptor().getReadMethod().invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean setValue(ObserveContentTableModel<?, ?> model, B bean, Object aValue, int row) {
        Object oldValue = this.getValue(model, bean, row);
        return oldValue == null && aValue != null || oldValue != null && !oldValue.equals(aValue);
    }

    public boolean isNullValue(ObserveContentTableModel<?, ?> model, B bean, int row) {
        Object value = this.getValue(model, bean, row);
        return ObjectUtil.isNullValue((Object)value);
    }

    protected PropertyDescriptor getPropertyDescriptor() {
        if (this.propertyDescriptor == null) {
            try {
                BeanInfo bInfo = Introspector.getBeanInfo(this.klass);
                for (PropertyDescriptor p : bInfo.getPropertyDescriptors()) {
                    if (!this.name.equals(p.getName())) continue;
                    this.propertyDescriptor = p;
                    break;
                }
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
            if (this.propertyDescriptor == null) {
                throw new IllegalArgumentException("could not find property " + this.name + " for bean " + this.klass);
            }
        }
        return this.propertyDescriptor;
    }
}

