/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.actions;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.StorageServiceException;
import fr.ird.observe.services.storage.impl.AbstractStorageService;
import fr.ird.observe.ui.admin.SynchroOperationAction;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import fr.ird.observe.ui.admin.actions.SaveLocalAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationState;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.DiffState;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.persistence.util.TopiaEntityRef;

public class SynchronizeReferentielAction
extends SynchroOperationAction {
    private static final Log log = LogFactory.getLog(SynchronizeReferentielAction.class);
    SortedMap<TopiaEntity, List<TopiaEntityRef>> obsoleteRefs;
    EnumMap<DiffState, List<String>> diff;

    public SynchronizeReferentielAction() {
        super(SynchroStep.SYNCHRONIZE_REFERENTIEL);
    }

    public SortedMap<TopiaEntity, List<TopiaEntityRef>> getObsoleteRefs() {
        return this.obsoleteRefs;
    }

    @Override
    protected void destroy() {
        if (this.obsoleteRefs != null) {
            this.obsoleteRefs.clear();
        }
        if (this.diff != null) {
            this.diff.clear();
        }
    }

    public void beforeAction(JAXXContext context, SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        if (model.getLocalService() == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"will create local service!!!");
            }
            StorageService<?> service = this.createLocalService(model.getLocalServiceModel(), model.getPreviousService());
            model.setLocalService(service);
            service.getConfig().setUseCache(false);
        }
        if (model.getReferentielService() == null) {
            model.setReferentielService(this.createReferentielService(model.getReferentielServiceModel()));
        }
        if (model.getSynchroService() == null) {
            model.setSynchroService(this.createSynchroService());
        }
    }

    public WizardOperationState doAction(SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        AbstractStorageService sourceService = (AbstractStorageService)model.getLocalService();
        AbstractStorageService referentielService = (AbstractStorageService)model.getReferentielService();
        AbstractStorageService tmpService = (AbstractStorageService)model.getSynchroService();
        this.openService((StorageService<?>)sourceService);
        this.openService((StorageService<?>)referentielService);
        this.openService((StorageService<?>)tmpService);
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        this.replicateReferentiel((StorageService<?>)referentielService, (StorageService<?>)tmpService);
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        this.diff = tmpService.buildReferentielDifferentiel((StorageService)sourceService);
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        this.detectObsoleteEntities(sourceService, tmpService);
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        log.debug((Object)"replicate user data to synchro");
        this.replicateData((StorageService<?>)sourceService, (StorageService<?>)tmpService, new String[0]);
        if (this.obsoleteRefs == null || this.obsoleteRefs.isEmpty()) {
            this.reportSuccess(model);
            return WizardOperationState.SUCCESSED;
        }
        if (this.isCancelled()) {
            return this.onCancel(model, (Exception)null);
        }
        SaveLocalAction saveAction = (SaveLocalAction)model.getOperationAction(SynchroStep.SAVE_LOCAL);
        saveAction.addStepForSave(model, SynchroStep.SYNCHRONIZE_REFERENTIEL);
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.needFix"));
        return WizardOperationState.NEED_FIX;
    }

    protected void reportSuccess(SynchroUIModel model) {
        boolean needSave = false;
        if (!this.isEmpty((Collection)this.diff.get(DiffState.REMOVED))) {
            needSave = true;
            this.sendMessage(I18n._((String)"observe.message.synchro.referentiel.was.removed"));
        }
        if (!this.isEmpty((Collection)this.diff.get(DiffState.NEW))) {
            needSave = true;
            this.sendMessage(I18n._((String)"observe.message.synchro.referentiel.was.added"));
        }
        if (!this.isEmpty((Collection)this.diff.get(DiffState.MODIFIED))) {
            needSave = true;
            this.sendMessage(I18n._((String)"observe.message.synchro.referentiel.was.modified"));
        }
        if (needSave) {
            SaveLocalAction saveAction = (SaveLocalAction)model.getOperationAction(SynchroStep.SAVE_LOCAL);
            saveAction.addStepForSave(model, SynchroStep.SYNCHRONIZE_REFERENTIEL);
            this.sendMessage(I18n._((String)"observe.message.synchro.local.modification"));
            this.sendMessage(I18n._((String)"observe.message.synchro.no.referentiel.conflict"));
        } else {
            this.sendMessage(I18n._((String)"observe.message.synchro.ref.is.updtodate"));
        }
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detectObsoleteRefs(AbstractStorageService<?> sourceService) throws Exception {
        List<String> removedList = this.diff.get(DiffState.REMOVED);
        TopiaContext sourceCtxt = sourceService.newCtxt();
        try {
            if (removedList != null) {
                List marees = ObserveDAOHelper.getMareeDAO((TopiaContext)sourceCtxt).findAll();
                String[] obsoleteEntities = removedList.toArray(new String[removedList.size()]);
                this.obsoleteRefs = TopiaEntityHelper.detectReferences((TopiaEntityEnum[])ObserveDAOHelper.getContracts(), (String[])obsoleteEntities, (Collection)marees);
            }
        }
        finally {
            sourceCtxt.closeContext();
        }
    }

    protected void detectObsoleteEntities(AbstractStorageService<?> sourceService, AbstractStorageService<?> tmpService) throws Exception {
        this.detectObsoleteRefs(sourceService);
        if (this.isCancelled()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        if (this.obsoleteRefs != null && !this.obsoleteRefs.isEmpty()) {
            this.replicateObsoletesEntities(sourceService, tmpService);
            if (this.isCancelled()) {
                return;
            }
            this.removeUndirectObsoleteRefs();
        }
    }

    protected void removeUndirectObsoleteRefs() {
        Iterator<Map.Entry<TopiaEntity, List<TopiaEntityRef>>> itr = this.obsoleteRefs.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<TopiaEntity, List<TopiaEntityRef>> entry = itr.next();
            Iterator<TopiaEntityRef> itrRef = entry.getValue().iterator();
            while (itrRef.hasNext()) {
                TopiaEntityRef ref = itrRef.next();
                TopiaEntity refInvoker = ref.getInvoker();
                if (refInvoker == null) {
                    itrRef.remove();
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("remove ref " + ref));
                    continue;
                }
                ObserveDAOHelper.ObserveEntityEnum refConstant = ObserveDAOHelper.ObserveEntityEnum.valueOf((TopiaEntity)refInvoker);
                if (DBHelper.DATA_ENTITIES_LIST.contains(refConstant)) continue;
                itrRef.remove();
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("remove ref " + ref));
            }
            if (!entry.getValue().isEmpty()) continue;
            itr.remove();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("remove obsolete entity (not direct referentiel) : " + entry.getKey().getTopiaId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replicateObsoletesEntities(AbstractStorageService<?> sourceService, AbstractStorageService<?> tmpService) throws Exception {
        ArrayList<TopiaEntity> obsoleteEntities = new ArrayList<TopiaEntity>(this.obsoleteRefs.keySet());
        TopiaContext sourceCtxt = sourceService.newCtxt();
        TopiaContext tmpCtxt = tmpService.newCtxt();
        try {
            for (ObserveDAOHelper.ObserveEntityEnum constant : DBHelper.REFERENTIEL_ENTITIES) {
                Class contractClass = constant.getContract();
                ArrayList<TopiaEntity> toReplicate = new ArrayList<TopiaEntity>();
                Iterator itr = obsoleteEntities.iterator();
                while (itr.hasNext()) {
                    TopiaEntity e = (TopiaEntity)itr.next();
                    if (!contractClass.isAssignableFrom(e.getClass())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("obsolete to inject : " + e.getTopiaId()));
                    }
                    itr.remove();
                    toReplicate.add(e);
                }
                if (toReplicate.isEmpty()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("no obsolete entity " + constant));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("inject obsolete entity " + constant + " (" + toReplicate.size() + ")"));
                }
                sourceCtxt.replicateEntities(tmpCtxt, toReplicate);
                tmpCtxt.commitTransaction();
            }
        }
        finally {
            try {
                tmpCtxt.closeContext();
            }
            finally {
                sourceCtxt.closeContext();
            }
        }
        if (!obsoleteEntities.isEmpty()) {
            throw new IllegalStateException("there is still obsolete entities to inject in synchro db : " + obsoleteEntities);
        }
    }

    public <E extends TopiaEntity> List<E> getEntityListFromSynchroDB(Class<E> entityClass, boolean removeObsoletes) {
        ArrayList list;
        try {
            list = this.getModel().getSynchroService().getList(entityClass);
        }
        catch (StorageServiceException ex) {
            log.error((Object)ex);
            list = new ArrayList();
        }
        if (removeObsoletes) {
            List<String> removedList = this.diff.get(DiffState.REMOVED);
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                TopiaEntity e = (TopiaEntity)itr.next();
                if (!removedList.contains(e.getTopiaId())) continue;
                itr.remove();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolvObsoleteReferences(TopiaEntity obsoleteRef, List<TopiaEntityRef> refs, TopiaEntity safeRef) {
        List globalRefs = (List)this.obsoleteRefs.get(obsoleteRef);
        AbstractStorageService service = (AbstractStorageService)this.getModel().getSynchroService();
        TopiaContext ctxt = null;
        try {
            ctxt = service.newCtxt();
            obsoleteRef = ctxt.findByTopiaId(obsoleteRef.getTopiaId());
            log.debug((Object)("resolve obsolete property " + obsoleteRef.getTopiaId()));
            safeRef = ctxt.findByTopiaId(safeRef.getTopiaId());
            for (TopiaEntityRef ref : refs) {
                TopiaEntity invoker = ref.getInvoker();
                if (invoker == null) {
                    throw new NullPointerException("can not have a null invoker in " + ref);
                }
                invoker = ctxt.findByTopiaId(invoker.getTopiaId());
                JXPathContext jxcontext = JXPathContext.newContext((Object)invoker);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property to switch " + ref.getInvokerProperty() + " old        : " + jxcontext.getValue(ref.getInvokerProperty())));
                }
                jxcontext.setValue(ref.getInvokerProperty(), (Object)safeRef);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property to switch " + ref.getInvokerProperty() + " new        : " + safeRef));
                    log.debug((Object)("property to switch " + ref.getInvokerProperty() + " new Check  : " + jxcontext.getValue(ref.getInvokerProperty())));
                }
                invoker.update();
                ctxt.commitTransaction();
                globalRefs.remove(ref);
                this.firePropertyChange("refsResolved", null, obsoleteRef);
            }
            if (globalRefs.isEmpty()) {
                this.obsoleteRefs.remove(obsoleteRef);
                log.debug((Object)("remove resolved obsolete property from temp db : " + obsoleteRef.getTopiaId()));
                obsoleteRef.delete();
                ctxt.commitTransaction();
                this.firePropertyChange("obsoleteResolved", null, obsoleteRef);
            }
            if (this.obsoleteRefs.isEmpty()) {
                this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
                this.getModel().setOperationState(WizardOperationState.SUCCESSED);
            }
        }
        catch (Exception e) {
            this.getModel().setOperationState(this.onError(this.getModel(), e));
        }
        finally {
            try {
                if (ctxt != null) {
                    ctxt.closeContext();
                }
            }
            catch (TopiaException e) {
                this.getModel().setOperationState(this.onError(this.getModel(), (Exception)((Object)e)));
            }
        }
    }

    protected boolean isEmpty(Collection<?> col) {
        return col == null || col.isEmpty();
    }
}

