/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin.actions;

import fr.ird.observe.ObserveBinderHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.MareeDAO;
import fr.ird.observe.services.storage.StorageService;
import fr.ird.observe.services.storage.impl.AbstractStorageService;
import fr.ird.observe.ui.admin.SynchroOperationAction;
import fr.ird.observe.ui.admin.SynchroStep;
import fr.ird.observe.ui.admin.SynchroUIModel;
import fr.ird.observe.ui.admin.actions.SynchronizeReferentielAction;
import java.io.File;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.DiffState;

public class SaveLocalAction
extends SynchroOperationAction {
    private static final Log log = LogFactory.getLog(SaveLocalAction.class);
    protected Set<SynchroStep> stepsForSave = new HashSet<SynchroStep>();

    public SaveLocalAction() {
        super(SynchroStep.SAVE_LOCAL);
    }

    public void addStepForSave(SynchroUIModel model, SynchroStep step) {
        this.stepsForSave.add(step);
        model.setLocalServiceNeedSave(true);
    }

    public boolean containsStepForsave(SynchroStep step) {
        return this.stepsForSave.contains((Object)step);
    }

    public void beforeAction(JAXXContext context, SynchroUIModel model) throws Exception {
        log.debug((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizardOperationState doAction(SynchroUIModel model) throws Exception {
        log.debug((Object)this);
        if (!model.isLocalServiceNeedSave()) {
            this.sendMessage("Aucune modification sur la base locale, op\u00e9ration non requise.");
            return WizardOperationState.SUCCESSED;
        }
        AbstractStorageService localService = (AbstractStorageService)model.getLocalService();
        AbstractStorageService synchroService = (AbstractStorageService)model.getSynchroService();
        if (!localService.containsStorageServiceListener(this.serviceLogger)) {
            localService.addStorageServiceListener(this.serviceLogger);
        }
        if (!synchroService.containsStorageServiceListener(this.serviceLogger)) {
            synchroService.addStorageServiceListener(this.serviceLogger);
        }
        try {
            if (model.isDoBackup()) {
                this.sendMessage("Sauvegarde de la base locale vers " + model.getBackupFile());
                File backupFile = model.getBackupFile();
                localService.storeDB(backupFile);
            }
            this.deleteData(localService);
            if (this.containsStepForsave(SynchroStep.SYNCHRONIZE_REFERENTIEL)) {
                this.sendMessage("Sauvegarde du r\u00e9f\u00e9rentiel.");
                SynchronizeReferentielAction action = (SynchronizeReferentielAction)model.getOperationAction(SynchroStep.SYNCHRONIZE_REFERENTIEL);
                this.saveReferentiel(action, model);
            }
            this.sendMessage("Sauvegarde des donn\u00e9es observateurs.");
            this.replicateData((StorageService<?>)synchroService, (StorageService<?>)localService, new String[0]);
        }
        finally {
            synchroService.removeStorageServiceListener(this.serviceLogger);
            localService.removeStorageServiceListener(this.serviceLogger);
        }
        this.sendMessage(I18n._((String)"observe.message.synchro.operation.done", (Object[])new Object[]{new Date()}));
        return WizardOperationState.SUCCESSED;
    }

    protected void saveReferentiel(SynchronizeReferentielAction action, SynchroUIModel model) throws Exception {
        EnumMap<DiffState, List<String>> diff = action.diff;
        AbstractStorageService localService = (AbstractStorageService)model.getLocalService();
        AbstractStorageService tmpService = (AbstractStorageService)model.getSynchroService();
        TopiaContext sourceCtxt = localService.newCtxt();
        TopiaContext tmpCtxt = tmpService.newCtxt();
        try {
            TopiaEntity entity;
            List<String> ids = diff.get(DiffState.REMOVED);
            if (ids != null) {
                for (String id : ids) {
                    this.sendMessage("suppression de l'objet " + id + " de la base locale");
                    entity = sourceCtxt.findByTopiaId(id);
                    entity.delete();
                }
            }
            if ((ids = diff.get(DiffState.NEW)) != null) {
                for (String id : ids) {
                    entity = tmpCtxt.findByTopiaId(id);
                    this.sendMessage("ajout de l'objet " + id + " dans la base locale");
                    tmpCtxt.replicateEntity(sourceCtxt, entity);
                }
            }
            if ((ids = diff.get(DiffState.MODIFIED)) != null && !ids.isEmpty()) {
                for (String id : ids) {
                    entity = tmpCtxt.findByTopiaId(id);
                    this.copyEntity(sourceCtxt, entity);
                }
            }
            sourceCtxt.commitTransaction();
        }
        catch (Exception e) {
            sourceCtxt.rollbackTransaction();
            throw e;
        }
        finally {
            sourceCtxt.closeContext();
            tmpCtxt.rollbackTransaction();
            tmpCtxt.closeContext();
        }
    }

    protected <E extends TopiaEntity> void copyEntity(TopiaContext sourceCtxt, E entity) throws TopiaException {
        this.sendMessage("mise \u00e0 jour de l'objet " + entity.getTopiaId() + " dans la base locale");
        TopiaDAO dao = ObserveDAOHelper.getDAO((TopiaContext)sourceCtxt, entity);
        TopiaEntity entity2 = dao.findByTopiaId(entity.getTopiaId());
        ObserveBinderHelper.simpleCopy(entity, (TopiaEntity)entity2, (boolean)false);
        entity2.setTopiaVersion(entity.getTopiaVersion() - 1L);
        dao.update(entity2);
    }

    protected void deleteData(AbstractStorageService<?> service) throws Exception {
        TopiaContext sourceCtxt = service.newCtxt();
        try {
            MareeDAO mareeDAO = ObserveDAOHelper.getMareeDAO((TopiaContext)sourceCtxt);
            List toDelete = mareeDAO.findAll();
            if (toDelete != null && !toDelete.isEmpty()) {
                for (Maree maree : toDelete) {
                    this.sendMessage("Suppresion de la maree " + maree.getTopiaId());
                    mareeDAO.delete(maree);
                }
            }
            sourceCtxt.commitTransaction();
        }
        catch (TopiaException e) {
            sourceCtxt.rollbackTransaction();
            throw e;
        }
        finally {
            sourceCtxt.closeContext();
        }
    }

    @Override
    public void destroy() {
        this.stepsForSave.clear();
    }
}

