/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.entities.Maree;
import fr.ird.observe.entities.referentiel.Programme;
import fr.ird.observe.entities.referentiel.ProgrammeImpl;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.ProgrammeUI;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ProgrammeHandler
extends ObserveContentHandler<Void, Programme, ProgrammeUI> {
    private static final Log log = LogFactory.getLog(ProgrammeHandler.class);

    public ProgrammeHandler() {
        super(Void.class, Programme.class, "maree");
    }

    public void addMaree(ProgrammeUI context) {
        NavigationTreeNode parentNode = ProgrammeHandler.getSelectedNode(context);
        NavigationTreeNode node = ProgrammeHandler.getTreeBuilder((JAXXContext)context).addMaree(parentNode, null);
        ProgrammeHandler.repaintNode((JAXXContext)context, parentNode, true);
        ProgrammeHandler.selectNode((JAXXContext)context, node);
    }

    public void gotoMaree(ProgrammeUI context, Maree selectedMaree) {
        if (selectedMaree == null) {
            return;
        }
        NavigationTreeNode parentNode = ProgrammeHandler.getSelectedNode(context);
        NavigationTreeNode node = parentNode.getChild(selectedMaree.getTopiaId());
        ProgrammeHandler.selectNode((JAXXContext)context, node);
    }

    @Override
    public void openUI(ProgrammeUI context) throws Exception {
        super.openUI(context);
        Programme programme = ProgrammeHandler.getData((JAXXContext)context, Programme.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        ProgrammeImpl editBean = context.getEditBean();
        this.loador.load((Object)programme, (Object)editBean, true, new String[0]);
        List marees = editBean.getMaree();
        if (marees != null) {
            editBean.setMaree(new ArrayList(marees));
        }
        context.setMode(mode);
        Decorator<Programme> decorator = ObserveContext.getDecorator(Programme.class);
        context.setContentTitle(decorator.toString((Object)programme));
    }

    @Override
    protected ObserveContentMode getObserveContentMode(ProgrammeUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        Programme programme = ProgrammeHandler.getData((JAXXContext)context, Programme.class);
        Maree openMaree = ProgrammeHandler.getDataContext((JAXXContext)context).getOpenMaree();
        if (mode == null) {
            if (openMaree == null) {
                mode = ObserveContentMode.CREATE;
                ProgrammeHandler.addMessage(context, BeanValidatorScope.INFO, ProgrammeHandler.getEntityLabel(Programme.class), I18n._((String)"observe.message.no.active.maree.found"));
            } else if (programme.getOpenChild() != null) {
                mode = ObserveContentMode.UPDATE;
                ProgrammeHandler.addMessage(context, BeanValidatorScope.INFO, ProgrammeHandler.getEntityLabel(Programme.class), I18n._((String)"observe.message.active.maree.found"));
            } else {
                mode = ObserveContentMode.READ;
                ProgrammeHandler.addMessage(context, BeanValidatorScope.INFO, ProgrammeHandler.getEntityLabel(Programme.class), I18n._((String)"observe.message.active.maree.found.for.other.programme"));
            }
        }
        return mode;
    }
}

