/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.BaliseLue;
import fr.ird.observe.entities.BaliseLueImpl;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.entities.ObjetFlottantImpl;
import fr.ird.observe.entities.TypeOperationBaliseEnum;
import fr.ird.observe.entities.referentiel.OperationBalise;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.OperationBaliseUI;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityListUpdator;
import org.nuiton.topia.persistence.util.Loador;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderBuilder;

public class OperationBaliseHandler
extends ObserveContentHandler<Void, ObjetFlottant, OperationBaliseUI> {
    private static Log log = LogFactory.getLog(OperationBaliseHandler.class);
    protected Loador<BaliseLue> childLoador;
    protected EntityListUpdator<ObjetFlottant, BaliseLue> childsUpdator;

    public OperationBaliseHandler() {
        super(Void.class, ObjetFlottant.class, "commentaire");
        TopiaEntityBinder<BaliseLue> binder = this.getBinder(BaliseLue.class);
        if (binder == null) {
            BinderBuilder builder = new BinderBuilder(BaliseLue.class, new String[]{"code", "typeBalise", "operationBalise"});
            binder = this.registerBinder(BaliseLue.class, builder);
            binder.setEmpty((TopiaEntity)new BaliseLueImpl());
        }
        this.childLoador = binder;
        this.childsUpdator = EntityListUpdator.newEntityListUpdator(ObjetFlottant.class, BaliseLue.class, (String)"baliseLue");
    }

    @Override
    public void openUI(OperationBaliseUI context) throws Exception {
        super.openUI(context);
        ObserveContentMode mode = this.getObserveContentMode(context);
        ObjetFlottant bean = context.getContextValue(ObjetFlottant.class);
        this.loador.load((Object)bean, (Object)context.getEditBean(), true, new String[0]);
        context.getEditBean().setBaliseLue(this.dumpBaliseList(bean.getBaliseLue()));
        context.processDataBinding("typeOperation.selectedIndex");
        TypeOperationBaliseEnum typeOperation = (TypeOperationBaliseEnum)context.getTypeOperation().getSelectedItem();
        this.changeTypeOperation(context, typeOperation, false);
        context.setMode(mode);
        if (mode == ObserveContentMode.UPDATE) {
            context.startEdit(bean);
        }
    }

    @Override
    protected ObserveContentMode getObserveContentMode(OperationBaliseUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            Activite activite = OperationBaliseHandler.getData((JAXXContext)context, Activite.class);
            if (activite.isOpen()) {
                mode = ObserveContentMode.UPDATE;
            } else {
                mode = ObserveContentMode.READ;
                OperationBaliseHandler.addMessage(context, BeanValidatorScope.INFO, OperationBaliseHandler.getEntityLabel(Activite.class), I18n._((String)"observe.message.activite.not.open"));
            }
        }
        return mode;
    }

    @Override
    public void startEditUI(OperationBaliseUI context, ObjetFlottant o, ObjetFlottant editBean, String ... binding) {
        super.startEditUI(context, o, editBean, new String[0]);
        OperationBaliseHandler.addMessage(context, BeanValidatorScope.INFO, OperationBaliseHandler.getEntityLabel(ObjetFlottant.class), I18n._((String)"observe.message.updating.objetFlottant"));
        List balises = editBean.getBaliseLue();
        if (balises != null && !balises.isEmpty()) {
            context.getValidatorBalise1().setBean((Object)context.getBaliseLue1());
            if (balises.size() == 2) {
                context.getValidatorBalise2().setBean((Object)context.getBaliseLue2());
            }
        }
        context.setModified(false);
    }

    @Override
    public void saveUI(OperationBaliseUI context, boolean refresh) {
        ObjetFlottant toSave = context.getContextValue(ObjetFlottant.class);
        ObjetFlottantImpl editBean = context.getEditBean();
        List<BaliseLue> objets = this.dumpBaliseList(editBean.getBaliseLue());
        if (editBean.getBaliseLue() != null) {
            editBean.getBaliseLue().clear();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("nb balise to save : " + (objets == null ? 0 : objets.size())));
            if (objets != null) {
                for (BaliseLue b : objets) {
                    log.debug((Object)("balise to save : " + b.getTopiaId() + " : " + b.getCode()));
                }
            }
        }
        try {
            OperationBaliseHandler.getStorageService((JAXXContext)context).updateList((TopiaEntity)toSave, (TopiaEntity)editBean, BaliseLue.class, objets, this.loador, this.childLoador, this.childsUpdator);
            this.resetEditUI(context);
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
        }
    }

    protected void changeTypeOperation(OperationBaliseUI ui, TypeOperationBaliseEnum typeOperationBalise, boolean reset) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(typeOperationBalise + " doReset ? " + reset));
        }
        int nbBalises = typeOperationBalise.getNbBalises();
        ObjetFlottantImpl editBean = ui.getEditBean();
        ArrayList<BaliseLue> objets = new ArrayList<BaliseLue>();
        if (!reset && editBean.getBaliseLue() != null) {
            objets.addAll(editBean.getBaliseLue());
        }
        if (editBean.getBaliseLue() != null) {
            editBean.getBaliseLue().clear();
        }
        JPanel editorPanel = ui.getBaliseLues();
        editorPanel.removeAll();
        int[] codeOperations = typeOperationBalise.getCodeOperation();
        List operations = ui.getOperationBalise1().getData();
        switch (nbBalises) {
            case 0: {
                editorPanel.setLayout(new GridLayout());
                editorPanel.add(ui.getNoBaliseEditor());
                if (!ui.isEditing().booleanValue()) break;
                ui.getValidatorBalise1().setBean(null);
                ui.getValidatorBalise2().setBean(null);
                break;
            }
            case 1: {
                this.bindEditBalise((ObjetFlottant)editBean, (BaliseLue)ui.getBaliseLue1(), codeOperations[0], operations, objets, reset);
                editorPanel.setLayout(new GridLayout(1, 0));
                editorPanel.add((Component)ui.getBaliseLue1Editor());
                if (!ui.isEditing().booleanValue()) break;
                ui.getValidatorBalise1().setBean((Object)ui.getBaliseLue1());
                ui.getValidatorBalise2().setBean(null);
                break;
            }
            case 2: {
                this.bindEditBalise((ObjetFlottant)editBean, (BaliseLue)ui.getBaliseLue1(), codeOperations[0], operations, objets, reset);
                this.bindEditBalise((ObjetFlottant)editBean, (BaliseLue)ui.getBaliseLue2(), codeOperations[1], operations, objets, reset);
                editorPanel.setLayout(new GridLayout(2, 0));
                editorPanel.add((Component)ui.getBaliseLue1Editor());
                editorPanel.add((Component)ui.getBaliseLue2Editor());
                if (!ui.isEditing().booleanValue()) break;
                ui.getValidatorBalise1().setBean((Object)ui.getBaliseLue1());
                ui.getValidatorBalise2().setBean((Object)ui.getBaliseLue2());
            }
        }
        ui.revalidate();
    }

    protected void bindEditBalise(ObjetFlottant editBean, BaliseLue baliseEditBean, int codeOperation, List<?> operations, List<BaliseLue> objets, boolean reset) {
        if (reset) {
            OperationBalise operation = null;
            for (Object o : operations) {
                OperationBalise op = (OperationBalise)o;
                if (codeOperation != op.getCode()) continue;
                operation = op;
                break;
            }
            if (operation == null) {
                throw new IllegalArgumentException("could not find a " + OperationBalise.class + " with code " + codeOperation);
            }
            baliseEditBean.setOperationBalise(operation);
            baliseEditBean.setCode(null);
            baliseEditBean.setTypeBalise(null);
        } else {
            this.childLoador.load((Object)objets.get(0), (Object)baliseEditBean, false, new String[0]);
            objets.remove(0);
        }
        if (editBean.getBaliseLue() == null) {
            editBean.setBaliseLue(new ArrayList());
        }
        editBean.getBaliseLue().add(baliseEditBean);
    }

    protected List<BaliseLue> dumpBaliseList(List<BaliseLue> list) {
        ArrayList<BaliseLueImpl> objets = null;
        if (list != null) {
            objets = new ArrayList<BaliseLueImpl>(list.size());
            for (BaliseLue baliseLue : list) {
                BaliseLueImpl b = new BaliseLueImpl();
                this.childLoador.load((Object)baliseLue, (Object)b, false, new String[0]);
                objets.add(b);
            }
        }
        return objets;
    }
}

