/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.entities.referentiel.ReferentielEntity;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveReferentielListCellRenderer;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorUtils;
import jaxx.runtime.decorator.JXPathDecorator;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.renderer.DecoratorTableCellRenderer;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.FileUtil;

public class UIHelper
extends SwingUtil {
    private static final Log log = LogFactory.getLog(UIHelper.class);

    public static void displayInfo(String text) {
        ObserveMainUI ui = ObserveContext.getObserveMainUI();
        if (ui == null) {
            JOptionPane.showMessageDialog(null, text);
        } else {
            ui.getStatus().setStatus(text);
        }
    }

    public static int askUser(String title, String message, int typeMessage, Object[] options, int defaultOption) {
        return UIHelper.askUser(null, title, message, typeMessage, options, defaultOption);
    }

    public static int askUser(Component parent, String title, Object message, int typeMessage, Object[] options, int defaultOption) {
        ObserveContext tx;
        if (parent == null && (tx = ObserveContext.get()) != null) {
            parent = ObserveContext.getObserveMainUI();
        }
        int response = JOptionPane.showOptionDialog(parent, message, title, -1, typeMessage, null, options, options[defaultOption]);
        return response;
    }

    public static File chooseFile(Component parent, String title, String buttonLabel, File incoming, String ... filters) {
        File basedir;
        File oldBasedir = FileUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileUtil.setCurrentDirectory((File)basedir);
        }
        File file = FileUtil.getFile((String)title, (String)buttonLabel, (Component)parent, (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileUtil.setCurrentDirectory((File)oldBasedir);
        File result = file == null ? incoming : file;
        return result;
    }

    public static File chooseDirectory(Component parent, String title, String buttonLabel, File incoming) {
        File basedir;
        File oldBasedir = FileUtil.getCurrentDirectory();
        if (incoming != null && (basedir = incoming.isFile() ? incoming.getParentFile() : incoming).exists()) {
            FileUtil.setCurrentDirectory((File)basedir);
        }
        String file = FileUtil.getDirectory((Component)parent, (String)title, (String)buttonLabel);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        FileUtil.setCurrentDirectory((File)oldBasedir);
        return file == null ? incoming : new File(file);
    }

    public static <E extends TopiaEntity> void prepareEntityList(StorageService<?> storageService, Class<E> entityClass, JList list, boolean storeInDataContext) throws StorageServiceException {
        Decorator<E> decorator = ObserveContext.getDecorator(entityClass);
        list.putClientProperty("decorator", decorator);
        List data = storageService.getList(entityClass);
        list.setCellRenderer(new ObserveReferentielListCellRenderer(decorator));
        DecoratorUtils.sort((JXPathDecorator)((JXPathDecorator)decorator), (List)data, (int)0);
        list.setListData(data.toArray());
        if (storeInDataContext) {
            ObserveContext tx = ObserveContext.get();
            ObserveDataContext dataTx = (ObserveDataContext)tx.getContextValue(ObserveDataContext.class);
            list.putClientProperty("datacontext", dataTx);
            list.putClientProperty("data", data);
        }
        EntitiesListPropertyChangeListener<E> listener = new EntitiesListPropertyChangeListener<E>(entityClass, list, storeInDataContext);
        storageService.addCachePropertyChangeListener(entityClass, listener);
    }

    public static <E extends ReferentielEntity> void prepareEntityComboBox(StorageService<?> storageService, Class<E> entityClass, EntityComboBox<E> comboBox) throws StorageServiceException {
        Decorator<E> decorator = ObserveContext.getDecorator(entityClass);
        List data = storageService.getList(entityClass);
        UIHelper.filterReferentielList(data, decorator);
        comboBox.init((JXPathDecorator)decorator, data);
        EntitiesComboBoxPropertyChangeListener<E> listener = new EntitiesComboBoxPropertyChangeListener<E>(entityClass, comboBox);
        storageService.addCachePropertyChangeListener(entityClass, listener);
    }

    public static <E extends ReferentielEntity> void filterReferentielList(List<E> list, Decorator<E> decorator) {
        Iterator<E> itr = list.iterator();
        while (itr.hasNext()) {
            ReferentielEntity e = (ReferentielEntity)itr.next();
            if (e.getStatus() != 0) continue;
            if (log.isDebugEnabled()) {
                if (decorator == null) {
                    log.debug((Object)("remove disabled entity " + e.getTopiaId() + " : " + e.getTopiaId()));
                } else {
                    log.debug((Object)("remove disabled entity " + e.getTopiaId() + " : " + decorator.toString((Object)e)));
                }
            }
            itr.remove();
        }
    }

    public static void prepareToogleListSelectionModel(JList list) {
        OneClicListSelectionModel model = new OneClicListSelectionModel(list.getSelectionModel(), list.getModel());
        list.setSelectionModel((ListSelectionModel)model);
    }

    public static <E extends TopiaEntity> boolean confirmForEntityDelete(JAXXObject parent, Class<E> beanClass, E bean) {
        return UIHelper.confirmForEntityDelete(parent, beanClass, bean, null);
    }

    public static <E extends TopiaEntity> boolean confirmForEntityDelete(JAXXObject parent, Class<E> beanClass, E bean, String extraMessage) {
        int response;
        String messageDelete;
        if (parent == null) {
            parent = ObserveContext.getObserveMainUI();
        }
        Decorator<E> decorator = ObserveContext.getDecorator(beanClass);
        String type = DBHelper.getEntityLabel(beanClass);
        type = I18n._((String)type);
        if (bean == null || bean.getTopiaId() == null || decorator == null) {
            messageDelete = I18n._((String)"observe.message.delete.new", (Object[])new Object[]{type});
        } else {
            try {
                String beanStr = decorator.toString(bean);
                messageDelete = I18n._((String)"observe.message.delete", (Object[])new Object[]{type, beanStr});
            }
            catch (Exception e) {
                messageDelete = I18n._((String)"observe.message.delete.new", (Object[])new Object[]{type});
            }
        }
        if (extraMessage != null) {
            messageDelete = messageDelete + '\n' + extraMessage;
        }
        return (response = UIHelper.askUser((Component)parent, I18n._((String)"observe.title.delete"), messageDelete, 2, new Object[]{I18n._((String)"observe.choice.confirm.delete"), I18n._((String)"observe.choice.cancel")}, 1)) == 0;
    }

    public static DecoratorTableCellRenderer newDecorateTableCellRenderer(TableCellRenderer renderer, Class<?> entityClass) {
        Decorator<?> decorator = ObserveContext.getDecorator(entityClass);
        return new DecoratorTableCellRenderer(renderer, decorator);
    }

    public static class ObserveValidatorMessageTableRenderer
    extends SwingValidatorMessageTableRenderer {
        private static final long serialVersionUID = 1L;

        public String getFieldName(JTable table, String value, int row) {
            String fieldName = super.getFieldName(table, value, row);
            if (!DBHelper.getPropertyMatch((String)fieldName).matches()) {
                fieldName = DBHelper.getPropertyLabel((String)fieldName);
            }
            return I18n._((String)fieldName);
        }
    }

    protected static class EntitiesComboBoxPropertyChangeListener<E extends ReferentielEntity>
    implements PropertyChangeListener {
        private final Class<E> entityClass;
        private final EntityComboBox<E> comboBox;

        public EntitiesComboBoxPropertyChangeListener(Class<E> entityClass, EntityComboBox<E> comboBox) {
            this.entityClass = entityClass;
            this.comboBox = comboBox;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ArrayList newValue = new ArrayList((List)evt.getNewValue());
            Decorator<E> decorator = ObserveContext.getDecorator(this.entityClass);
            if (log.isDebugEnabled()) {
                log.debug((Object)("reloading entities list for [" + this.entityClass + "], size : " + newValue.size()));
            }
            UIHelper.filterReferentielList(newValue, decorator);
            this.comboBox.setData(newValue);
        }
    }

    protected static class EntitiesListPropertyChangeListener<E extends TopiaEntity>
    implements PropertyChangeListener {
        private Class<E> entityClass;
        private JList list;
        private boolean storeInDataContext;

        public EntitiesListPropertyChangeListener(Class<E> entityClass, JList list, boolean storeInDataContext) {
            this.entityClass = entityClass;
            this.list = list;
            this.storeInDataContext = storeInDataContext;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            List newValue = (List)evt.getNewValue();
            Decorator decorator = (Decorator)this.list.getClientProperty("decorator");
            if (log.isDebugEnabled()) {
                log.debug((Object)("reloading entities list for [" + this.entityClass + "], size : " + newValue.size()));
            }
            DecoratorUtils.sort((JXPathDecorator)((JXPathDecorator)decorator), (List)newValue, (int)0);
            this.list.setListData(newValue.toArray());
            if (this.storeInDataContext) {
                ObserveDataContext context = (ObserveDataContext)this.list.getClientProperty("datacontext");
                this.list.putClientProperty("data", newValue);
                context.setEditingReferentielList(newValue);
            }
        }
    }
}

