/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.msaccess.importer;

import fr.ird.msaccess.importer.AbstractAccessDataSource;
import fr.ird.msaccess.importer.AbstractAccessEntityMeta;
import fr.ird.msaccess.importer.AccessEntityMetaProvider;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.nuiton.topia.persistence.TopiaEntityEnum;

public class AnalyseAccessDB {
    private static final AbstractAccessEntityMeta<TopiaEntityEnum>[] ABSTRACT_ACCESS_ENTITY_METAS = new AbstractAccessEntityMeta[0];

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("Must at least have one argument to db location");
        }
        File f = new File(args[0]);
        DummyAccessDataSource source = new DummyAccessDataSource(f);
        source.init();
        Set<String> tableNames = source.getUnusedTableNames();
        StringBuilder buffer = new StringBuilder();
        buffer.append("Detect ").append(tableNames.size()).append(" tables on db ").append(f);
        for (String tableName : tableNames) {
            Set<String> columns = source.getUnusedTableColumns(tableName);
            buffer.append("\n").append(tableName).append(" : ").append(columns);
        }
        buffer.append("\n");
        PrintWriter writer = System.console().writer();
        writer.append(buffer.toString());
        writer.flush();
    }

    private static class DummyAccessDataSource
    extends AbstractAccessDataSource<TopiaEntityEnum, AbstractAccessEntityMeta<TopiaEntityEnum>> {
        public DummyAccessDataSource(File f) {
            super(AbstractAccessEntityMeta.class, DummyMetaProvider.class, f);
        }

        protected AbstractAccessEntityMeta<TopiaEntityEnum>[] newMetaArray(Collection<AbstractAccessEntityMeta<TopiaEntityEnum>> iterable) {
            return ABSTRACT_ACCESS_ENTITY_METAS;
        }

        @Override
        protected void onTableMissing(AbstractAccessEntityMeta<TopiaEntityEnum> meta) {
        }

        @Override
        protected void onPropertyMissing(AbstractAccessEntityMeta<TopiaEntityEnum> meta, String property, String column) {
        }

        @Override
        protected void onPKeyMissing(AbstractAccessEntityMeta<TopiaEntityEnum> meta, String pkey) {
        }
    }

    public static class DummyMetaProvider
    implements AccessEntityMetaProvider<TopiaEntityEnum, AbstractAccessEntityMeta<TopiaEntityEnum>> {
        @Override
        public Set getMetas() {
            return Collections.emptySet();
        }
    }
}

