/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.msaccess.importer;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Table;
import fr.ird.msaccess.importer.AbstractAccessEntityMeta;
import fr.ird.msaccess.importer.AccessEntityMetaProvider;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.primitives.ArrayIntList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;

public abstract class AbstractAccessDataSource<T extends TopiaEntityEnum, M extends AbstractAccessEntityMeta<T>> {
    private static final Log log = LogFactory.getLog(AbstractAccessDataSource.class);
    protected M[] metas;
    protected Map<M, Map<String, Object>[]> cache;
    protected Map<String, Set<String>> tableColumns;
    protected Map<String, Set<String>> unusedTableColumns;
    protected final Class<M> metaClass;
    protected final Class<? extends AccessEntityMetaProvider<T, M>> providerClass;
    protected DataSourceState state;
    protected final File dbFile;

    protected boolean isInit() {
        return this.state != null && this.state.ordinal() >= DataSourceState.INIT.ordinal();
    }

    protected boolean isLoad() {
        return this.state != null && this.state.ordinal() >= DataSourceState.LOAD.ordinal();
    }

    protected void checkIfInit() {
        if (!this.isInit()) {
            throw new IllegalStateException("Data source " + this.dbFile + " was not init!");
        }
    }

    protected void checkIfLoad() {
        if (!this.isLoad()) {
            throw new IllegalStateException("Data source " + this.dbFile + " was not loaded!");
        }
    }

    public AbstractAccessDataSource(Class<? extends AbstractAccessEntityMeta> metaClass, Class<? extends AccessEntityMetaProvider<T, M>> providerClass, File dbFile) {
        if (metaClass == null) {
            throw new NullPointerException("metaClass parameter can not be null");
        }
        this.metaClass = metaClass;
        if (providerClass == null) {
            throw new NullPointerException("providerClass parameter can not be null");
        }
        this.providerClass = providerClass;
        if (dbFile == null) {
            throw new NullPointerException("dbFile parameter can not be null");
        }
        if (!dbFile.exists()) {
            throw new IllegalArgumentException("dbFile " + dbFile + " does not exists");
        }
        this.dbFile = dbFile;
    }

    protected abstract M[] newMetaArray(Collection<M> var1);

    protected abstract void onTableMissing(M var1);

    protected abstract void onPropertyMissing(M var1, String var2, String var3);

    protected abstract void onPKeyMissing(M var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        if (this.isInit()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Datasource " + this.dbFile + " was already init, will skip it."));
            }
            return;
        }
        AccessEntityMetaProvider<T, M> metaProvider = this.providerClass.newInstance();
        Set<M> metas = metaProvider.getMetas();
        Database connexion = this.getConnexion();
        try {
            HashSet<String> requiredTables = new HashSet<String>();
            for (AbstractAccessEntityMeta meta : metas) {
                requiredTables.add(meta.getTableName());
            }
            this.tableColumns = new TreeMap<String, Set<String>>();
            this.unusedTableColumns = new TreeMap<String, Set<String>>();
            for (Table table : connexion) {
                String tableName = table.getName();
                Map<String, Set<String>> result = requiredTables.contains(tableName) ? this.tableColumns : this.unusedTableColumns;
                TreeSet<String> columnNames = new TreeSet<String>();
                List columns = table.getColumns();
                for (Column column : columns) {
                    columnNames.add(column.getName());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("detected ms-access table " + tableName + " with columns " + columnNames));
                }
                Set value = Collections.unmodifiableSet(columnNames);
                result.put(tableName, value);
            }
            for (AbstractAccessEntityMeta meta : metas) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will init meta : " + meta));
                }
                this.initMeta(meta);
            }
            this.metas = this.newMetaArray(metas);
            this.state = DataSourceState.INIT;
        }
        finally {
            this.closeConnexion(connexion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        if (this.isLoad()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Datasource " + this.dbFile + " was already loaded, will skip it."));
            }
            return;
        }
        Database connexion = this.getConnexion();
        try {
            this.cache = new HashMap<M, Map<String, Object>[]>();
            for (M meta : this.metas) {
                Map<String, Object>[] data = this.loadTable(meta, connexion);
                this.cache.put(meta, data);
            }
            this.state = DataSourceState.LOAD;
        }
        finally {
            this.closeConnexion(connexion);
        }
    }

    protected final M initMeta(M meta) throws Exception {
        String tableName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("check entity :\n" + meta));
        }
        if (!this.tableColumns.containsKey(tableName = ((AbstractAccessEntityMeta)meta).getTableName())) {
            this.onTableMissing(meta);
            return meta;
        }
        Set<String> columns = this.tableColumns.get(tableName);
        ArrayList<AbstractAccessEntityMeta.PropertyMapping> mapping = new ArrayList<AbstractAccessEntityMeta.PropertyMapping>();
        for (AbstractAccessEntityMeta.PropertyMapping entry : ((AbstractAccessEntityMeta)meta).getPropertyMapping()) {
            String property = entry.getProperty();
            String column = entry.getColumn();
            if (columns.contains(column)) {
                mapping.add(entry);
                continue;
            }
            this.onPropertyMissing(meta, property, column);
        }
        ((AbstractAccessEntityMeta)meta).setPropertyMapping(mapping.toArray(new AbstractAccessEntityMeta.PropertyMapping[mapping.size()]));
        for (String pkey : ((AbstractAccessEntityMeta)meta).getPkeys()) {
            if (columns.contains(pkey)) continue;
            this.onPKeyMissing(meta, pkey);
        }
        return meta;
    }

    public final Map<String, Object>[] loadTable(M meta, Database connexion) throws IOException {
        String tableName = ((AbstractAccessEntityMeta)meta).getTableName();
        Table table = connexion.getTable(tableName);
        int rowCount = table.getRowCount();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load table " + tableName + " with " + rowCount + " row(s)."));
        }
        Map[] result = new Map[rowCount];
        int i = 0;
        Iterator itr = table.iterator();
        ArrayIntList errors = new ArrayIntList();
        while (i < rowCount && itr.hasNext()) {
            Map map = null;
            try {
                map = (Map)itr.next();
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Could not read row " + i + " of table " + tableName), (Throwable)e);
                }
                errors.add(i);
            }
            result[i++] = map;
        }
        if (!errors.isEmpty() && log.isWarnEnabled()) {
            log.warn((Object)("[" + ((AbstractAccessEntityMeta)meta).getType() + "] Could not load " + errors.size() + " row(s) : " + errors));
        }
        ((AbstractAccessEntityMeta)meta).setErrorRows(errors.toArray(new int[errors.size()]));
        return result;
    }

    protected Database getConnexion() throws IOException {
        Database database = Database.open((File)this.dbFile);
        if (database == null) {
            throw new IllegalStateException("Required an access connexion");
        }
        return database;
    }

    protected void closeConnexion(Database connexion) {
        block3: {
            if (connexion != null && connexion.getPageChannel() != null && connexion.getPageChannel().isOpen()) {
                try {
                    connexion.close();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Could not close access connexion", (Throwable)e);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public final void destroy() {
        if (this.isInit()) {
            this.tableColumns.clear();
            this.unusedTableColumns.clear();
            for (M meta : this.metas) {
                ((AbstractAccessEntityMeta)meta).clear();
            }
        }
        if (this.isLoad()) {
            for (AbstractAccessEntityMeta m : this.cache.keySet()) {
                Map<String, Object>[] maps;
                for (Map<String, Object> map : maps = this.cache.get(m)) {
                    if (map == null) continue;
                    map.clear();
                }
            }
            this.cache.clear();
        }
        this.metas = null;
        this.tableColumns = null;
        this.unusedTableColumns = null;
        this.cache = null;
        this.state = null;
    }

    public final Set<String> getTableNames() {
        this.checkIfInit();
        return this.tableColumns.keySet();
    }

    public final Set<String> getUnusedTableNames() {
        this.checkIfInit();
        return this.unusedTableColumns.keySet();
    }

    public Set<String> getTableColumns(String tableName) {
        this.checkIfInit();
        return this.tableColumns.get(tableName);
    }

    public Set<String> getUnusedTableColumns(String tableName) {
        this.checkIfInit();
        return this.unusedTableColumns.get(tableName);
    }

    public final boolean hasError() {
        this.checkIfInit();
        for (M meta : this.metas) {
            if (!((AbstractAccessEntityMeta)meta).hasError()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasWarning() {
        this.checkIfInit();
        for (M meta : this.metas) {
            if (!((AbstractAccessEntityMeta)meta).hasWarning()) continue;
            return true;
        }
        return false;
    }

    public final M[] getMetaWithError() {
        this.checkIfInit();
        ArrayList<M> result = new ArrayList<M>();
        for (M meta : this.metas) {
            if (!((AbstractAccessEntityMeta)meta).hasError()) continue;
            result.add(meta);
        }
        return this.newMetaArray(result);
    }

    public final M[] getMetaWithWarning() {
        this.checkIfInit();
        ArrayList<M> result = new ArrayList<M>();
        for (M meta : this.metas) {
            if (!((AbstractAccessEntityMeta)meta).hasWarning()) continue;
            result.add(meta);
        }
        return this.newMetaArray(result);
    }

    public M[] getMetas() {
        this.checkIfInit();
        return this.metas;
    }

    public M[] getMetaForType(Class<?> type) {
        this.checkIfInit();
        ArrayList<M> result = new ArrayList<M>();
        for (M meta : this.metas) {
            if (!type.isAssignableFrom(((AbstractAccessEntityMeta)meta).getType().getContract())) continue;
            result.add(meta);
        }
        return this.newMetaArray(result);
    }

    public M getMeta(T type) {
        this.checkIfInit();
        for (M meta : this.metas) {
            if (!type.equals(((AbstractAccessEntityMeta)meta).getType())) continue;
            return meta;
        }
        return null;
    }

    public final Map<String, Object>[] getTableData(M meta) {
        this.checkIfLoad();
        Map<String, Object>[] result = this.cache.get(meta);
        return result;
    }

    public final Map<String, Object> getTableDataRow(M meta, int row) {
        this.checkIfLoad();
        Map<String, Object>[] result = this.getTableData(meta);
        return result[row];
    }

    public final <E extends TopiaEntity> E[] loadAssociation(M meta, M container, Object[] pkeys) throws Exception {
        Map<String, Object>[] data;
        this.checkIfLoad();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        int row = 0;
        for (Map<String, Object> map : data = this.getTableData(meta)) {
            if (map == null) {
                ++row;
                continue;
            }
            Object[] pkey = this.getPkey(((AbstractAccessEntityMeta)container).getPkeys(), map);
            if (Arrays.equals(pkeys, pkey)) {
                TopiaEntity e = ((AbstractAccessEntityMeta)meta).newEntity(row, this.getPkey(meta, map));
                result.add(e);
            }
            ++row;
        }
        TopiaEntity[] r = (TopiaEntity[])Array.newInstance(((AbstractAccessEntityMeta)meta).getType().getContract(), result.size());
        int i = 0;
        for (TopiaEntity e : result) {
            r[i++] = e;
        }
        return r;
    }

    public final <E extends TopiaEntity> List<E> loadEntities(M meta) {
        this.checkIfLoad();
        ArrayList<TopiaEntity> result = new ArrayList<TopiaEntity>();
        int row = 0;
        for (Map<String, Object> map : this.getTableData(meta)) {
            Object[] pkey = this.getPkey(meta, map);
            TopiaEntity e = ((AbstractAccessEntityMeta)meta).newEntity(row++, pkey);
            result.add(e);
        }
        return result;
    }

    public Object[] getPkey(M meta, Map<String, Object> map) {
        return this.getPkey(((AbstractAccessEntityMeta)meta).getPkeys(), map);
    }

    public Object[] getPkey(List<String> keys, Map<String, Object> map) {
        Object[] result = new Object[keys.size()];
        int i = 0;
        for (String key : keys) {
            Object o = map.get(key);
            result[i++] = o;
        }
        return result;
    }

    public static enum DataSourceState {
        INIT,
        LOAD;

    }
}

