/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.search.function.ValueSourceScorer;

public class DoubleFieldSource
extends FieldCacheSource {
    protected FieldCache.DoubleParser parser;

    public DoubleFieldSource(String field) {
        this(field, null);
    }

    public DoubleFieldSource(String field, FieldCache.DoubleParser parser) {
        super(field);
        this.parser = parser;
    }

    public String description() {
        return "double(" + this.field + ')';
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final double[] arr = this.parser == null ? this.cache.getDoubles(reader, this.field) : this.cache.getDoubles(reader, this.field, this.parser);
        return new DocValues(){

            public float floatVal(int doc) {
                return (float)arr[doc];
            }

            public int intVal(int doc) {
                return (int)arr[doc];
            }

            public long longVal(int doc) {
                return (long)arr[doc];
            }

            public double doubleVal(int doc) {
                return arr[doc];
            }

            public String strVal(int doc) {
                return Double.toString(arr[doc]);
            }

            public String toString(int doc) {
                return DoubleFieldSource.this.description() + '=' + this.doubleVal(doc);
            }

            public ValueSourceScorer getRangeScorer(IndexReader reader, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
                double lower = lowerVal == null ? Double.NEGATIVE_INFINITY : Double.parseDouble(lowerVal);
                double upper = upperVal == null ? Double.POSITIVE_INFINITY : Double.parseDouble(upperVal);
                final double l = lower;
                final double u = upper;
                if (includeLower && includeUpper) {
                    return new ValueSourceScorer(reader, this){

                        public boolean matchesValue(int doc) {
                            double docVal = this.doubleVal(doc);
                            return docVal >= l && docVal <= u;
                        }
                    };
                }
                if (includeLower && !includeUpper) {
                    return new ValueSourceScorer(reader, this){

                        public boolean matchesValue(int doc) {
                            double docVal = this.doubleVal(doc);
                            return docVal >= l && docVal < u;
                        }
                    };
                }
                if (!includeLower && includeUpper) {
                    return new ValueSourceScorer(reader, this){

                        public boolean matchesValue(int doc) {
                            double docVal = this.doubleVal(doc);
                            return docVal > l && docVal <= u;
                        }
                    };
                }
                return new ValueSourceScorer(reader, this){

                    public boolean matchesValue(int doc) {
                        double docVal = this.doubleVal(doc);
                        return docVal > l && docVal < u;
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        if (o.getClass() != DoubleFieldSource.class) {
            return false;
        }
        DoubleFieldSource other = (DoubleFieldSource)o;
        return super.equals(other) && (this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass());
    }

    public int hashCode() {
        int h = this.parser == null ? Double.class.hashCode() : this.parser.getClass().hashCode();
        return h += super.hashCode();
    }
}

