/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyObsoleteException;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyCopyOnWrite;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittyStorage;

public class WikittyStorageInMemory
implements WikittyStorage {
    protected Map<String, Wikitty> wikitties = new LinkedHashMap<String, Wikitty>();

    public Map<String, Wikitty> getWikitties() {
        return this.wikitties;
    }

    public void setWikitties(Map<String, Wikitty> wikitties) {
        this.wikitties = wikitties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WikittyEvent store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean force) {
        WikittyEvent result = new WikittyEvent(this);
        for (Wikitty wikitty : wikitties) {
            try {
                wikitty = wikitty.clone();
            }
            catch (CloneNotSupportedException eee) {
                throw new WikittyException("Can't clone ?", eee);
            }
            String actualVersion = null;
            Wikitty inMemoryWikitty = this.wikitties.get(wikitty.getId());
            if (inMemoryWikitty != null) {
                actualVersion = inMemoryWikitty.getVersion();
            }
            String requestedVersion = wikitty.getVersion();
            String newVersion = null;
            if (force) {
                if (actualVersion == null) {
                    newVersion = requestedVersion == null ? "0.0" : requestedVersion;
                } else if (requestedVersion == null || requestedVersion.startsWith("0.")) {
                    newVersion = WikittyUtil.incrementMajorRevision(actualVersion);
                } else {
                    if (WikittyUtil.versionEquals(actualVersion, requestedVersion)) continue;
                    if (!WikittyUtil.versionGreaterThan(requestedVersion, actualVersion)) throw new WikittyObsoleteException(String.format("Your wikitty '%s' is obsolete (saving: '%s'; existing: '%s')", wikitty.getId(), requestedVersion, actualVersion));
                    newVersion = requestedVersion;
                }
            } else {
                if (WikittyUtil.versionEquals(actualVersion, requestedVersion)) continue;
                if (WikittyUtil.versionGreaterThan(actualVersion, requestedVersion)) {
                    throw new WikittyObsoleteException(String.format("Your wikitty '%s' is obsolete", wikitty.getId()));
                }
                newVersion = WikittyUtil.incrementMajorRevision(actualVersion);
            }
            wikitty.setVersion(newVersion);
            wikitty.clearDirty();
            try {
                this.wikitties.put(wikitty.getId(), wikitty.clone());
            }
            catch (CloneNotSupportedException eee) {
                throw new WikittyException("Can't clone ?", eee);
            }
            result.addWikitty(wikitty);
        }
        return result;
    }

    @Override
    public WikittyEvent delete(WikittyTransaction transaction, Collection<String> idList) throws WikittyException {
        WikittyEvent result = new WikittyEvent(this);
        Date now = new Date();
        for (String id : idList) {
            Wikitty w = this.restore(transaction, id, new String[0]);
            if (w == null) continue;
            w.setDeleteDate(now);
            result.addRemoveDate(id, now);
        }
        return result;
    }

    @Override
    public boolean exists(WikittyTransaction transaction, String id) {
        boolean result = this.wikitties.containsKey(id);
        return result;
    }

    @Override
    public boolean isDeleted(WikittyTransaction transaction, String id) {
        boolean result = false;
        Wikitty w = this.wikitties.get(id);
        if (w == null) {
            throw new WikittyException(String.format("No wikitty with id '%s'", id));
        }
        result = w.isDeleted();
        return result;
    }

    @Override
    public Wikitty restore(WikittyTransaction transaction, String id, String ... fqFieldName) throws WikittyException {
        Wikitty result = this.wikitties.get(id);
        if (result.isDeleted()) {
            result = null;
        }
        result = new WikittyCopyOnWrite(result);
        return result;
    }

    @Override
    public void scanWikitties(WikittyTransaction transaction, WikittyStorage.Scanner scanner) {
        Collection<Wikitty> all = this.wikitties.values();
        for (Wikitty wikitty : all) {
            scanner.scan(wikitty.getId());
        }
    }

    @Override
    public WikittyEvent clear(WikittyTransaction transaction) {
        this.wikitties = new LinkedHashMap<String, Wikitty>();
        WikittyEvent result = new WikittyEvent(this);
        result.addType(WikittyEvent.WikittyEventType.CLEAR_WIKITTY);
        return result;
    }

    @Override
    public WikittyStorage.DataStatistic getDataStatistic(WikittyTransaction transaction) {
        long active = 0L;
        long deleted = 0L;
        Collection<Wikitty> all = this.wikitties.values();
        for (Wikitty wikitty : all) {
            if (wikitty.isDeleted()) {
                ++deleted;
                continue;
            }
            ++active;
        }
        WikittyStorage.DataStatistic result = new WikittyStorage.DataStatistic(active, deleted);
        return result;
    }
}

