/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.query;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.conditions.Aggregate;
import org.nuiton.wikitty.query.conditions.And;
import org.nuiton.wikitty.query.conditions.Between;
import org.nuiton.wikitty.query.conditions.Condition;
import org.nuiton.wikitty.query.conditions.ConditionValue;
import org.nuiton.wikitty.query.conditions.ConditionValueString;
import org.nuiton.wikitty.query.conditions.ContainsAll;
import org.nuiton.wikitty.query.conditions.ContainsOne;
import org.nuiton.wikitty.query.conditions.Equals;
import org.nuiton.wikitty.query.conditions.False;
import org.nuiton.wikitty.query.conditions.Greater;
import org.nuiton.wikitty.query.conditions.GreaterOrEquals;
import org.nuiton.wikitty.query.conditions.Keyword;
import org.nuiton.wikitty.query.conditions.Less;
import org.nuiton.wikitty.query.conditions.LessOrEquals;
import org.nuiton.wikitty.query.conditions.Like;
import org.nuiton.wikitty.query.conditions.Not;
import org.nuiton.wikitty.query.conditions.NotEquals;
import org.nuiton.wikitty.query.conditions.NotNull;
import org.nuiton.wikitty.query.conditions.Null;
import org.nuiton.wikitty.query.conditions.Or;
import org.nuiton.wikitty.query.conditions.Select;
import org.nuiton.wikitty.query.conditions.True;
import org.nuiton.wikitty.query.conditions.Unlike;
import org.parboiled.BaseParser;
import org.parboiled.Context;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.annotations.BuildParseTree;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParseTreeUtils;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.Var;

@BuildParseTree
public class WikittyQueryParser
extends BaseParser<Object> {
    public static final String AVG = "AVG";
    public static final String COUNT = "COUNT";
    public static final String MAX = "MAX";
    public static final String MIN = "MIN";
    public static final String SUM = "SUM";
    public static final String SELECT = "SELECT";
    public static final String WHERE = "WHERE";
    public static final String IN = "IN";
    public static final String LITERAL_CLOSE = "\"";
    public static final String LITERAL_OPEN = "\"";
    public static final String NULL = "NULL";
    public static final String TO = "TO";
    public static final String FALSE = "FALSE";
    public static final String TRUE = "TRUE";
    public static final String UNLIKE = "UNLIKE";
    public static final String AND = "AND";
    public static final String COMMA = ",";
    public static final String CURLY_BRACKET_CLOSE = "}";
    public static final String CURLY_BRACKET_OPEN = "{";
    public static final String EQUALS = "=";
    public static final String GREATER = ">";
    public static final String GREATER_OR_EQUALS = ">=";
    public static final String LESS = "<";
    public static final String LESS_OR_EQUALS = "<=";
    public static final String LIKE = "LIKE";
    public static final String NOT = "NOT";
    public static final String NOT_EQUALS = "!=";
    public static final String OR = "OR";
    public static final String BRACKET_CLOSE = ")";
    public static final String BRACKET_OPEN = "(";
    public static final String SQUARE_BRACKET_CLOSE = "]";
    public static final String SQUARE_BRACKET_OPEN = "[";
    public Rule icEXTENSION = this.IgnoreCase(Element.EXTENSION.getValue());
    public Rule icID = this.IgnoreCase(Element.ID.getValue());
    public Rule icNOT = this.IgnoreCase("NOT");
    public Rule icAND = this.IgnoreCase("AND");
    public Rule icOR = this.IgnoreCase("OR");
    public Rule icAVG = this.IgnoreCase("AVG");
    public Rule icCOUNT = this.IgnoreCase("COUNT");
    public Rule icMAX = this.IgnoreCase("MAX");
    public Rule icMIN = this.IgnoreCase("MIN");
    public Rule icSUM = this.IgnoreCase("SUM");
    public Rule icSELECT = this.IgnoreCase("SELECT");
    public Rule icWHERE = this.IgnoreCase("WHERE");
    public Rule icIN = this.IgnoreCase("IN");
    public Rule icTO = this.IgnoreCase("TO");
    public Rule icFALSE = this.IgnoreCase("FALSE");
    public Rule icTRUE = this.IgnoreCase("TRUE");
    public Rule icLIKE = this.IgnoreCase("LIKE");
    public Rule icUNLIKE = this.IgnoreCase("UNLIKE");
    public Rule icNULL = this.IgnoreCase("NULL");
    private static Log log = LogFactory.getLog(WikittyQueryParser.class);
    protected Map<String, String> alias = new LinkedHashMap<String, String>();

    boolean debug(String text, Context context) {
        System.out.println("DEBUG(" + context.getCurrentIndex() + "):" + text + "  nodes:" + context.getSubNodes());
        return true;
    }

    public Map<String, String> getAlias() {
        return this.alias;
    }

    public WikittyQueryParser setAlias(Map<String, String> alias) {
        this.alias = alias;
        return this;
    }

    public WikittyQueryParser addAlias(String aliasName, String aliasValue) {
        this.alias.put(aliasName, aliasValue);
        return this;
    }

    public WikittyQuery parseQuery(String queryString) {
        WikittyQuery result = WikittyQueryParser.parse(queryString, this.alias);
        return result;
    }

    public static WikittyQuery parse(String queryString) {
        WikittyQuery result = WikittyQueryParser.parse(queryString, null);
        return result;
    }

    public static WikittyQuery parse(String queryString, Map<String, String> alias) {
        WikittyQueryParser parser;
        ParsingResult result;
        if (alias != null) {
            String queryStringInit = queryString;
            for (Map.Entry<String, String> a : alias.entrySet()) {
                queryString = queryString.replaceAll(a.getKey(), a.getValue());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("QueryString \n'%s' become after alias \n'%s'\naliases are %s", queryStringInit, queryString, alias));
            }
        }
        if ((result = new ReportingParseRunner((parser = (WikittyQueryParser)Parboiled.createParser(WikittyQueryParser.class, (Object[])new Object[0])).start()).run(queryString)).hasErrors() || !result.matched) {
            System.out.println("\nParse Errors:\n" + ErrorUtils.printParseErrors((ParsingResult)result));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("\nParse Tree:\n" + ParseTreeUtils.printNodeTree((ParsingResult)result) + '\n'));
        }
        Condition c = (Condition)result.resultValue;
        WikittyQuery query = new WikittyQuery(c);
        return query;
    }

    protected Element toElement(String v) {
        Element result = Element.get(v);
        return result;
    }

    protected String removeQuote(String s) {
        String result = s;
        if (StringUtils.startsWith((String)s, (String)"\"") && StringUtils.startsWith((String)s, (String)"\"")) {
            result = StringUtils.substring((String)s, (int)1, (int)-1);
        }
        return result;
    }

    Rule start() {
        return this.Sequence(this.or(), EOI, new Object[0]);
    }

    Rule or() {
        return this.Sequence(this.and(), this.ZeroOrMore(this.space(), this.icOR, new Object[]{this.space(), this.and(), this.push(new Or((Condition)this.pop(1), (Condition)this.pop()))}), new Object[0]);
    }

    Rule and() {
        return this.Sequence(this.term(), this.ZeroOrMore(this.FirstOf(this.Sequence(this.space(), this.icAND, new Object[]{this.space()}), this.Sequence(this.space(), this.TestNot(this.icOR), new Object[0]), new Object[0]), this.term(), new Object[]{this.push(new And((Condition)this.pop(1), (Condition)this.pop()))}), new Object[0]);
    }

    Rule term() {
        return this.FirstOf(this.condition(), this.Parens(), new Object[0]);
    }

    Rule Parens() {
        return this.Sequence(this.space(), BRACKET_OPEN, new Object[]{this.space(), this.or(), this.space(), BRACKET_CLOSE, this.space()});
    }

    Rule condition() {
        return this.FirstOf(this.not(), this.isNull(), new Object[]{this.isNotNull(), this.select(), this.greatereq(), this.lesseq(), this.between(), this.containsAll(), this.containsOne(), this.eq(), this.neq(), this.less(), this.greater(), this.like(), this.notlike(), this.rTrue(), this.rFalse(), this.keyword()});
    }

    Rule not() {
        return this.Sequence(this.space(), this.icNOT, new Object[]{this.space(), this.term(), this.push(new Not((Condition)this.pop()))});
    }

    Rule isNull() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), EQUALS, this.space(), this.icNULL, this.push(new Null(this.toElement(this.pop().toString())))});
    }

    Rule isNotNull() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), NOT_EQUALS, this.space(), this.icNULL, this.push(new NotNull(this.toElement(this.pop().toString())))});
    }

    Rule eq() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), EQUALS, this.space(), this.value(), this.push(new Equals(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule neq() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), NOT_EQUALS, this.space(), this.value(), this.push(new NotEquals(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule less() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), LESS, this.space(), this.value(), this.push(new Less(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule lesseq() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), LESS_OR_EQUALS, this.space(), this.value(), this.push(new LessOrEquals(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule greater() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), GREATER, this.space(), this.value(), this.push(new Greater(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule greatereq() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), GREATER_OR_EQUALS, this.space(), this.value(), this.push(new GreaterOrEquals(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule like() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), this.icLIKE, this.space(), this.value(), this.push(new Like(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule notlike() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), this.icUNLIKE, this.space(), this.value(), this.push(new Unlike(this.toElement(this.pop(1).toString()), (ConditionValue)this.pop()))});
    }

    Rule between() {
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), EQUALS, this.space(), SQUARE_BRACKET_OPEN, this.space(), this.value(), this.space(), this.icTO, this.space(), this.value(), this.space(), SQUARE_BRACKET_CLOSE, this.push(new Between(this.toElement(this.pop(2).toString()), (ConditionValue)this.pop(1), (ConditionValue)this.pop()))});
    }

    Rule containsAll() {
        Var elems = new Var(new LinkedList());
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), EQUALS, this.space(), SQUARE_BRACKET_OPEN, this.space(), this.value(), ((List)elems.get()).add((ConditionValue)this.pop()), this.space(), this.ZeroOrMore(COMMA, this.space(), new Object[]{this.value(), ((List)elems.get()).add((ConditionValue)this.pop()), this.space()}), SQUARE_BRACKET_CLOSE, this.push(new ContainsAll(this.toElement(this.pop().toString()), (Collection)elems.get()))});
    }

    Rule containsOne() {
        Var elems = new Var(new LinkedList());
        return this.Sequence(this.field(), this.push(this.match()), new Object[]{this.space(), EQUALS, this.space(), CURLY_BRACKET_OPEN, this.space(), this.value(), ((List)elems.get()).add((ConditionValue)this.pop()), this.space(), this.ZeroOrMore(COMMA, this.space(), new Object[]{this.value(), ((List)elems.get()).add((ConditionValue)this.pop()), this.space()}), CURLY_BRACKET_CLOSE, this.push(new ContainsOne(this.toElement(this.pop().toString()), (Collection)elems.get()))});
    }

    Rule select() {
        Var aggregate = new Var();
        return this.Sequence(this.icSELECT, this.space(), new Object[]{this.Optional(this.aggregate((Var<Aggregate>)aggregate)), this.space(), this.field(), this.push(this.match()), this.space(), this.icWHERE, this.space(), this.term(), this.push(new Select(this.toElement(this.pop(1).toString()), (Aggregate)((Object)aggregate.get()), (Condition)this.pop()))});
    }

    Rule aggregate(Var<Aggregate> aggregate) {
        return this.FirstOf(this.avg(aggregate), this.count(aggregate), new Object[]{this.max(aggregate), this.min(aggregate), this.sum(aggregate)});
    }

    Rule avg(Var<Aggregate> aggregate) {
        return this.Sequence(this.icAVG, aggregate.set((Object)Aggregate.AVG), new Object[0]);
    }

    Rule count(Var<Aggregate> aggregate) {
        return this.Sequence(this.icCOUNT, aggregate.set((Object)Aggregate.COUNT), new Object[0]);
    }

    Rule max(Var<Aggregate> aggregate) {
        return this.Sequence(this.icMAX, aggregate.set((Object)Aggregate.MAX), new Object[0]);
    }

    Rule min(Var<Aggregate> aggregate) {
        return this.Sequence(this.icMIN, aggregate.set((Object)Aggregate.MIN), new Object[0]);
    }

    Rule sum(Var<Aggregate> aggregate) {
        return this.Sequence(this.icSUM, aggregate.set((Object)Aggregate.SUM), new Object[0]);
    }

    Rule keyword() {
        return this.Sequence(this.value(), this.push(new Keyword().addCondition((ConditionValue)this.pop())), new Object[0]);
    }

    Rule field() {
        return this.OneOrMore(this.FirstOf(this.CharRange('0', '9'), this.CharRange('a', 'z'), new Object[]{this.CharRange('A', 'Z'), this.AnyOf("_.*")}));
    }

    Rule rTrue() {
        return this.Sequence(this.icTRUE, this.push(new True()), new Object[0]);
    }

    Rule rFalse() {
        return this.Sequence(this.icFALSE, this.push(new False()), new Object[0]);
    }

    Rule value() {
        return this.FirstOf(this.select(), this.valueText(), new Object[0]);
    }

    Rule valueText() {
        return this.Sequence(this.FirstOf(this.StringLiteral(), this.SimpleString(), new Object[0]), this.push(new ConditionValueString(this.removeQuote(this.match()))), new Object[0]);
    }

    Rule SimpleString() {
        return this.OneOrMore(this.FirstOf(this.Escape(), this.Sequence(this.TestNot(this.AnyOf(" \t\r\n\\,\"\"(){}[]")), ANY, new Object[0]), new Object[0])).suppressSubnodes();
    }

    Rule StringLiteral() {
        return this.Sequence("\"", this.ZeroOrMore(this.FirstOf(this.Escape(), this.Sequence(this.TestNot(this.AnyOf("\r\n\\\"\"")), ANY, new Object[0]), new Object[0])).suppressSubnodes(), new Object[]{"\""});
    }

    Rule Escape() {
        return this.Sequence(Character.valueOf('\\'), this.FirstOf(this.AnyOf("btnfr'\\\"\""), this.OctalEscape(), new Object[]{this.UnicodeEscape()}), new Object[0]);
    }

    Rule OctalEscape() {
        return this.FirstOf(this.Sequence(this.CharRange('0', '3'), this.CharRange('0', '7'), new Object[]{this.CharRange('0', '7')}), this.Sequence(this.CharRange('0', '7'), this.CharRange('0', '7'), new Object[0]), new Object[]{this.CharRange('0', '7')});
    }

    Rule UnicodeEscape() {
        return this.Sequence(this.OneOrMore(Character.valueOf('u')), this.HexDigit(), new Object[]{this.HexDigit(), this.HexDigit(), this.HexDigit()});
    }

    Rule HexDigit() {
        return this.FirstOf(this.CharRange('a', 'f'), this.CharRange('A', 'F'), new Object[]{this.CharRange('0', '9')});
    }

    Rule space() {
        return this.ZeroOrMore(this.AnyOf(" \t\f"));
    }
}

