/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.iharder.Base64;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateTimeConverter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyConstants;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyField;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyTypes;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class WikittyUtil
implements WikittyConstants {
    public static final String extensionNamePattern = "\\w+";
    public static final String extensionFieldNamePattern = "\\w+";
    public static final String DEFAULT_MAJOR_VERSION = "0";
    public static final String DEFAULT_MINOR_VERSION = "0";
    public static final String DEFAULT_MAJOR_VERSION_PREFIX = "0.";
    public static final String DEFAULT_VERSION = "0.0";
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ'Z'";
    public static final String SOLR_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static Log log = LogFactory.getLog(WikittyUtil.class);
    protected static final TimeZone CANONICAL_TZ = TimeZone.getTimeZone("UTC");
    protected static final Locale CANONICAL_LOCALE = Locale.US;
    protected static final FastDateFormat solrDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ'Z'", (TimeZone)CANONICAL_TZ, (Locale)CANONICAL_LOCALE);
    public static final String[] DATE_FORMAT_ALLOWED = new String[]{solrDateFormat.getPattern(), "yyyy-MM-dd'T'HH:mm:ss.SSSZ'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", new SimpleDateFormat().toPattern(), "dd/MM/yy", "dd/MM/yy hh:mm", "yyyyMMdd"};
    public static Map<Class<?>, Class<?>> interfaceToClass = new HashMap();
    protected static String tagValuesPatternString = "(\\w*)=(\".*?(?<!\\\\)\"|[^(\\p{Space})]+)";
    protected static Pattern tagValuesPattern = Pattern.compile(tagValuesPatternString, 32);
    protected static Pattern fieldPattern = Pattern.compile("\\s*(\\w+)\\s+(\\w+)(?:\\s*\\[(\\d+)-(?:(\\d+)|([\\*n]))\\])?(?:\\s+(unique))?(?:\\s+(not null))?((?:\\s+" + tagValuesPatternString + ")*)", 32);
    protected static Pattern formatMatcher = Pattern.compile("%[^0-9][^|$]*(\\|(.*?))?\\$[0-9]*?[a-zA-Z]");
    public static WikittyDateConverter dateConverter = new WikittyDateConverter();

    public static Date parseDate(String dateAsString) throws ParseException {
        return DateUtils.parseDate((String)dateAsString, (String[])DATE_FORMAT_ALLOWED);
    }

    public static String formatDate(Date date) throws ParseException {
        if (date == null) {
            return null;
        }
        return solrDateFormat.format(date);
    }

    public static String parseField(String def, FieldType fieldType) {
        Matcher match = fieldPattern.matcher(def);
        if (match.matches()) {
            String notNullString;
            String noupper;
            String upper;
            fieldType.setType(WikittyTypes.parse(match.group(1)));
            String name = match.group(2);
            String lower = match.group(3);
            if (lower != null) {
                fieldType.setLowerBound(Integer.parseInt(lower));
            }
            if ((upper = match.group(4)) != null) {
                fieldType.setUpperBound(Integer.parseInt(upper));
            }
            if ((noupper = match.group(5)) != null) {
                fieldType.setUpperBound(Integer.MAX_VALUE);
            }
            String tagValues = match.group(8);
            Map<String, String> tagValuesMap = WikittyUtil.tagValuesToMap(tagValues);
            String uniqueString = match.group(6);
            if (uniqueString != null) {
                tagValuesMap.put(FieldType.UNIQUE, "true");
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Old field constraints definition detected \"unique\" ; prefer use of \"unique=true\"");
                }
            }
            if ((notNullString = match.group(7)) != null) {
                tagValuesMap.put(FieldType.NOT_NULL, "true");
                log.warn((Object)"Old field constraints definition detected \"non null\" ; prefer use of \"notNull=true\"");
            }
            fieldType.setTagValues(tagValuesMap);
            return name;
        }
        throw new WikittyException(String.format("Bad FieldType definition '%s'", def));
    }

    public static String tagValuesToString(Map<String, String> tagValues) {
        String result = WikittyTransformerUtil.tagValuesToString(tagValues);
        return result;
    }

    public static Map<String, String> tagValuesToMap(String tagValues) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (tagValues != null) {
            Matcher matchTagValues = tagValuesPattern.matcher(tagValues);
            while (matchTagValues.find()) {
                String tag = matchTagValues.group(1);
                String value = matchTagValues.group(2);
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                    value = StringEscapeUtils.unescapeJava((String)value);
                }
                result.put(tag, value);
            }
        }
        return result;
    }

    public static LinkedHashMap<String, FieldType> buildFieldMapExtension(String ... definitions) {
        LinkedHashMap<String, FieldType> result = new LinkedHashMap<String, FieldType>();
        for (String def : definitions) {
            FieldType fieldType = new FieldType();
            String name = WikittyUtil.parseField(def, fieldType);
            if (log.isDebugEnabled()) {
                log.debug((Object)("parse " + def + " => " + fieldType.toDefinition(name)));
            }
            result.put(name, fieldType);
        }
        return result;
    }

    public static String normalizeVersion(String version) {
        if (version == null || "".equals(version)) {
            version = "0";
        }
        if (version.indexOf(".") == -1) {
            version = version + ".0";
        }
        return version;
    }

    public static boolean versionEquals(String v1, String v2) {
        if (v1 == null || v2 == null) {
            return false;
        }
        return WikittyUtil.normalizeVersion(v1).equals(WikittyUtil.normalizeVersion(v2));
    }

    public static boolean versionGreaterThan(String v1, String v2) {
        if (v1 != null && v2 == null) {
            return true;
        }
        if (v1 == null) {
            return false;
        }
        String[] v1s = WikittyUtil.normalizeVersion(v1).split("\\.");
        String[] v2s = WikittyUtil.normalizeVersion(v2).split("\\.");
        int minlen = Math.min(v1s.length, v2s.length);
        for (int i = 0; i < minlen; ++i) {
            if (v1s[i].equals(v2s[i])) continue;
            return Integer.parseInt(v1s[i]) > Integer.parseInt(v2s[i]);
        }
        return v1s.length > v2s.length;
    }

    public static String incrementMinorRevision(String v) {
        String result;
        if (v == null || "".equals(v)) {
            result = "0.1";
        } else {
            String[] mm = (v = v.trim()).split("\\.");
            if (mm.length == 1) {
                result = v + ".1";
            } else {
                int i = Integer.parseInt(mm[1]) + 1;
                result = mm[0] + "." + i;
            }
        }
        return result;
    }

    public static String incrementMajorRevision(String v) {
        String result;
        if (v == null || "".equals(v)) {
            result = "1.0";
        } else {
            v = v.trim();
            String[] mm = v.split("\\.");
            int i = Integer.parseInt(mm[0]) + 1;
            result = i + ".0";
        }
        return result;
    }

    public static String format(String formatWikitty, Wikitty w) {
        Set<String> fields = w.getAllFieldNames();
        Object[] values = new Object[fields.size()];
        String format = formatWikitty;
        int i = 0;
        for (String field : fields) {
            values[i++] = w.getFqField(field);
            format = format.replaceAll("%" + Pattern.quote(field) + "(\\|.*?)?\\$", "\\%" + i + "\\$");
        }
        format = formatMatcher.matcher(format).replaceAll("$2");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s -> %s (with %s)", formatWikitty, format, fields));
        }
        String result = String.format(format, values);
        return result;
    }

    public static byte[] toBinary(Object value) {
        byte[] result = null;
        if (value == null || "".equals(value)) {
            result = new byte[]{};
        } else if (value instanceof String) {
            try {
                result = Base64.decode((String)((String)value));
            }
            catch (IOException eee) {
                throw new WikittyException("Bad Base64 format", eee);
            }
        } else {
            result = value instanceof byte[] ? (byte[])value : value.toString().getBytes();
        }
        return result;
    }

    public static BigDecimal toBigDecimal(Object value) {
        BigDecimal result = null;
        if (value == null || "".equals(value)) {
            result = new BigDecimal(0);
        } else if (value instanceof BigDecimal) {
            result = (BigDecimal)value;
        } else {
            try {
                result = new BigDecimal(value.toString());
            }
            catch (NumberFormatException eee) {
                throw new WikittyException(String.format("Can't convert value '%s' to numeric", WikittyUtil.getClass(value)), eee);
            }
        }
        return result.stripTrailingZeros();
    }

    public static boolean toBoolean(Object value) {
        boolean result = false;
        if (value != null) {
            result = value instanceof Boolean ? (Boolean)value : (value instanceof Number ? !((Number)value).equals(0) : !"false".equalsIgnoreCase(value.toString()));
        }
        return result;
    }

    public static String toString(Object value) {
        String result = null;
        if (value != null) {
            result = value instanceof String ? (String)value : (value instanceof WikittyImpl ? ((Wikitty)value).getId() : (value instanceof BusinessEntity ? ((BusinessEntity)value).getWikittyId() : (value instanceof Date ? solrDateFormat.format((Date)value) : (value instanceof Calendar ? solrDateFormat.format((Calendar)value) : (value instanceof BigDecimal ? ((BigDecimal)value).stripTrailingZeros().toString() : value.toString())))));
        }
        return result;
    }

    public static Date toDate(Object value) {
        Date result = null;
        if (value != null) {
            if (value instanceof Date) {
                result = (Date)value;
            } else if (value instanceof Calendar) {
                result = ((Calendar)value).getTime();
            } else {
                block8: {
                    try {
                        result = WikittyUtil.parseDate(value.toString());
                    }
                    catch (ParseException eee) {
                        if (!log.isDebugEnabled()) break block8;
                        log.debug((Object)"Can't parse date, i try with next parser", (Throwable)eee);
                    }
                }
                if (result == null) {
                    throw new WikittyException(String.format("Can't convert value '%s' of type '%s' to Date", value, WikittyUtil.getClass(value)));
                }
            }
        }
        return result;
    }

    public static String toWikitty(Object value) {
        String result = null;
        if (value != null) {
            result = value instanceof String ? (String)value : (value instanceof Wikitty ? ((Wikitty)value).getId() : (value instanceof BusinessEntity ? ((BusinessEntity)value).getWikittyId() : value.toString()));
        }
        return result;
    }

    public static <E> List<E> toList(Object value, Class<E> clazz) {
        try {
            List result = (List)value;
            if (result != null) {
                result = Collections.unmodifiableList(result);
            }
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't convert value '%s' to list", WikittyUtil.getClass(value)), eee);
        }
    }

    public static String toStringForExport(FieldType field, Object o) {
        String result = null;
        if (o != null) {
            if (o instanceof String) {
                result = (String)o;
            } else {
                switch (field.getType()) {
                    case BINARY: {
                        result = Base64.encodeBytes((byte[])((byte[])o));
                        break;
                    }
                    case DATE: {
                        result = solrDateFormat.format((Date)o);
                        break;
                    }
                    default: {
                        result = WikittyUtil.toString(o);
                    }
                }
            }
        }
        return result;
    }

    public static String toStringForSearchEngine(FieldType field, Object o) {
        String result = null;
        if (o != null) {
            switch (field.getType()) {
                case BINARY: {
                    result = "";
                    break;
                }
                case DATE: {
                    result = o instanceof String ? (String)o : solrDateFormat.format((Date)o);
                    break;
                }
                default: {
                    result = WikittyUtil.toString(o);
                }
            }
        }
        return result;
    }

    public static Object fromString(FieldType field, String s) {
        Object result = null;
        switch (field.getType()) {
            case BINARY: {
                if (s == null | "".equals(s)) {
                    result = new byte[0];
                    break;
                }
                try {
                    result = Base64.decode((String)s);
                    break;
                }
                catch (IOException eee) {
                    throw new WikittyException("Bad Base64 format", eee);
                }
            }
            case BOOLEAN: {
                result = WikittyUtil.toBoolean(s);
                break;
            }
            case DATE: {
                result = WikittyUtil.toDate(s);
                break;
            }
            case NUMERIC: {
                result = WikittyUtil.toBigDecimal(s);
                break;
            }
            default: {
                result = s;
            }
        }
        return result;
    }

    public static Class<?> getClass(Object value) {
        Class<?> result = null;
        if (value != null) {
            result = value.getClass();
        }
        return result;
    }

    public static <E extends BusinessEntity> E newInstance(Class<E> clazz) {
        try {
            Class<Object> clazzInstanciable = clazz;
            if (clazzInstanciable.isInterface()) {
                log.debug((Object)String.format("Argument '%s' is interface looking for implementation", clazzInstanciable.getName()));
                clazzInstanciable = interfaceToClass.containsKey(clazz) ? interfaceToClass.get(clazz) : Class.forName(clazz.getName() + "Impl");
            }
            if (!BusinessEntityImpl.class.isAssignableFrom(clazzInstanciable)) {
                throw new WikittyException(String.format("Your class '%s' don't extends BusinessEntityImpl", clazz.getName()));
            }
            BusinessEntity result = (BusinessEntity)clazzInstanciable.newInstance();
            return (E)result;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't create new instance of %s", clazz), eee);
        }
    }

    public static <E extends BusinessEntity> E newInstance(Class<E> target, Wikitty w) {
        E result = null;
        if (w != null) {
            result = WikittyUtil.newInstance(target);
            BusinessEntityImpl bean = (BusinessEntityImpl)result;
            bean.setWikitty(w);
        }
        return result;
    }

    public <E extends BusinessEntity> E newInstance(Class<E> target, BusinessEntityImpl source) {
        E result = WikittyUtil.newInstance(target, source.getWikitty());
        return result;
    }

    public static <E extends BusinessEntity> List<E> newInstance(Class<E> target, List<Wikitty> wikitties) {
        ArrayList<E> result = new ArrayList<E>(wikitties.size());
        for (Wikitty w : wikitties) {
            if (w == null) {
                result.add(null);
                continue;
            }
            result.add(WikittyUtil.newInstance(target, w));
        }
        return result;
    }

    @Deprecated
    public static <E extends BusinessEntity> E newInstance(String securityToken, WikittyService wikittyService, Class<E> clazz, Wikitty w) {
        try {
            BusinessEntity result;
            block7: {
                Class<Object> clazzInstanciable = clazz;
                if (clazzInstanciable.isInterface()) {
                    log.debug((Object)String.format("Argument '%s' is interface looking for implementation", clazzInstanciable.getName()));
                    clazzInstanciable = interfaceToClass.containsKey(clazz) ? interfaceToClass.get(clazz) : Class.forName(clazz.getName() + "Impl");
                }
                if (!BusinessEntityImpl.class.isAssignableFrom(clazzInstanciable)) {
                    throw new WikittyException(String.format("Your class '%s' don't extends BusinessEntityImpl", clazz.getName()));
                }
                result = null;
                if (w != null) {
                    try {
                        Constructor<E> cons = clazzInstanciable.getConstructor(Wikitty.class);
                        Object[] parms = new Object[]{null};
                        result = (BusinessEntity)cons.newInstance(parms);
                        BusinessEntityImpl bean = (BusinessEntityImpl)result;
                        WikittyUtil.checkExtensionVersion(securityToken, wikittyService, w, bean);
                        bean.setWikitty(w);
                    }
                    catch (NoSuchMethodException noerror) {
                        if (!log.isErrorEnabled()) break block7;
                        log.error((Object)String.format("Can't find constructor with wikitty arguement in '%s',we try with setWikitty method", clazzInstanciable.getName()), (Throwable)noerror);
                    }
                }
            }
            return (E)result;
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't create new instance of %s", clazz), eee);
        }
    }

    public static Wikitty checkExtensionVersion(String securityToken, WikittyService wikittyService, Wikitty wikitty, BusinessEntityImpl entity) {
        Wikitty result = wikitty;
        boolean upgradeData = false;
        Collection<WikittyExtension> extensions = entity.getStaticExtensions();
        for (WikittyExtension ext : extensions) {
            String oldVersion;
            String extName = ext.getName();
            if (!wikitty.hasExtension(extName)) continue;
            WikittyExtension oldExt = wikitty.getExtension(extName);
            String newVersion = ext.getVersion();
            if (!WikittyUtil.versionGreaterThan(newVersion, oldVersion = oldExt.getVersion())) continue;
            wikittyService.storeExtension(securityToken, Arrays.asList(ext));
            upgradeData = true;
        }
        if (upgradeData) {
            String wikittyId = wikitty.getId();
            result = WikittyServiceEnhanced.restore(wikittyService, securityToken, wikittyId);
        }
        return result;
    }

    public static <E> E cast(Object obj, Class<E> clazz) {
        E result = null;
        if (obj != null) {
            if (clazz.isAssignableFrom(obj.getClass())) {
                result = clazz.cast(obj);
            } else if (obj instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)obj;
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    result = clazz.cast(bd.intValue());
                } else if (clazz == Float.TYPE || clazz == Float.class) {
                    result = clazz.cast(Float.valueOf(bd.floatValue()));
                }
            }
            if (result == null) {
                throw new WikittyException("Unable to cast from '" + obj.getClass().getName() + "' to " + clazz.getName());
            }
        }
        return result;
    }

    public static Wikitty clone(Wikitty wikittyToClone, boolean genId) throws CloneNotSupportedException {
        if (genId) {
            WikittyImpl w = new WikittyImpl();
            w.replaceWith(wikittyToClone, true);
            return w;
        }
        return wikittyToClone.clone();
    }

    public static String genSecurityTokenId() {
        String result = "_" + Math.abs(Math.random());
        result = result.replace(".", "");
        result = WikittyUtil.genUID() + result;
        return result;
    }

    public static String genUID() {
        return UUID.randomUUID().toString();
    }

    public static String getExtensionNameFromFQFieldName(String fqFieldName) {
        String[] fqFieldElements = fqFieldName.split("\\.");
        return fqFieldElements[0];
    }

    public static String getFieldNameFromFQFieldName(String fqFieldName) {
        String[] fqFieldElements = fqFieldName.split("\\.");
        return fqFieldElements[1];
    }

    public static String getFQFieldName(String extensionName, String fieldName) {
        String fqFieldName = extensionName + "." + fieldName;
        return fqFieldName;
    }

    public static String getMetaExtensionNameFromFQMetaExtensionName(String fqFieldName) {
        String metaExtensionName = null;
        if (fqFieldName.indexOf(":") != -1) {
            String[] fqElements = fqFieldName.split(":");
            metaExtensionName = fqElements[1];
        }
        return metaExtensionName;
    }

    public static String getExtensionNameFromFQMetaExtensionName(String fqFieldName) {
        String[] fqElements = fqFieldName.split(":");
        return fqElements[0];
    }

    public static String getFQMetaExtensionName(String metaExtensionName, String extensionName) {
        String fqFieldName = extensionName + ":" + metaExtensionName;
        return fqFieldName;
    }

    public static String getMetaFieldName(String metaExtensionName, String extensionName, String fieldName) {
        String actualExtensionName = metaExtensionName;
        if (extensionName != null) {
            actualExtensionName = WikittyUtil.getFQMetaExtensionName(metaExtensionName, extensionName);
        }
        String metaFieldName = WikittyUtil.getFQFieldName(actualExtensionName, fieldName);
        return metaFieldName;
    }

    public static List<String> getIds(Iterable<? extends BusinessEntity> entities) {
        ArrayList<String> ids = new ArrayList<String>();
        if (entities != null) {
            for (BusinessEntity businessEntity : entities) {
                if (businessEntity == null) continue;
                ids.add(businessEntity.getWikittyId());
            }
        }
        return ids;
    }

    public static <E> E getFieldValueFromFQFieldName(String fqField, BusinessEntity entity) {
        return (E)entity.getField(WikittyUtil.getExtensionNameFromFQFieldName(fqField), WikittyUtil.getFieldNameFromFQFieldName(fqField));
    }

    public static <E> List<E> getFieldValuesFromFQFieldName(String fqField, Iterable<? extends BusinessEntity> entities) {
        ArrayList<E> fieldValues = new ArrayList<E>();
        if (entities != null) {
            for (BusinessEntity businessEntity : entities) {
                if (businessEntity == null) continue;
                E field = WikittyUtil.getFieldValueFromFQFieldName(fqField, businessEntity);
                fieldValues.add(field);
            }
        }
        return fieldValues;
    }

    public static String getUniqueLoginName() {
        String result = UUID.randomUUID().toString();
        try {
            String ipv4 = null;
            String ipv6 = null;
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface netint = e.nextElement();
                Enumeration<InetAddress> a = netint.getInetAddresses();
                while (a.hasMoreElements()) {
                    InetAddress ip = a.nextElement();
                    if (ip instanceof Inet4Address) {
                        if (ipv4 != null && !"127.0.0.1".equals(ipv4)) continue;
                        ipv4 = ip.getHostAddress();
                        continue;
                    }
                    if (ip instanceof Inet6Address) {
                        if (ipv6 != null) continue;
                        ipv6 = ip.getHostAddress();
                        continue;
                    }
                    log.error((Object)("Can't get ip from no ipv4 and no ipv6: " + ip));
                }
            }
            if (ipv4 != null) {
                result = ipv4 + "=" + result;
            } else if (ipv6 != null) {
                result = ipv6 + "=" + result;
            }
        }
        catch (Exception eee) {
            log.error((Object)"Can't compute unique name from network interface", (Throwable)eee);
        }
        return result;
    }

    @Deprecated
    public static Wikitty getWikitty(WikittyService service, String securityToken, BusinessEntity entity) {
        Wikitty result;
        if (entity instanceof BusinessEntityImpl) {
            result = ((BusinessEntityImpl)entity).getWikitty();
        } else {
            String id = entity.getWikittyId();
            result = WikittyServiceEnhanced.restore(service, securityToken, id);
            try {
                Field[] fields;
                Class<?> entityClass = entity.getClass();
                for (Field field : fields = entityClass.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(WikittyField.class)) continue;
                    WikittyField annotation = field.getAnnotation(WikittyField.class);
                    String fieldFQN = annotation.fqn();
                    Method m = entityClass.getMethod("get" + StringUtils.capitalize((String)field.getName()), new Class[0]);
                    Object value = m.invoke((Object)entity, new Object[0]);
                    result.setFqField(fieldFQN, value);
                }
            }
            catch (Exception eee) {
                throw new WikittyException("Could not transform entity to Wikitty", eee);
            }
            result.setVersion(entity.getWikittyVersion());
        }
        return result;
    }

    public static void copyBean(Object source, Object dest) throws Exception {
        BeanUtilsBean bu = BeanUtilsBean.getInstance();
        bu.getConvertUtils().register((Converter)dateConverter, Date.class);
        PropertyDescriptor[] origDescriptors = bu.getPropertyUtils().getPropertyDescriptors(source);
        for (int i = 0; i < origDescriptors.length; ++i) {
            String name = origDescriptors[i].getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("work on prop :" + name));
            }
            if ("class".equals(name) || "wikitty".equals(name) || !bu.getPropertyUtils().isReadable(source, name) || !bu.getPropertyUtils().isWriteable(dest, name)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("prop is copiable:" + name));
            }
            try {
                Object value = bu.getPropertyUtils().getSimpleProperty(source, name);
                bu.copyProperty(dest, name, value);
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    private static class WikittyDateConverter
    extends DateTimeConverter {
        private static Log log = LogFactory.getLog(WikittyDateConverter.class);
        private static final String PACKAGE = "org.apache.commons.beanutils.converters.";

        public WikittyDateConverter() {
        }

        public WikittyDateConverter(Object defaultValue) {
            super(defaultValue);
        }

        protected Class getDefaultType() {
            return Date.class;
        }

        public Object convert(Class type, Object value) {
            Class<?> sourceType = value == null ? null : value.getClass();
            Class targetType = this.primitive(type == null ? this.getDefaultType() : type);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Converting" + (value == null ? "" : " '" + this.toString(sourceType) + "'") + " value '" + value + "' to type '" + this.toString(targetType) + "'"));
            }
            if ((value = this.convertArray(value)) == null) {
                return null;
            }
            sourceType = value.getClass();
            try {
                if (targetType.equals(String.class)) {
                    return this.convertToString(value);
                }
                if (targetType.equals(sourceType)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("    No conversion required, value is already a " + this.toString(targetType)));
                    }
                    return value;
                }
                Object result = this.convertToType(targetType, value);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("    Converted to " + this.toString(targetType) + " value '" + result + "'"));
                }
                return result;
            }
            catch (Throwable t) {
                return this.handleError(targetType, value, t);
            }
        }

        Class primitive(Class type) {
            if (type == null || !type.isPrimitive()) {
                return type;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            return type;
        }

        String toString(Class type) {
            String typeName = null;
            if (type == null) {
                typeName = "null";
            } else if (type.isArray()) {
                Class<?> elementType = type.getComponentType();
                int count = 1;
                while (elementType.isArray()) {
                    elementType = elementType.getComponentType();
                    ++count;
                }
                typeName = elementType.getName();
                for (int i = 0; i < count; ++i) {
                    typeName = typeName + "[]";
                }
            } else {
                typeName = type.getName();
            }
            if (typeName.startsWith("java.lang.") || typeName.startsWith("java.util.") || typeName.startsWith("java.math.")) {
                typeName = typeName.substring("java.lang.".length());
            } else if (typeName.startsWith(PACKAGE)) {
                typeName = typeName.substring(PACKAGE.length());
            }
            return typeName;
        }
    }
}

