/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class VarFramingGenerator
implements RuleMethodProcessor {
    VarFramingGenerator() {
    }

    public boolean appliesTo(ParserClassNode classNode, RuleMethod method) {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        return method.getLocalVarVariables() != null;
    }

    public void process(ParserClassNode classNode, RuleMethod method) throws Exception {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        InsnList instructions = method.instructions;
        AbstractInsnNode ret = instructions.getLast();
        while (ret.getOpcode() != 176) {
            ret = ret.getPrevious();
        }
        instructions.insertBefore(ret, (AbstractInsnNode)new TypeInsnNode(187, Types.VAR_FRAMING_MATCHER.getInternalName()));
        instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(90));
        instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(95));
        this.createVarFieldArray(method, instructions, ret);
        instructions.insertBefore(ret, (AbstractInsnNode)new MethodInsnNode(183, Types.VAR_FRAMING_MATCHER.getInternalName(), "<init>", '(' + Types.RULE_DESC + '[' + Types.VAR_DESC + ")V"));
        method.setBodyRewritten();
    }

    private void createVarFieldArray(RuleMethod method, InsnList instructions, AbstractInsnNode ret) {
        int count = method.getLocalVarVariables().size();
        instructions.insertBefore(ret, (AbstractInsnNode)new IntInsnNode(16, count));
        instructions.insertBefore(ret, (AbstractInsnNode)new TypeInsnNode(189, Types.VAR.getInternalName()));
        for (int i = 0; i < count; ++i) {
            LocalVariableNode var = method.getLocalVarVariables().get(i);
            instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(89));
            instructions.insertBefore(ret, (AbstractInsnNode)new IntInsnNode(16, i));
            instructions.insertBefore(ret, (AbstractInsnNode)new VarInsnNode(25, var.index));
            instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(89));
            instructions.insertBefore(ret, (AbstractInsnNode)new LdcInsnNode((Object)(method.name + ':' + var.name)));
            instructions.insertBefore(ret, (AbstractInsnNode)new MethodInsnNode(182, Types.VAR.getInternalName(), "setName", "(Ljava/lang/String;)V"));
            instructions.insertBefore(ret, (AbstractInsnNode)new InsnNode(83));
        }
    }
}

