/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.tools.CompressTool;
import org.h2.util.MemoryUtils;

public class FileStoreInputStream
extends InputStream {
    private FileStore store;
    private DataPage page;
    private int remainingInBuffer;
    private CompressTool compress;
    private boolean endOfFile;
    private boolean alwaysClose;

    public FileStoreInputStream(FileStore fileStore, DataHandler dataHandler, boolean bl, boolean bl2) throws SQLException {
        this.store = fileStore;
        this.alwaysClose = bl2;
        if (bl) {
            this.compress = CompressTool.getInstance();
        }
        this.page = DataPage.create(dataHandler, 16);
        try {
            if (fileStore.length() <= 48L) {
                this.close();
            } else {
                this.fillBuffer();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, fileStore.name);
        }
    }

    public int available() {
        return this.remainingInBuffer <= 0 ? 0 : this.remainingInBuffer;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        int n4 = 0;
        while (n2 > 0 && (n3 = this.readBlock(byArray, n, n2)) >= 0) {
            n4 += n3;
            n += n3;
            n2 -= n3;
        }
        return n4 == 0 ? -1 : n4;
    }

    private int readBlock(byte[] byArray, int n, int n2) throws IOException {
        this.fillBuffer();
        if (this.endOfFile) {
            return -1;
        }
        int n3 = Math.min(this.remainingInBuffer, n2);
        this.page.read(byArray, n, n3);
        this.remainingInBuffer -= n3;
        return n3;
    }

    private void fillBuffer() throws IOException {
        if (this.remainingInBuffer > 0 || this.endOfFile) {
            return;
        }
        this.page.reset();
        try {
            this.store.openFile();
            if (this.store.length() == this.store.getFilePointer()) {
                this.close();
                return;
            }
            this.store.readFully(this.page.getBytes(), 0, 16);
        }
        catch (SQLException sQLException) {
            throw Message.convertToIOException(sQLException);
        }
        this.page.reset();
        this.remainingInBuffer = this.readInt();
        if (this.remainingInBuffer < 0) {
            this.close();
            return;
        }
        this.page.checkCapacity(this.remainingInBuffer);
        if (this.compress != null) {
            this.page.checkCapacity(4);
            this.readInt();
        }
        this.page.setPos(this.page.length() + this.remainingInBuffer);
        this.page.fillAligned();
        int n = this.page.length() - 16;
        this.page.reset();
        this.readInt();
        try {
            this.store.readFully(this.page.getBytes(), 16, n);
            this.page.reset();
            this.readInt();
            if (this.compress != null) {
                int n2 = this.readInt();
                byte[] byArray = MemoryUtils.newBytes(this.remainingInBuffer);
                this.page.read(byArray, 0, this.remainingInBuffer);
                this.page.reset();
                this.page.checkCapacity(n2);
                this.compress.expand(byArray, this.page.getBytes(), 0);
                this.remainingInBuffer = n2;
            }
        }
        catch (SQLException sQLException) {
            throw Message.convertToIOException(sQLException);
        }
        if (this.alwaysClose) {
            this.store.closeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.store != null) {
            try {
                this.store.close();
                this.endOfFile = true;
            }
            finally {
                this.store = null;
            }
        }
    }

    protected void finalize() {
        if (!SysProperties.runFinalize) {
            return;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int read() throws IOException {
        this.fillBuffer();
        if (this.endOfFile) {
            return -1;
        }
        int n = this.page.readByte() & 0xFF;
        --this.remainingInBuffer;
        return n;
    }

    private int readInt() {
        if (this.store.isTextMode()) {
            byte[] byArray = new byte[8];
            this.page.read(byArray, 0, 8);
            String string = new String(byArray);
            return Integer.parseInt(string, 16);
        }
        return this.page.readInt();
    }
}

